% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_KPCA.R
\name{do.kpca}
\alias{do.kpca}
\title{Kernel Principal Component Analysis}
\usage{
do.kpca(
  X,
  ndim = 2,
  preprocess = c("null", "center", "scale", "cscale", "whiten", "decorrelate"),
  kernel = c("gaussian", 1)
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{kernel}{a vector containing name of a kernel and corresponding parameters. See also \code{\link{aux.kernelcov}} for complete description of Kernel Trick.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{vars}{variances of projected data / eigenvalues from kernelized covariance matrix.}
}
}
\description{
Kernel principal component analysis (KPCA/Kernel PCA) is a nonlinear extension of classical
PCA using techniques called \href{https://en.wikipedia.org/wiki/Kernel_method}{kernel trick},
a common method of introducing nonlinearity by transforming, usually, covariance structure or
other gram-type estimate to make it flexible in Reproducing Kernel Hilbert Space.
}
\examples{
\donttest{
## load iris data
data(iris)
set.seed(100)
subid = sample(1:150,50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## try out different settings
output1 <- do.kpca(X)                         # default setting
output2 <- do.kpca(X,kernel=c("gaussian",5))  # gaussian kernel with large bandwidth
output3 <- do.kpca(X,kernel=c("laplacian",1)) # laplacian kernel

## visualize three different projections
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(output1$Y, col=label, pch=19, main="Gaussian kernel")
plot(output2$Y, col=label, pch=19, main="Gaussian kernel with sigma=5")
plot(output3$Y, col=label, pch=19, main="Laplacian kernel")
par(opar)
}

}
\references{
\insertRef{scholkopf_kernel_1997}{Rdimtools}
}
\seealso{
\code{\link{aux.kernelcov}}
}
\author{
Kisung You
}
\concept{nonlinear_methods}
