% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SPUFS.R
\name{do.spufs}
\alias{do.spufs}
\title{Structure Preserving Unsupervised Feature Selection}
\usage{
do.spufs(X, ndim = 2, preprocess = c("null", "center", "scale",
  "cscale", "whiten", "decorrelate"), alpha = 1, beta = 1,
  bandwidth = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}

\item{alpha}{nonnegative number to control sparsity in rows of matrix of representation coefficients.}

\item{beta}{nonnegative number to control the degree of local-structure preservation.}

\item{bandwidth}{positive number for Gaussian kernel bandwidth to define similarity.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
This unsupervised feature selection method is based on self-expression model, which means that
the cost function involves difference in self-representation. It does not explicitly
require learning the clusterings and different features are weighted individually
based on their relative importance. The cost function involves two penalties,
sparsity and preservation of local structure.
}
\examples{
\dontrun{
#### generate R12in72 dataset
X = aux.gensamples(dname="R12in72")

#### try different bandwidth values
out1 = do.spufs(X, bandwidth=0.1)
out2 = do.spufs(X, bandwidth=1)
out3 = do.spufs(X, bandwidth=10)

#### visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="SPUFS::bandwidth=0.1")
plot(out2$Y[,1], out2$Y[,2], main="SPUFS::bandwidth=1")
plot(out3$Y[,1], out3$Y[,2], main="SPUFS::bandwidth=10")
}

}
\references{
\insertRef{lu_structure_2018}{Rdimtools}
}
\author{
Kisung You
}
