% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SIR.R
\name{do.sir}
\alias{do.sir}
\title{Sliced Inverse Regression}
\usage{
do.sir(X, response, ndim = 2, h = max(2, round(nrow(X)/5)),
  preprocess = c("center", "decorrelate", "whiten"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{response}{a length-\eqn{n} vector of response variable.}

\item{ndim}{an integer-valued target dimension.}

\item{h}{the number of slices to divide the range of response vector.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center" and other options "decorrelate" and "whiten"
are supported. See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Sliced Inverse Regression (SIR) is a supervised linear dimension reduction technique.
Unlike engineering-driven methods, SIR takes a concept of \emph{central subspace}, where
conditional independence after projection is guaranteed. It first divides the range of
response variable. Projection vectors are extracted where projected data best explains response variable.
}
\examples{
## generate swiss roll with auxiliary dimensions
## it follows reference example from LSIR paper.
n = 123
theta = runif(n)
h     = runif(n)
t     = (1+2*theta)*(3*pi/2)
X     = array(0,c(n,10))
X[,1] = t*cos(t)
X[,2] = 21*h
X[,3] = t*sin(t)
X[,4:10] = matrix(runif(7*n), nrow=n)

## corresponding response vector
y = sin(5*pi*theta)+(runif(n)*sqrt(0.1))

## try with different numbers of slices
out1 = do.sir(X, y, h=2)
out2 = do.sir(X, y, h=5)
out3 = do.sir(X, y, h=10)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="SIR::2 slices")
plot(out2$Y[,1], out2$Y[,2], main="SIR::5 slices")
plot(out3$Y[,1], out3$Y[,2], main="SIR::10 slices")

}
\references{
\insertRef{li_sliced_1991}{Rdimtools}
}
\author{
Kisung You
}
