% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcssGet.R
\name{RcssGetPropertyValueOrDefault}
\alias{RcssGetPropertyValueOrDefault}
\title{Extracts a value for an Rcss property}
\usage{
RcssGetPropertyValueOrDefault(Rcss, selector, property, default = NULL,
  Rcssclass = NULL)
}
\arguments{
\item{Rcss}{style sheet object}

\item{selector}{name of selector of interest (e.g. "plot", "axis",
"text", etc.)}

\item{property}{name of property of interest (e.g. "col", "pch", etc.)}

\item{default}{value to return if the desired property is not defined
in Rcss}

\item{Rcssclass}{subclass of style sheet}
}
\description{
If the requested property is defined within an Rcss object, this
function will return the associated value. If the property is not
defined, the function returns a default value that can be passed
into the function and is set NULL otherwise. See also
RcssGetPropertyValue().
}
\details{
Equivalent to RcssValue(); use RcssValue() instead
}
