% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleClustering.R
\name{addClustering}
\alias{addClustering}
\title{Clustering addition}
\usage{
addClustering(clustering, new.clustering.name, new.cluster.summary, new.label)
}
\arguments{
\item{clustering}{list containing a set of clustering results.}

\item{new.clustering.name}{string naming the clustering to add.}

\item{new.cluster.summary}{summary object containing statistics about the new clustering.}

\item{new.label}{vector of labels}
}
\value{
updated list of clusterings.
}
\description{
adds a new clustering to an existing set of clusterings (replaces if exists).
}
\details{
addClustering adds a new clustering to an existing set of clusterings (replaces if exists)
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))

tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(file.features=tf)

res_new <- KmeansQuick(x$features$initial$x, K=3)
labels_new <- formatLabelSample(res_new$cluster, x)
cluster.summary.new <- clusterSummary(x, labels_new)

x$clustering <- addClustering(clustering=x$clustering, new.clustering.name='clusterin_test', 
                              new.cluster.summary=cluster.summary.new, new.label=labels_new)
 

}
\keyword{internal}
