% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KmeansAutoElbow.R
\name{KmeansAutoElbow}
\alias{KmeansAutoElbow}
\title{Kmeans clustering with automatic estimation of number of clusters}
\usage{
KmeansAutoElbow(features, Kmax, StopCriteria = 0.99, graph = F, Elbow = T)
}
\arguments{
\item{features}{matrix of raw data (point by line).}

\item{Kmax}{maximum number of clusters.}

\item{StopCriteria}{elbow method cumulative explained variance > criteria to stop K-search.}

\item{graph}{boolean: if TRUE, figures for total of within-class inertia and explained variance are plotted.}

\item{Elbow}{boolean: if TRUE, Elbow method is used for finding the knee point of a curve.}
}
\value{
The function returns a list containing:
\item{K}{number of clusters obtained by Elbow method.}
\item{res.kmeans}{results obtained from kmeans algorithm.}
}
\description{
Perform Elbow method and kmeans algorithm for the automatic estimation of the number of clusters and data clustering.
}
\details{
KmeansAutoElbow return partition and K number of groups according to kmeans clustering and Elbow method
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
           matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
           
res <- KmeansAutoElbow(dat, Kmax=20, graph=TRUE)

plot(dat[,1], dat[,2], type = "p", xlab = "x", ylab = "y", 
	col = res$res.kmeans$cluster, main = "K-means clustering")

}
\seealso{
\code{\link{KmeansQuick}}
}
\keyword{internal}
