% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivpml.R
\name{effect.ivpml}
\alias{effect.ivpml}
\alias{summary.effect.ivpml}
\alias{print.summary.effect.ivpml}
\title{Get average marginal effects for IV Probit model.}
\usage{
effect.ivpml(
  object,
  vcov = NULL,
  asf = TRUE,
  digits = max(3, getOption("digits") - 2),
  ...
)

\method{summary}{effect.ivpml}(object, ...)

\method{print}{summary.effect.ivpml}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{an object of class \code{ivpml} and \code{effect.ivpml} for \code{summary} and \code{print} method.}

\item{vcov}{an estimate of the asymptotic variance-covariance matrix of the parameters for a \code{ivpml} object.}

\item{asf}{if \code{TRUE}, the average structural function is used.}

\item{digits}{the number of digits.}

\item{...}{further arguments.Ignored.}

\item{x}{an object of class \code{effect.ivpml}.}
}
\value{
An object of class \code{effect.ivpml}.
}
\description{
Obtain the average marginal effects from \code{ivpml} class model.
}
\details{
This function allows to obtain the average marginal effects (not the marginal effects at the mean). The standard errors are computed using Delta Method.
}
