% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTicks.R
\name{getMultipleTicks}
\alias{getMultipleTicks}
\title{Get Multiple Ticks from Bloomberg}
\usage{
getMultipleTicks(security, eventType = c("TRADE", "BID", "ASK"),
  startTime = Sys.time() - 60 * 60, endTime = Sys.time(), verbose = FALSE,
  returnAs = getOption("blpType", "data.frame"), tz = Sys.getenv("TZ", unset
  = "UTC"), con = defaultConnection())
}
\arguments{
\item{security}{A character variable describing a valid security ticker}

\item{eventType}{A character vector describing event
types, default is \code{c("TRADE", "BID", "ASK")}}

\item{startTime}{A Datetime object with the start time, defaults
to one hour before current time}

\item{endTime}{A Datetime object with the end time, defaults
to current time}

\item{verbose}{A boolean indicating whether verbose operation is
desired, defaults to \sQuote{FALSE}}

\item{returnAs}{A character variable describing the type of return
object; currently supported are \sQuote{data.frame} (also the default)
and \sQuote{data.table}}

\item{tz}{A character variable with the desired local timezone,
defaulting to the value \sQuote{TZ} environment variable, and
\sQuote{UTC} if unset}

\item{con}{A connection object as created by a \code{blpConnect}
call, and retrieved via the internal function
\code{defaultConnection}.}
}
\value{
A numeric matrix with elements \sQuote{time}, (as a
\sQuote{POSIXct} object), \sQuote{values} and \sQuote{sizes}, or
an object of the type selected in \code{returnAs}.
}
\description{
This function uses the Bloomberg API to retrieve multiple ticks
for the requested security.
}
\author{
Dirk Eddelbuettel
}
