% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_utilities.R
\name{rvn_apply_wyearly_which_max_xts}
\alias{rvn_apply_wyearly_which_max_xts}
\title{which.max over water year periods}
\usage{
rvn_apply_wyearly_which_max_xts(x, mm = 9, dd = 30)
}
\arguments{
\item{x}{xts object}

\item{mm}{month of water year ending (default 9)}

\item{dd}{day of water year (default 30)}
}
\value{
{xts object with max values and corresponding dates}
}
\description{
Applies the which.max function within each
water year period, and returns the corresponding max values and dates in an xts format.
}
\examples{
data(rvn_hydrograph_data)

# obtain peak observed flows in each water year period
rvn_apply_wyearly_which_max_xts(rvn_hydrograph_data$hyd$Sub43_obs)

# will return a warning with no result if multiple columns supplied
rvn_apply_wyearly_which_max_xts(rvn_hydrograph_data$hyd)

}
