% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-brown-motion.R
\name{brownian_motion}
\alias{brownian_motion}
\title{Brownian Motion}
\usage{
brownian_motion(
  .num_walks = 25,
  .n = 100,
  .delta_time = 1,
  .initial_value = 0,
  .return_tibble = TRUE
)
}
\arguments{
\item{.num_walks}{Total number of simulations.}

\item{.n}{Total time of the simulation.}

\item{.delta_time}{Time step size.}

\item{.initial_value}{Integer representing the initial value.}

\item{.return_tibble}{The default is TRUE. If set to FALSE then an object
of class matrix will be returned.}
}
\value{
A tibble/matrix
}
\description{
Create a Brownian Motion Tibble
}
\details{
Brownian Motion, also known as the Wiener process, is a
continuous-time random process that describes the random movement of particles
suspended in a fluid. It is named after the physicist Robert Brown,
who first described the phenomenon in 1827.

The equation for Brownian Motion can be represented as:

\if{html}{\out{<div class="sourceCode">}}\preformatted{W(t) = W(0) + sqrt(t) * Z
}\if{html}{\out{</div>}}

Where W(t) is the Brownian motion at time t, W(0) is the initial value of the
Brownian motion, sqrt(t) is the square root of time, and Z is a standard
normal random variable.

Brownian Motion has numerous applications, including modeling stock prices in
financial markets, modeling particle movement in fluids, and modeling random
walk processes in general. It is a useful tool in probability theory and
statistical analysis.
}
\examples{
library(ggplot2)

set.seed(123)
brownian_motion()

set.seed(123)
brownian_motion() |>
  ggplot(aes(x = x, y = y, group = walk_number, color = walk_number)) +
  geom_line() +
  labs(title = "Brownian Motion", x = "Time", y = "Value") +
  theme_minimal() +
  theme(legend.position = "none")

}
\seealso{
Other Generator Functions: 
\code{\link{discrete_walk}()},
\code{\link{geometric_brownian_motion}()},
\code{\link{random_normal_drift_walk}()},
\code{\link{random_normal_walk}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Generator Functions}
