/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc.monotone;

import java.io.Serializable;
import weka.classifiers.misc.monotone.CumulativeDiscreteDistribution;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;

public class DiscreteDistribution
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = 1954630934425689828L;
    private static final double TOLERANCE = Utils.SMALL;
    private double[] m_dd;

    public DiscreteDistribution(DiscreteEstimator e) {
        this.m_dd = new double[e.getNumSymbols()];
        for (int i = 0; i < this.m_dd.length; ++i) {
            this.m_dd[i] = e.getProbability(i);
        }
    }

    public DiscreteDistribution(CumulativeDiscreteDistribution cdf) {
        this.m_dd = new double[cdf.getNumSymbols()];
        if (this.m_dd.length != 0) {
            this.m_dd[0] = cdf.getCumulativeProbability(0);
        }
        for (int i = 1; i < this.m_dd.length; ++i) {
            this.m_dd[i] = cdf.getCumulativeProbability(i) - cdf.getCumulativeProbability(i - 1);
        }
    }

    public DiscreteDistribution(double[] dd) throws IllegalArgumentException {
        if (!DiscreteDistribution.validDiscreteDistribution(dd)) {
            throw new IllegalArgumentException("Not a valid discrete distribution");
        }
        this.m_dd = new double[dd.length];
        System.arraycopy(dd, 0, this.m_dd, 0, dd.length);
    }

    public int getNumSymbols() {
        return this.m_dd != null ? this.m_dd.length : 0;
    }

    public double getProbability(int index) {
        return this.m_dd[index];
    }

    public double mean() {
        double mean = 0.0;
        for (int i = 1; i < this.m_dd.length; ++i) {
            mean += (double)i * this.m_dd[i];
        }
        return mean;
    }

    public double median() {
        double cr = this.m_dd[this.m_dd.length - 1];
        int i = 0;
        for (double cl = this.m_dd[0]; cl < 0.5; cl += this.m_dd[++i]) {
        }
        int j = this.m_dd.length - 1;
        while (cr < 0.5) {
            cr += this.m_dd[--j];
        }
        return i == j ? (double)i : (double)(i + j) / 2.0;
    }

    public int[] modes() {
        int[] mm = new int[this.m_dd.length];
        double max = this.m_dd[0];
        int nr = 1;
        for (int i = 1; i < this.m_dd.length; ++i) {
            if (this.m_dd[i] > max + TOLERANCE) {
                max = this.m_dd[i];
                mm[0] = i;
                nr = 1;
                continue;
            }
            if (!(Math.abs(this.m_dd[i] - max) < TOLERANCE)) continue;
            mm[nr++] = i;
        }
        int[] modes = new int[nr];
        System.arraycopy(mm, 0, modes, 0, nr);
        return modes;
    }

    public double[] toArray() {
        double[] dd = new double[this.m_dd.length];
        System.arraycopy(this.m_dd, 0, dd, 0, dd.length);
        return dd;
    }

    public String toString() {
        String s = "[" + this.getNumSymbols() + "]:";
        for (int i = 0; i < this.getNumSymbols(); ++i) {
            s = s + " " + this.getProbability(i);
        }
        return s;
    }

    public boolean stochasticDominatedBy(DiscreteDistribution dd) throws IllegalArgumentException {
        return new CumulativeDiscreteDistribution(this).stochasticDominatedBy(new CumulativeDiscreteDistribution(dd));
    }

    private static boolean validDiscreteDistribution(double[] dd) {
        if (dd == null || dd.length == 0) {
            return false;
        }
        double sum = 0.0;
        for (int i = 0; i < dd.length; ++i) {
            if (dd[i] < 0.0) {
                return false;
            }
            sum += dd[i];
        }
        return !(Math.abs(sum - 1.0) > TOLERANCE);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5922 $");
    }
}

