/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.meta.generators.RandomizableGenerator;
import weka.classifiers.meta.generators.Ranged;
import weka.core.Option;
import weka.core.Utils;

public abstract class RandomizableRangedGenerator
extends RandomizableGenerator
implements Ranged {
    private static final long serialVersionUID = -5766761200929361752L;
    protected double m_LowerRange = 0.0;
    protected double m_UpperRange = 1.0;

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            result.addElement(enu.nextElement());
        }
        result.addElement(new Option("\tSets the lower range of the generator\n\t(default: 0)", "L", 1, "-L <num>"));
        result.addElement(new Option("\tSets the upper range of the generator\n\t(default: 1)", "U", 1, "-U <num>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption("L", options);
        if (tmpStr.length() != 0) {
            this.setLowerRange(Double.parseDouble(tmpStr));
        } else {
            this.setLowerRange(0.0);
        }
        tmpStr = Utils.getOption("U", options);
        if (tmpStr.length() != 0) {
            this.setUpperRange(Double.parseDouble(tmpStr));
        } else {
            this.setUpperRange(1.0);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-L");
        result.add("" + this.m_LowerRange);
        result.add("-U");
        result.add("" + this.m_UpperRange);
        return result.toArray(new String[result.size()]);
    }

    public double getLowerRange() {
        return this.m_LowerRange;
    }

    public void setLowerRange(double value) {
        this.m_LowerRange = value;
    }

    public String lowerRangeTipText() {
        return "The lower range.";
    }

    public double getUpperRange() {
        return this.m_UpperRange;
    }

    public void setUpperRange(double value) {
        this.m_UpperRange = value;
    }

    public String upperRangeTipText() {
        return "The upper range.";
    }
}

