/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy;

import java.util.Enumeration;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.UpdateableClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class IB1
extends AbstractClassifier
implements UpdateableClassifier,
TechnicalInformationHandler {
    static final long serialVersionUID = -6152184127304895851L;
    private Instances m_Train;
    private double[] m_MinArray;
    private double[] m_MaxArray;

    public String globalInfo() {
        return "Nearest-neighbour classifier. Uses normalized Euclidean distance to find the training instance closest to the given test instance, and predicts the same class as this training instance. If multiple instances have the same (smallest) distance to the test instance, the first one found is used.\n\nFor more information, see \n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "D. Aha and D. Kibler");
        result.setValue(TechnicalInformation.Field.YEAR, "1991");
        result.setValue(TechnicalInformation.Field.TITLE, "Instance-based learning algorithms");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        result.setValue(TechnicalInformation.Field.VOLUME, "6");
        result.setValue(TechnicalInformation.Field.PAGES, "37-66");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Train = new Instances(instances, 0, instances.numInstances());
        this.m_MinArray = new double[this.m_Train.numAttributes()];
        this.m_MaxArray = new double[this.m_Train.numAttributes()];
        for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
            this.m_MaxArray[i] = Double.NaN;
            this.m_MinArray[i] = Double.NaN;
        }
        Enumeration enu = this.m_Train.enumerateInstances();
        while (enu.hasMoreElements()) {
            this.updateMinMax((Instance)enu.nextElement());
        }
    }

    public void updateClassifier(Instance instance) throws Exception {
        if (!this.m_Train.equalHeaders(instance.dataset())) {
            throw new Exception("Incompatible instance types\n" + this.m_Train.equalHeadersMsg(instance.dataset()));
        }
        if (instance.classIsMissing()) {
            return;
        }
        this.m_Train.add(instance);
        this.updateMinMax(instance);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_Train.numInstances() == 0) {
            throw new Exception("No training instances!");
        }
        double minDistance = Double.MAX_VALUE;
        double classValue = 0.0;
        this.updateMinMax(instance);
        Enumeration enu = this.m_Train.enumerateInstances();
        while (enu.hasMoreElements()) {
            double distance;
            Instance trainInstance = (Instance)enu.nextElement();
            if (trainInstance.classIsMissing() || !((distance = this.distance(instance, trainInstance)) < minDistance)) continue;
            minDistance = distance;
            classValue = trainInstance.classValue();
        }
        return classValue;
    }

    public String toString() {
        return "IB1 classifier";
    }

    private double distance(Instance first, Instance second) {
        double distance = 0.0;
        for (int i = 0; i < this.m_Train.numAttributes(); ++i) {
            double diff;
            if (i == this.m_Train.classIndex()) continue;
            if (this.m_Train.attribute(i).isNominal()) {
                if (!first.isMissing(i) && !second.isMissing(i) && (int)first.value(i) == (int)second.value(i)) continue;
                distance += 1.0;
                continue;
            }
            if (first.isMissing(i) || second.isMissing(i)) {
                if (first.isMissing(i) && second.isMissing(i)) {
                    diff = 1.0;
                } else {
                    diff = second.isMissing(i) ? this.norm(first.value(i), i) : this.norm(second.value(i), i);
                    if (diff < 0.5) {
                        diff = 1.0 - diff;
                    }
                }
            } else {
                diff = this.norm(first.value(i), i) - this.norm(second.value(i), i);
            }
            distance += diff * diff;
        }
        return distance;
    }

    private double norm(double x, int i) {
        if (Double.isNaN(this.m_MinArray[i]) || Utils.eq(this.m_MaxArray[i], this.m_MinArray[i])) {
            return 0.0;
        }
        return (x - this.m_MinArray[i]) / (this.m_MaxArray[i] - this.m_MinArray[i]);
    }

    private void updateMinMax(Instance instance) {
        for (int j = 0; j < this.m_Train.numAttributes(); ++j) {
            if (!this.m_Train.attribute(j).isNumeric() || instance.isMissing(j)) continue;
            if (Double.isNaN(this.m_MinArray[j])) {
                this.m_MinArray[j] = instance.value(j);
                this.m_MaxArray[j] = instance.value(j);
                continue;
            }
            if (instance.value(j) < this.m_MinArray[j]) {
                this.m_MinArray[j] = instance.value(j);
                continue;
            }
            if (!(instance.value(j) > this.m_MaxArray[j])) continue;
            this.m_MaxArray[j] = instance.value(j);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] argv) {
        IB1.runClassifier(new IB1(), argv);
    }
}

