/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class Resample
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 3119607037607101160L;
    protected double m_SampleSizePercent = 100.0;
    protected int m_RandomSeed = 1;
    protected boolean m_NoReplacement = false;
    protected boolean m_InvertSelection = false;

    public String globalInfo() {
        return "Produces a random subsample of a dataset using either sampling with replacement or without replacement. The original dataset must fit entirely in memory. The number of instances in the generated dataset may be specified. When used in batch mode, subsequent batches are NOT resampled.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tThe size of the output dataset, as a percentage of\n\tthe input dataset (default 100)", "Z", 1, "-Z <num>"));
        vector.addElement(new Option("\tDisables replacement of instances\n\t(default: with replacement)", "no-replacement", 0, "-no-replacement"));
        vector.addElement(new Option("\tInverts the selection - only available with '-no-replacement'.", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setRandomSeed(Integer.parseInt(string));
        } else {
            this.setRandomSeed(1);
        }
        string = Utils.getOption('Z', stringArray);
        if (string.length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(string));
        } else {
            this.setSampleSizePercent(100.0);
        }
        this.setNoReplacement(Utils.getFlag("no-replacement", stringArray));
        if (this.getNoReplacement()) {
            this.setInvertSelection(Utils.getFlag('V', stringArray));
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-S");
        vector.add("" + this.getRandomSeed());
        vector.add("-Z");
        vector.add("" + this.getSampleSizePercent());
        if (this.getNoReplacement()) {
            vector.add("-no-replacement");
            if (this.getInvertSelection()) {
                vector.add("-V");
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String randomSeedTipText() {
        return "The seed used for random sampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int n) {
        this.m_RandomSeed = n;
    }

    public String sampleSizePercentTipText() {
        return "Size of the subsample as a percentage of the original dataset.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSizePercent;
    }

    public void setSampleSizePercent(double d) {
        this.m_SampleSizePercent = d;
    }

    public String noReplacementTipText() {
        return "Disables the replacement of instances.";
    }

    public boolean getNoReplacement() {
        return this.m_NoReplacement;
    }

    public void setNoReplacement(boolean bl) {
        this.m_NoReplacement = bl;
    }

    public String invertSelectionTipText() {
        return "Inverts the selection (only if instances are drawn WITHOUT replacement).";
    }

    public boolean getInvertSelection() {
        return this.m_InvertSelection;
    }

    public void setInvertSelection(boolean bl) {
        this.m_InvertSelection = bl;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.createSubsample();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public void createSubsampleWithReplacement(Random random, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3 = random.nextInt(n);
            this.push((Instance)this.getInputFormat().instance(n3).copy());
        }
    }

    public void createSubsampleWithoutReplacement(Random random, int n, int n2) {
        int n3;
        if (n2 > n) {
            n2 = n;
            System.err.println("Resampling with replacement can only use percentage <=100% - Using full dataset!");
        }
        Vector<Integer> vector = new Vector<Integer>(n);
        Vector vector2 = new Vector(n2);
        for (n3 = 0; n3 < n; ++n3) {
            vector.add(n3);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = random.nextInt(vector.size());
            vector2.add(vector.get(n4));
            vector.remove(n4);
        }
        if (this.getInvertSelection()) {
            vector2 = vector;
        } else {
            Collections.sort(vector2);
        }
        for (n3 = 0; n3 < vector2.size(); ++n3) {
            this.push((Instance)this.getInputFormat().instance((Integer)vector2.get(n3)).copy());
        }
        vector.clear();
        vector2.clear();
        vector = null;
        vector2 = null;
    }

    protected void createSubsample() {
        int n = this.getInputFormat().numInstances();
        int n2 = (int)((double)n * this.m_SampleSizePercent / 100.0);
        Random random = new Random(this.m_RandomSeed);
        if (this.getNoReplacement()) {
            this.createSubsampleWithoutReplacement(random, n, n2);
        } else {
            this.createSubsampleWithReplacement(random, n, n2);
        }
    }

    public static void main(String[] stringArray) {
        Resample.runFilter(new Resample(), stringArray);
    }
}

