/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.ensembleSelection;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.zip.Adler32;
import weka.classifiers.Classifier;
import weka.classifiers.EnsembleLibraryModel;
import weka.classifiers.meta.ensembleSelection.EnsembleModelMismatchException;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class EnsembleSelectionLibraryModel
extends EnsembleLibraryModel
implements Serializable {
    private static final long serialVersionUID = -6426075459862947640L;
    public static final String FILE_EXTENSION = ".elm";
    private Classifier[] m_models = null;
    private int m_seed;
    private String m_checksum;
    private double m_validationRatio;
    private int m_folds;
    private String m_fileName;
    public transient boolean m_Debug = true;
    private double[][] m_validationPredictions = null;

    public EnsembleSelectionLibraryModel() {
    }

    public EnsembleSelectionLibraryModel(Classifier classifier, int seed, String checksum, double validationRatio, int folds) {
        super(classifier);
        this.m_seed = seed;
        this.m_checksum = checksum;
        this.m_validationRatio = validationRatio;
        this.m_models = null;
        this.m_folds = folds;
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public double[] getAveragePrediction(Instance instance) throws Exception {
        double[] average = new double[instance.numClasses()];
        for (int i = 0; i < this.m_folds; ++i) {
            Instance temp_instance = (Instance)instance.copy();
            double[] pred = this.getFoldPrediction(temp_instance, i);
            if (pred == null) {
                System.err.println("Null validation predictions given: " + this.getStringRepresentation());
                return null;
            }
            if (i == 0) {
                average = pred;
                continue;
            }
            for (int j = 0; j < pred.length; ++j) {
                int n = j;
                average[n] = average[n] + pred[j];
            }
        }
        if (instance.classAttribute().isNominal()) {
            Utils.normalize(average);
        } else {
            average[0] = average[0] / (double)this.m_folds;
        }
        return average;
    }

    public EnsembleSelectionLibraryModel(Classifier classifier) {
        super(classifier);
    }

    public double[] getFoldPrediction(Instance instance, int fold) throws Exception {
        return this.m_models[fold].distributionForInstance(instance);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createModel(Instances[] data, Instances[] hillclimbData, String dataDirectoryName, int algorithm) throws Exception {
        String modelFileName = EnsembleSelectionLibraryModel.getFileName(this.getStringRepresentation());
        File modelFile = new File(dataDirectoryName, modelFileName);
        String relativePath = new File(dataDirectoryName).getName() + File.separatorChar + modelFileName;
        this.setFileName(relativePath);
        if (!modelFile.exists()) {
            Date startTime = new Date();
            String lockFileName = EnsembleSelectionLibraryModel.getFileName(this.getStringRepresentation());
            File lockFile = new File(dataDirectoryName, lockFileName = lockFileName.substring(0, lockFileName.length() - 3) + "LCK");
            if (lockFile.exists()) {
                if (!this.m_Debug) throw new Exception("Lock File Detected: " + lockFile.getName());
                System.out.println("Detected lock file.  Skipping: " + lockFileName);
                throw new Exception("Lock File Detected: " + lockFile.getName());
            }
            if (lockFile.createNewFile()) {
                int i;
                if (this.m_Debug) {
                    System.out.println("lock file created: " + lockFileName);
                }
                if (this.m_Debug) {
                    System.out.println("Creating model in locked mode: " + modelFile.getPath());
                }
                this.m_models = new Classifier[this.m_folds];
                for (i = 0; i < this.m_folds; ++i) {
                    try {
                        this.m_models[i] = Classifier.forName(this.getModelClass().getName(), null);
                        this.m_models[i].setOptions(this.getOptions());
                        continue;
                    }
                    catch (Exception e) {
                        throw new Exception("Invalid Options: " + e.getMessage());
                    }
                }
                try {
                    for (i = 0; i < this.m_folds; ++i) {
                        this.train(data[i], i);
                    }
                }
                catch (Exception e) {
                    throw new Exception("Could not Train: " + e.getMessage());
                }
                Date endTime = new Date();
                int diff = (int)(endTime.getTime() - startTime.getTime());
                if (this.m_Debug) {
                    System.out.println("Train time for " + modelFileName + " was: " + diff);
                }
                if (this.m_Debug) {
                    System.out.println("Generating validation set predictions");
                }
                startTime = new Date();
                int total = 0;
                for (int i2 = 0; i2 < this.m_folds; ++i2) {
                    total += hillclimbData[i2].numInstances();
                }
                this.m_validationPredictions = new double[total][];
                int preds_index = 0;
                for (int i3 = 0; i3 < this.m_folds; ++i3) {
                    for (int j = 0; j < hillclimbData[i3].numInstances(); ++j) {
                        Instance temp = (Instance)hillclimbData[i3].instance(j).copy();
                        this.m_validationPredictions[preds_index] = this.getFoldPrediction(temp, i3);
                        if (this.m_validationPredictions[preds_index] == null) {
                            throw new Exception("Null validation predictions given: " + this.getStringRepresentation());
                        }
                        ++preds_index;
                    }
                }
                endTime = new Date();
                diff = (int)(endTime.getTime() - startTime.getTime());
                if (this.m_Debug) {
                    System.out.println("Time to create validation predictions was: " + diff);
                }
                EnsembleSelectionLibraryModel.saveModel(dataDirectoryName, this);
                if (this.m_Debug) {
                    System.out.println("deleting lock file: " + lockFileName);
                }
                lockFile.delete();
                return;
            }
            if (!this.m_Debug) throw new Exception("Could not create lock file.  Skipping: " + lockFile.getName());
            System.out.println("Could not create lock file.  Skipping: " + lockFileName);
            throw new Exception("Could not create lock file.  Skipping: " + lockFile.getName());
        }
        if (this.m_Debug) {
            System.out.println("Loading model: " + modelFile.getPath());
        }
        Date startTime = new Date();
        EnsembleSelectionLibraryModel newModel = EnsembleSelectionLibraryModel.loadModel(modelFile.getPath());
        if (!newModel.getStringRepresentation().equals(this.getStringRepresentation())) {
            throw new EnsembleModelMismatchException("String representations " + newModel.getStringRepresentation() + " and " + this.getStringRepresentation() + " not equal");
        }
        if (!newModel.getChecksum().equals(this.getChecksum())) {
            throw new EnsembleModelMismatchException("Checksums " + newModel.getChecksum() + " and " + this.getChecksum() + " not equal");
        }
        if (newModel.getSeed() != this.getSeed()) {
            throw new EnsembleModelMismatchException("Seeds " + newModel.getSeed() + " and " + this.getSeed() + " not equal");
        }
        if (newModel.getFolds() != this.getFolds()) {
            throw new EnsembleModelMismatchException("Folds " + newModel.getFolds() + " and " + this.getFolds() + " not equal");
        }
        if (newModel.getValidationRatio() != this.getValidationRatio()) {
            throw new EnsembleModelMismatchException("Validation Ratios " + newModel.getValidationRatio() + " and " + this.getValidationRatio() + " not equal");
        }
        this.m_models = newModel.getModels();
        this.m_validationPredictions = newModel.getValidationPredictions();
        Date endTime = new Date();
        int diff = (int)(endTime.getTime() - startTime.getTime());
        if (!this.m_Debug) return;
        System.out.println("Time to load " + modelFileName + " was: " + diff);
    }

    public void rehydrateModel(String workingDirectory) {
        if (this.m_models == null) {
            File file = new File(workingDirectory, this.m_fileName);
            if (this.m_Debug) {
                System.out.println("Rehydrating Model: " + file.getPath());
            }
            EnsembleSelectionLibraryModel model = EnsembleSelectionLibraryModel.loadModel(file.getPath());
            this.m_models = model.getModels();
        }
    }

    public void releaseModel() {
        this.m_models = null;
    }

    public void train(Instances trainData, int fold) throws Exception {
        if (this.m_models != null) {
            try {
                this.m_models[fold].buildClassifier(trainData);
            }
            catch (Throwable t) {
                this.m_models[fold] = null;
                throw new Exception("Exception caught while training: (null could mean out of memory)" + t.getMessage());
            }
        } else {
            throw new Exception("Cannot train: model was null");
        }
    }

    public void setSeed(int seed) {
        this.m_seed = seed;
    }

    public int getSeed() {
        return this.m_seed;
    }

    public void setValidationRatio(double validationRatio) {
        this.m_validationRatio = validationRatio;
    }

    public double getValidationRatio() {
        return this.m_validationRatio;
    }

    public void setFolds(int folds) {
        this.m_folds = folds;
    }

    public int getFolds() {
        return this.m_folds;
    }

    public void setChecksum(String instancesChecksum) {
        this.m_checksum = instancesChecksum;
    }

    public String getChecksum() {
        return this.m_checksum;
    }

    public Classifier[] getModels() {
        return this.m_models;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public static String getStringChecksum(String string) {
        String checksumString = null;
        try {
            Adler32 checkSummer = new Adler32();
            byte[] utf8 = string.toString().getBytes("UTF8");
            checkSummer.update(utf8);
            checksumString = Long.toHexString(checkSummer.getValue());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return checksumString;
    }

    public static String getFileName(String stringRepresentation) {
        String fileName = stringRepresentation.trim().replace(' ', '_').replace('\"', '_');
        if (fileName.length() > 115) {
            fileName = fileName.substring(0, 115);
        }
        fileName = fileName + EnsembleSelectionLibraryModel.getStringChecksum(stringRepresentation) + FILE_EXTENSION;
        return fileName;
    }

    public static void saveModel(String directory, EnsembleSelectionLibraryModel model) {
        try {
            String fileName = EnsembleSelectionLibraryModel.getFileName(model.getStringRepresentation());
            File file = new File(directory, fileName);
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
            out.writeObject(model);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static EnsembleSelectionLibraryModel loadModel(String modelFilePath) {
        EnsembleSelectionLibraryModel model = null;
        try {
            File file = new File(modelFilePath);
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            model = (EnsembleSelectionLibraryModel)in.readObject();
            in.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return model;
    }

    public double[][] getValidationPredictions() {
        return this.m_validationPredictions;
    }

    public void setValidationPredictions(double[][] predictions) {
        if (this.m_Debug) {
            System.out.println("Saving validation array of size " + predictions.length);
        }
        this.m_validationPredictions = new double[predictions.length][];
        System.arraycopy(predictions, 0, this.m_validationPredictions, 0, predictions.length);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

