/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.StreamableFilter;
import weka.filters.UnsupervisedFilter;

public class ChangeDateFormat
extends Filter
implements UnsupervisedFilter,
StreamableFilter,
OptionHandler {
    static final long serialVersionUID = -1609344074013448737L;
    private static final SimpleDateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private SingleIndex m_AttIndex = new SingleIndex("last");
    private SimpleDateFormat m_DateFormat = DEFAULT_FORMAT;
    private Attribute m_OutputAttribute;

    public String globalInfo() {
        return "Changes the date format used by a date attribute. This is most useful for converting to a format with less precision, for example, from an absolute date to day of year, etc. This changes the format string, and changes the date values to those that would be parsed by the new format.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.m_AttIndex.setUpper(instances.numAttributes() - 1);
        if (!instances.attribute(this.m_AttIndex.getIndex()).isDate()) {
            throw new UnsupportedAttributeTypeException("Chosen attribute not date.");
        }
        this.setOutputFormat();
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        int n;
        Instance instance2;
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (!(instance2 = (Instance)instance.copy()).isMissing(n = this.m_AttIndex.getIndex())) {
            double d = instance.value(n);
            try {
                d = this.m_OutputAttribute.parseDate(this.m_OutputAttribute.formatDate(d));
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Output date format couldn't parse its own output!!");
            }
            instance2.setValue(n, d);
        }
        this.push(instance2);
        return true;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(2);
        vector.addElement(new Option("\tSets the attribute index (default last).", "C", 1, "-C <col>"));
        vector.addElement(new Option("\tSets the output date format string (default corresponds to ISO-8601).", "F", 1, "-F <value index>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setAttributeIndex(string);
        } else {
            this.setAttributeIndex("last");
        }
        String string2 = Utils.getOption('F', stringArray);
        if (string2.length() != 0) {
            this.setDateFormat(string2);
        } else {
            this.setDateFormat(DEFAULT_FORMAT);
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[4];
        int n = 0;
        stringArray[n++] = "-C";
        stringArray[n++] = "" + this.getAttributeIndex();
        stringArray[n++] = "-F";
        stringArray[n++] = "" + this.getDateFormat().toPattern();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String attributeIndexTipText() {
        return "Sets which attribute to process. This attribute must be of type date (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndex() {
        return this.m_AttIndex.getSingleIndex();
    }

    public void setAttributeIndex(String string) {
        this.m_AttIndex.setSingleIndex(string);
    }

    public String dateFormatTipText() {
        return "The date format to change to. This should be a format understood by Java's SimpleDateFormat class.";
    }

    public SimpleDateFormat getDateFormat() {
        return this.m_DateFormat;
    }

    public void setDateFormat(String string) {
        this.setDateFormat(new SimpleDateFormat(string));
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat == null) {
            throw new NullPointerException();
        }
        this.m_DateFormat = simpleDateFormat;
    }

    private void setOutputFormat() {
        FastVector fastVector = new FastVector(this.getInputFormat().numAttributes());
        for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
            Attribute attribute = this.getInputFormat().attribute(i);
            if (i == this.m_AttIndex.getIndex()) {
                fastVector.addElement(new Attribute(attribute.name(), this.getDateFormat().toPattern()));
                continue;
            }
            fastVector.addElement(attribute.copy());
        }
        Instances instances = new Instances(this.getInputFormat().relationName(), fastVector, 0);
        instances.setClassIndex(this.getInputFormat().classIndex());
        this.m_OutputAttribute = instances.attribute(this.m_AttIndex.getIndex());
        this.setOutputFormat(instances);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5543 $");
    }

    public static void main(String[] stringArray) {
        ChangeDateFormat.runFilter(new ChangeDateFormat(), stringArray);
    }
}

