/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import weka.core.Attribute;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldRef
extends Expression {
    protected String m_fieldName = null;

    public FieldRef(Element element, FieldMetaInfo.Optype optype, ArrayList<Attribute> arrayList) throws Exception {
        super(optype, arrayList);
        this.m_fieldName = element.getAttribute("field");
        this.validateField();
    }

    @Override
    public void setFieldDefs(ArrayList<Attribute> arrayList) throws Exception {
        super.setFieldDefs(arrayList);
        this.validateField();
    }

    protected void validateField() throws Exception {
        if (this.m_fieldDefs != null) {
            Attribute attribute = this.getFieldDef(this.m_fieldName);
            if (attribute == null) {
                throw new Exception("[FieldRef] Can't find field " + this.m_fieldName + " in the supplied field definitions");
            }
            if ((this.m_opType == FieldMetaInfo.Optype.CATEGORICAL || this.m_opType == FieldMetaInfo.Optype.ORDINAL) && attribute.isNumeric()) {
                throw new IllegalArgumentException("[FieldRef] Optype is categorical/ordinal but matching parameter in the field definitions is not!");
            }
            if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS && attribute.isNominal()) {
                throw new IllegalArgumentException("[FieldRef] Optype is continuous but matching parameter in the field definitions is not!");
            }
        }
    }

    @Override
    public double getResult(double[] dArray) throws Exception {
        double d = Double.NaN;
        boolean bl = false;
        for (int i = 0; i < this.m_fieldDefs.size(); ++i) {
            Attribute attribute = (Attribute)this.m_fieldDefs.get(i);
            if (!attribute.name().equals(this.m_fieldName)) continue;
            if (attribute.isNumeric()) {
                if (this.m_opType == FieldMetaInfo.Optype.CATEGORICAL || this.m_opType == FieldMetaInfo.Optype.ORDINAL) {
                    throw new IllegalArgumentException("[FieldRef] Optype is categorical/ordinal but matching parameter is not!");
                }
            } else if (attribute.isNominal()) {
                if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
                    throw new IllegalArgumentException("[FieldRef] Optype is continuous but matching parameter is not!");
                }
            } else {
                throw new IllegalArgumentException("[FieldRef] Unhandled attribute type");
            }
            d = dArray[i];
            bl = true;
            break;
        }
        if (!bl) {
            throw new Exception("[FieldRef] this field: " + this.m_fieldName + " is not in the supplied " + "list of parameters!");
        }
        return d;
    }

    @Override
    public String getResultCategorical(double[] dArray) throws Exception {
        if (this.m_opType == FieldMetaInfo.Optype.CONTINUOUS) {
            throw new IllegalArgumentException("[FieldRef] Can't return result as categorical/ordinal because optype is continuous!");
        }
        boolean bl = false;
        String string = null;
        for (int i = 0; i < this.m_fieldDefs.size(); ++i) {
            Attribute attribute = (Attribute)this.m_fieldDefs.get(i);
            if (!attribute.name().equals(this.m_fieldName)) continue;
            bl = true;
            string = attribute.value((int)dArray[i]);
            break;
        }
        if (!bl) {
            throw new Exception("[FieldRef] this field: " + this.m_fieldName + " is not in the supplied " + "list of parameters!");
        }
        return string;
    }

    @Override
    public Attribute getOutputDef() {
        Attribute attribute = this.getFieldDef(this.m_fieldName);
        if (attribute != null) {
            return attribute;
        }
        return null;
    }

    @Override
    public String toString(String string) {
        return string + "FieldRef: " + this.m_fieldName;
    }
}

