/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class BVDecompose
implements OptionHandler,
TechnicalInformationHandler,
RevisionHandler {
    protected boolean m_Debug;
    protected Classifier m_Classifier = new ZeroR();
    protected String[] m_ClassifierOptions;
    protected int m_TrainIterations = 50;
    protected String m_DataFileName;
    protected int m_ClassIndex = -1;
    protected int m_Seed = 1;
    protected double m_Bias;
    protected double m_Variance;
    protected double m_Sigma;
    protected double m_Error;
    protected int m_TrainPoolSize = 100;

    public String globalInfo() {
        return "Class for performing a Bias-Variance decomposition on any classifier using the method specified in:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Ron Kohavi and David H. Wolpert");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1996");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Bias Plus Variance Decomposition for Zero-One Loss Functions");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Machine Learning: Proceedings of the Thirteenth International Conference");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "Lorenza Saitta");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "275-283");
        technicalInformation.setValue(TechnicalInformation.Field.PS, "http://robotics.stanford.edu/~ronnyk/biasVar.ps");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(7);
        vector.addElement(new Option("\tThe index of the class attribute.\n\t(default last)", "c", 1, "-c <class index>"));
        vector.addElement(new Option("\tThe name of the arff file used for the decomposition.", "t", 1, "-t <name of arff file>"));
        vector.addElement(new Option("\tThe number of instances placed in the training pool.\n\tThe remainder will be used for testing. (default 100)", "T", 1, "-T <training pool size>"));
        vector.addElement(new Option("\tThe random number seed used.", "s", 1, "-s <seed>"));
        vector.addElement(new Option("\tThe number of training repetitions used.\n\t(default 50)", "x", 1, "-x <num>"));
        vector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        vector.addElement(new Option("\tFull class name of the learner used in the decomposition.\n\teg: weka.classifiers.bayes.NaiveBayes", "W", 1, "-W <classifier class name>"));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to learner " + this.m_Classifier.getClass().getName() + ":"));
            Enumeration enumeration = this.m_Classifier.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        String string = Utils.getOption('c', stringArray);
        if (string.length() != 0) {
            if (string.toLowerCase().equals("last")) {
                this.setClassIndex(0);
            } else if (string.toLowerCase().equals("first")) {
                this.setClassIndex(1);
            } else {
                this.setClassIndex(Integer.parseInt(string));
            }
        } else {
            this.setClassIndex(0);
        }
        String string2 = Utils.getOption('x', stringArray);
        if (string2.length() != 0) {
            this.setTrainIterations(Integer.parseInt(string2));
        } else {
            this.setTrainIterations(50);
        }
        String string3 = Utils.getOption('T', stringArray);
        if (string3.length() != 0) {
            this.setTrainPoolSize(Integer.parseInt(string3));
        } else {
            this.setTrainPoolSize(100);
        }
        String string4 = Utils.getOption('s', stringArray);
        if (string4.length() != 0) {
            this.setSeed(Integer.parseInt(string4));
        } else {
            this.setSeed(1);
        }
        String string5 = Utils.getOption('t', stringArray);
        if (string5.length() == 0) {
            throw new Exception("An arff file must be specified with the -t option.");
        }
        this.setDataFileName(string5);
        String string6 = Utils.getOption('W', stringArray);
        if (string6.length() == 0) {
            throw new Exception("A learner must be specified with the -W option.");
        }
        this.setClassifier(Classifier.forName(string6, Utils.partitionOptions(stringArray)));
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            stringArray = this.m_Classifier.getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 14];
        int n = 0;
        if (this.getDebug()) {
            stringArray2[n++] = "-D";
        }
        stringArray2[n++] = "-c";
        stringArray2[n++] = "" + this.getClassIndex();
        stringArray2[n++] = "-x";
        stringArray2[n++] = "" + this.getTrainIterations();
        stringArray2[n++] = "-T";
        stringArray2[n++] = "" + this.getTrainPoolSize();
        stringArray2[n++] = "-s";
        stringArray2[n++] = "" + this.getSeed();
        if (this.getDataFileName() != null) {
            stringArray2[n++] = "-t";
            stringArray2[n++] = "" + this.getDataFileName();
        }
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public int getTrainPoolSize() {
        return this.m_TrainPoolSize;
    }

    public void setTrainPoolSize(int n) {
        this.m_TrainPoolSize = n;
    }

    public void setClassifier(Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setTrainIterations(int n) {
        this.m_TrainIterations = n;
    }

    public int getTrainIterations() {
        return this.m_TrainIterations;
    }

    public void setDataFileName(String string) {
        this.m_DataFileName = string;
    }

    public String getDataFileName() {
        return this.m_DataFileName;
    }

    public int getClassIndex() {
        return this.m_ClassIndex + 1;
    }

    public void setClassIndex(int n) {
        this.m_ClassIndex = n - 1;
    }

    public double getBias() {
        return this.m_Bias;
    }

    public double getVariance() {
        return this.m_Variance;
    }

    public double getSigma() {
        return this.m_Sigma;
    }

    public double getError() {
        return this.m_Error;
    }

    public void decompose() throws Exception {
        Object object;
        RevisionHandler revisionHandler;
        int n;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_DataFileName));
        Instances instances = new Instances(bufferedReader);
        if (this.m_ClassIndex < 0) {
            instances.setClassIndex(instances.numAttributes() - 1);
        } else {
            instances.setClassIndex(this.m_ClassIndex);
        }
        if (instances.classAttribute().type() != 1) {
            throw new Exception("Class attribute must be nominal");
        }
        int n2 = instances.numClasses();
        instances.deleteWithMissingClass();
        if (instances.checkForStringAttributes()) {
            throw new Exception("Can't handle string attributes!");
        }
        if (instances.numInstances() < 2 * this.m_TrainPoolSize) {
            throw new Exception("The dataset must contain at least " + 2 * this.m_TrainPoolSize + " instances");
        }
        Random random = new Random(this.m_Seed);
        instances.randomize(random);
        Instances instances2 = new Instances(instances, 0, this.m_TrainPoolSize);
        Instances instances3 = new Instances(instances, this.m_TrainPoolSize, instances.numInstances() - this.m_TrainPoolSize);
        int n3 = instances3.numInstances();
        double[][] dArray = new double[n3][n2];
        this.m_Error = 0.0;
        for (n = 0; n < this.m_TrainIterations; ++n) {
            if (this.m_Debug) {
                System.err.println("Iteration " + (n + 1));
            }
            instances2.randomize(random);
            revisionHandler = new Instances(instances2, 0, this.m_TrainPoolSize / 2);
            object = Classifier.makeCopy(this.m_Classifier);
            ((Classifier)object).buildClassifier((Instances)revisionHandler);
            for (int i = 0; i < n3; ++i) {
                int n4 = (int)((Classifier)object).classifyInstance(instances3.instance(i));
                if ((double)n4 != instances3.instance(i).classValue()) {
                    this.m_Error += 1.0;
                }
                double[] dArray2 = dArray[i];
                int n5 = n4;
                dArray2[n5] = dArray2[n5] + 1.0;
            }
        }
        this.m_Error /= (double)(this.m_TrainIterations * n3);
        this.m_Bias = 0.0;
        this.m_Variance = 0.0;
        this.m_Sigma = 0.0;
        for (n = 0; n < n3; ++n) {
            revisionHandler = instances3.instance(n);
            object = dArray[n];
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < n2; ++i) {
                double d4 = ((Instance)revisionHandler).classValue() == (double)i ? 1.0 : 0.0;
                reference var14_16 = object[i] / (double)this.m_TrainIterations;
                d += (d4 - var14_16) * (d4 - var14_16) - var14_16 * (1.0 - var14_16) / (double)(this.m_TrainIterations - 1);
                d2 += var14_16 * var14_16;
                d3 += d4 * d4;
            }
            this.m_Bias += d;
            this.m_Variance += 1.0 - d2;
            this.m_Sigma += 1.0 - d3;
        }
        this.m_Bias /= (double)(2 * n3);
        this.m_Variance /= (double)(2 * n3);
        this.m_Sigma /= (double)(2 * n3);
        if (this.m_Debug) {
            System.err.println("Decomposition finished");
        }
    }

    public String toString() {
        String string = "\nBias-Variance Decomposition\n";
        if (this.getClassifier() == null) {
            return "Invalid setup";
        }
        string = string + "\nClassifier   : " + this.getClassifier().getClass().getName();
        if (this.getClassifier() instanceof OptionHandler) {
            string = string + Utils.joinOptions(this.m_Classifier.getOptions());
        }
        string = string + "\nData File    : " + this.getDataFileName();
        string = string + "\nClass Index  : ";
        string = this.getClassIndex() == 0 ? string + "last" : string + this.getClassIndex();
        string = string + "\nTraining Pool: " + this.getTrainPoolSize();
        string = string + "\nIterations   : " + this.getTrainIterations();
        string = string + "\nSeed         : " + this.getSeed();
        string = string + "\nError        : " + Utils.doubleToString(this.getError(), 6, 4);
        string = string + "\nSigma^2      : " + Utils.doubleToString(this.getSigma(), 6, 4);
        string = string + "\nBias^2       : " + Utils.doubleToString(this.getBias(), 6, 4);
        string = string + "\nVariance     : " + Utils.doubleToString(this.getVariance(), 6, 4);
        return string + "\n";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.15 $");
    }

    public static void main(String[] stringArray) {
        try {
            BVDecompose bVDecompose = new BVDecompose();
            try {
                bVDecompose.setOptions(stringArray);
                Utils.checkForRemainingOptions(stringArray);
            }
            catch (Exception exception) {
                String string = exception.getMessage() + "\nBVDecompose Options:\n\n";
                Enumeration enumeration = bVDecompose.listOptions();
                while (enumeration.hasMoreElements()) {
                    Option option = (Option)enumeration.nextElement();
                    string = string + option.synopsis() + "\n" + option.description() + "\n";
                }
                throw new Exception(string);
            }
            bVDecompose.decompose();
            System.out.println(bVDecompose.toString());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }
}

