/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml.consumer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.pmml.DerivedFieldMetaInfo;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.MiningSchema;
import weka.core.pmml.NormContinuous;
import weka.core.pmml.TargetMetaInfo;

public class NeuralNetwork
extends PMMLClassifier {
    private static final long serialVersionUID = -4545904813133921249L;
    protected MiningFunction m_functionType = MiningFunction.CLASSIFICATION;
    protected ActivationFunction m_activationFunction = ActivationFunction.ARCTAN;
    protected Normalization m_normalizationMethod = Normalization.NONE;
    protected double m_threshold = 0.0;
    protected double m_width = Double.NaN;
    protected double m_altitude = 1.0;
    protected int m_numberOfInputs = 0;
    protected int m_numberOfLayers = 0;
    protected NeuralInput[] m_inputs = null;
    protected HashMap<String, Double> m_inputMap = new HashMap();
    protected NeuralLayer[] m_layers = null;
    protected NeuralOutputs m_outputs = null;

    public NeuralNetwork(Element element, Instances instances, MiningSchema miningSchema) throws Exception {
        super(instances, miningSchema);
        Object object;
        String string;
        String string2;
        Object object22;
        Object object3;
        String string3;
        String string4 = element.getAttribute("functionName");
        if (string4.equals("regression")) {
            this.m_functionType = MiningFunction.REGRESSION;
        }
        if ((string3 = element.getAttribute("activationFunction")) == null || string3.length() == 0) {
            throw new Exception("[NeuralNetwork] no activation functon defined");
        }
        Object object4 = ActivationFunction.values();
        int n = ((ActivationFunction[])object4).length;
        for (int i = 0; i < n; ++i) {
            object3 = object4[i];
            if (!object3.toString().equals(string3)) continue;
            this.m_activationFunction = object3;
            break;
        }
        if ((object4 = element.getAttribute("normalizationMethod")) != null && ((String)object4).length() > 0) {
            for (Object object22 : Normalization.values()) {
                if (!object22.toString().equals(object4)) continue;
                this.m_normalizationMethod = object22;
                break;
            }
        }
        if ((string2 = element.getAttribute("threshold")) != null && string2.length() > 0) {
            this.m_threshold = Double.parseDouble(string2);
        }
        if ((string = element.getAttribute("width")) != null && string.length() > 0) {
            this.m_width = Double.parseDouble(string);
        }
        if ((object3 = element.getAttribute("altitude")) != null && ((String)object3).length() > 0) {
            this.m_altitude = Double.parseDouble((String)object3);
        }
        object22 = element.getElementsByTagName("NeuralInput");
        this.m_numberOfInputs = object22.getLength();
        this.m_inputs = new NeuralInput[this.m_numberOfInputs];
        for (int i = 0; i < this.m_numberOfInputs; ++i) {
            Node node = object22.item(i);
            if (node.getNodeType() != 1) continue;
            object = new NeuralInput((Element)node, this.m_miningSchema);
            this.m_inputs[i] = object;
        }
        NodeList nodeList = element.getElementsByTagName("NeuralLayer");
        this.m_numberOfLayers = nodeList.getLength();
        this.m_layers = new NeuralLayer[this.m_numberOfLayers];
        for (int i = 0; i < this.m_numberOfLayers; ++i) {
            NeuralLayer neuralLayer;
            object = nodeList.item(i);
            if (object.getNodeType() != 1) continue;
            this.m_layers[i] = neuralLayer = new NeuralLayer((Element)object);
        }
        NodeList nodeList2 = element.getElementsByTagName("NeuralOutputs");
        if (nodeList2.getLength() != 1) {
            throw new Exception("[NeuralNetwork] Should be just one NeuralOutputs element defined!");
        }
        this.m_outputs = new NeuralOutputs((Element)nodeList2.item(0), this.m_miningSchema);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5562 $");
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        if (!this.m_initialized) {
            this.mapToMiningSchema(instance.dataset());
        }
        double[] dArray = null;
        dArray = this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric() ? new double[1] : new double[this.m_miningSchema.getFieldsAsInstances().classAttribute().numValues()];
        double[] dArray2 = this.m_fieldsMap.instanceToSchema(instance, this.m_miningSchema);
        boolean bl = false;
        for (n = 0; n < dArray2.length; ++n) {
            if (n == this.m_miningSchema.getFieldsAsInstances().classIndex() || !Double.isNaN(dArray2[n])) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (!this.m_miningSchema.hasTargetMetaData()) {
                String string = "[NeuralNetwork] WARNING: Instance to predict has missing value(s) but there is no missing value handling meta data and no prior probabilities/default value to fall back to. No prediction will be made (" + (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNominal() || this.m_miningSchema.getFieldsAsInstances().classAttribute().isString() ? "zero probabilities output)." : "NaN output).");
                if (this.m_log == null) {
                    System.err.println(string);
                } else {
                    this.m_log.logMessage(string);
                }
                if (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric()) {
                    dArray[0] = Instance.missingValue();
                }
                return dArray;
            }
            TargetMetaInfo targetMetaInfo = this.m_miningSchema.getTargetMetaData();
            if (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric()) {
                dArray[0] = targetMetaInfo.getDefaultValue();
            } else {
                Instances instances = this.m_miningSchema.getFieldsAsInstances();
                for (int i = 0; i < instances.classAttribute().numValues(); ++i) {
                    dArray[i] = targetMetaInfo.getPriorProbability(instances.classAttribute().value(i));
                }
            }
            return dArray;
        }
        this.m_inputMap.clear();
        for (n = 0; n < this.m_inputs.length; ++n) {
            double d = this.m_inputs[n].getValue(dArray2);
            String string = this.m_inputs[n].getID();
            this.m_inputMap.put(string, d);
        }
        HashMap<String, Double> hashMap = this.m_layers[0].computeOutput(this.m_inputMap);
        for (int i = 1; i < this.m_layers.length; ++i) {
            hashMap = this.m_layers[i].computeOutput(hashMap);
        }
        this.m_outputs.getOuput(hashMap, dArray);
        return dArray;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PMML version " + this.getPMMLVersion());
        if (!this.getCreatorApplication().equals("?")) {
            stringBuffer.append("\nApplication: " + this.getCreatorApplication());
        }
        stringBuffer.append("\nPMML Model: Neural network");
        stringBuffer.append("\n\n");
        stringBuffer.append(this.m_miningSchema);
        stringBuffer.append("Inputs:\n");
        for (n = 0; n < this.m_inputs.length; ++n) {
            stringBuffer.append(this.m_inputs[n] + "\n");
        }
        for (n = 0; n < this.m_layers.length; ++n) {
            stringBuffer.append("Layer: " + (n + 1) + "\n");
            stringBuffer.append(this.m_layers[n] + "\n");
        }
        stringBuffer.append("Outputs:\n");
        stringBuffer.append(this.m_outputs);
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Normalization {
        NONE("none"),
        SIMPLEMAX("simplemax"),
        SOFTMAX("softmax");

        private final String m_stringVal;

        private Normalization(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ActivationFunction {
        THRESHOLD("threshold"){

            double eval(double d, double d2, double d3, double d4) {
                if (d > d2) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        ,
        LOGISTIC("logistic"){

            double eval(double d, double d2, double d3, double d4) {
                return 1.0 / (1.0 + Math.exp(-d));
            }
        }
        ,
        TANH("tanh"){

            double eval(double d, double d2, double d3, double d4) {
                double d5 = Math.exp(d);
                double d6 = Math.exp(-d);
                return (d5 - d6) / (d5 + d6);
            }
        }
        ,
        IDENTITY("identity"){

            double eval(double d, double d2, double d3, double d4) {
                return d;
            }
        }
        ,
        EXPONENTIAL("exponential"){

            double eval(double d, double d2, double d3, double d4) {
                return Math.exp(d);
            }
        }
        ,
        RECIPROCAL("reciprocal"){

            double eval(double d, double d2, double d3, double d4) {
                return 1.0 / d;
            }
        }
        ,
        SQUARE("square"){

            double eval(double d, double d2, double d3, double d4) {
                return d * d;
            }
        }
        ,
        GAUSS("gauss"){

            double eval(double d, double d2, double d3, double d4) {
                return Math.exp(-(d * d));
            }
        }
        ,
        SINE("sine"){

            double eval(double d, double d2, double d3, double d4) {
                return Math.sin(d);
            }
        }
        ,
        COSINE("cosine"){

            double eval(double d, double d2, double d3, double d4) {
                return Math.cos(d);
            }
        }
        ,
        ELLICOT("ellicot"){

            double eval(double d, double d2, double d3, double d4) {
                return d / (1.0 + Math.abs(d));
            }
        }
        ,
        ARCTAN("arctan"){

            double eval(double d, double d2, double d3, double d4) {
                return 2.0 * Math.atan(d) / Math.PI;
            }
        }
        ,
        RADIALBASIS("radialBasis"){

            double eval(double d, double d2, double d3, double d4) {
                return Math.exp(d4 * Math.log(d3) - d);
            }
        };

        private final String m_stringVal;

        abstract double eval(double var1, double var3, double var5, double var7);

        private ActivationFunction(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MiningFunction {
        CLASSIFICATION,
        REGRESSION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NeuralOutputs
    implements Serializable {
        private static final long serialVersionUID = -233611113950482952L;
        private String[] m_outputNeurons = null;
        private int[] m_categoricalIndexes = null;
        private Attribute m_classAttribute = null;
        private NormContinuous m_regressionMapping = null;

        protected NeuralOutputs(Element element, MiningSchema miningSchema) throws Exception {
            this.m_classAttribute = miningSchema.getMiningSchemaAsInstances().classAttribute();
            int n = this.m_classAttribute.isNumeric() ? 1 : this.m_classAttribute.numValues();
            this.m_outputNeurons = new String[n];
            this.m_categoricalIndexes = new int[n];
            NodeList nodeList = element.getElementsByTagName("NeuralOutput");
            if (nodeList.getLength() != this.m_outputNeurons.length) {
                throw new Exception("[NeuralOutputs] the number of neural outputs does not match the number expected!");
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Node node;
                NodeList nodeList2;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                Element element2 = (Element)node2;
                this.m_outputNeurons[i] = element2.getAttribute("outputNeuron");
                if (this.m_classAttribute.isNumeric()) {
                    nodeList2 = element2.getElementsByTagName("NormContinuous");
                    if (nodeList2.getLength() != 1) {
                        throw new Exception("[NeuralOutputs] Should be exactly one norm continuous element for numeric class!");
                    }
                    node = nodeList2.item(0);
                    string = ((Element)node).getAttribute("field");
                    Attribute attribute = new Attribute(string);
                    ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
                    arrayList.add(attribute);
                    this.m_regressionMapping = new NormContinuous((Element)node, FieldMetaInfo.Optype.CONTINUOUS, arrayList);
                    break;
                }
                nodeList2 = element2.getElementsByTagName("NormDiscrete");
                if (nodeList2.getLength() != 1) {
                    throw new Exception("[NeuralOutputs] Should be only one norm discrete element per derived field/neural output for a nominal class!");
                }
                node = nodeList2.item(0);
                string = ((Element)node).getAttribute("value");
                int n2 = this.m_classAttribute.indexOfValue(string);
                if (n2 < 0) {
                    throw new Exception("[NeuralOutputs] Can't find specified target value " + string + " in class attribute " + this.m_classAttribute.name());
                }
                this.m_categoricalIndexes[i] = n2;
            }
        }

        protected void getOuput(HashMap<String, Double> hashMap, double[] dArray) throws Exception {
            if (dArray.length != this.m_outputNeurons.length) {
                throw new Exception("[NeuralOutputs] Incorrect number of predictions requested: " + dArray.length + "requested, " + this.m_outputNeurons.length + " expected");
            }
            for (int i = 0; i < this.m_outputNeurons.length; ++i) {
                Double d = hashMap.get(this.m_outputNeurons[i]);
                if (d == null) {
                    throw new Exception("[NeuralOutputs] Unable to find output neuron " + this.m_outputNeurons[i] + " in the incoming HashMap!!");
                }
                if (this.m_classAttribute.isNumeric()) {
                    dArray[0] = d;
                    dArray[0] = this.m_regressionMapping.getResultInverse(dArray);
                    continue;
                }
                dArray[this.m_categoricalIndexes[i]] = d;
            }
            if (this.m_classAttribute.isNominal()) {
                double d = dArray[Utils.minIndex(dArray)];
                if (d < 0.0) {
                    int n = 0;
                    while (n < dArray.length) {
                        int n2 = n++;
                        dArray[n2] = dArray[n2] - d;
                    }
                }
                Utils.normalize(dArray);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.m_outputNeurons.length; ++i) {
                stringBuffer.append("Output neuron (" + this.m_outputNeurons[i] + ")\n");
                stringBuffer.append("mapping:\n");
                if (this.m_classAttribute.isNumeric()) {
                    stringBuffer.append(this.m_regressionMapping + "\n");
                    continue;
                }
                stringBuffer.append(this.m_classAttribute.name() + " = " + this.m_classAttribute.value(this.m_categoricalIndexes[i]) + "\n");
            }
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Neuron
    implements Serializable {
        private static final long serialVersionUID = -3817434025682603443L;
        private String m_ID = null;
        private NeuralLayer m_layer;
        private double m_bias = 0.0;
        private double m_neuronWidth = Double.NaN;
        private double m_neuronAltitude = Double.NaN;
        private String[] m_connectionIDs = null;
        private double[] m_weights = null;

        protected Neuron(Element element, NeuralLayer neuralLayer) {
            String string;
            String string2;
            this.m_layer = neuralLayer;
            this.m_ID = element.getAttribute("id");
            String string3 = element.getAttribute("bias");
            if (string3 != null && string3.length() > 0) {
                this.m_bias = Double.parseDouble(string3);
            }
            if ((string2 = element.getAttribute("width")) != null && string2.length() > 0) {
                this.m_neuronWidth = Double.parseDouble(string2);
            }
            if ((string = element.getAttribute("altitude")) != null && string.length() > 0) {
                this.m_neuronAltitude = Double.parseDouble(string);
            }
            NodeList nodeList = element.getElementsByTagName("Con");
            this.m_connectionIDs = new String[nodeList.getLength()];
            this.m_weights = new double[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                this.m_connectionIDs[i] = element2.getAttribute("from");
                String string4 = element2.getAttribute("weight");
                this.m_weights[i] = Double.parseDouble(string4);
            }
        }

        protected String getID() {
            return this.m_ID;
        }

        protected double getValue(HashMap<String, Double> hashMap) throws Exception {
            double d;
            double d2 = 0.0;
            double d3 = Double.NaN;
            double d4 = Double.isNaN(this.m_neuronWidth) ? this.m_layer.getWidth() : this.m_neuronWidth;
            d2 = this.m_bias;
            for (int i = 0; i < this.m_connectionIDs.length; ++i) {
                Double d5 = hashMap.get(this.m_connectionIDs[i]);
                if (d5 == null) {
                    throw new Exception("[Neuron] unable to find connection " + this.m_connectionIDs[i] + " in input Map!");
                }
                if (this.m_layer.getActivationFunction() != ActivationFunction.RADIALBASIS) {
                    d = d5 * this.m_weights[i];
                    d2 += d;
                    continue;
                }
                d = Math.pow(d5 - this.m_weights[i], 2.0);
                d2 += d;
            }
            if (this.m_layer.getActivationFunction() == ActivationFunction.RADIALBASIS) {
                d2 /= 2.0 * (d4 * d4);
            }
            double d6 = this.m_layer.getThreshold();
            d = Double.isNaN(this.m_neuronAltitude) ? this.m_layer.getAltitude() : this.m_neuronAltitude;
            double d7 = this.m_connectionIDs.length;
            d3 = this.m_layer.getActivationFunction().eval(d2, d6, d, d7);
            return d3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Nueron (" + this.m_ID + ") [bias:" + this.m_bias);
            if (!Double.isNaN(this.m_neuronWidth)) {
                stringBuffer.append(" width:" + this.m_neuronWidth);
            }
            if (!Double.isNaN(this.m_neuronAltitude)) {
                stringBuffer.append(" altitude:" + this.m_neuronAltitude);
            }
            stringBuffer.append("]\n");
            stringBuffer.append("  con. (ID:weight): ");
            for (int i = 0; i < this.m_connectionIDs.length; ++i) {
                stringBuffer.append(this.m_connectionIDs[i] + ":" + Utils.doubleToString(this.m_weights[i], 2));
                if ((i + 1) % 10 == 0 || i == this.m_connectionIDs.length - 1) {
                    stringBuffer.append("\n                    ");
                    continue;
                }
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NeuralLayer
    implements Serializable {
        private static final long serialVersionUID = -8386042001675763922L;
        private int m_numNeurons = 0;
        private ActivationFunction m_layerActivationFunction = null;
        private double m_layerThreshold = Double.NaN;
        private double m_layerWidth = Double.NaN;
        private double m_layerAltitude = Double.NaN;
        private Normalization m_layerNormalization = null;
        private Neuron[] m_layerNeurons = null;
        private HashMap<String, Double> m_layerOutput = new HashMap();

        protected NeuralLayer(Element element) {
            Object object;
            Object object2;
            String string = element.getAttribute("activationFunction");
            if (string != null && string.length() > 0) {
                object2 = ActivationFunction.values();
                int n = ((ActivationFunction[])object2).length;
                for (int i = 0; i < n; ++i) {
                    object = object2[i];
                    if (!((ActivationFunction)((Object)object)).toString().equals(string)) continue;
                    this.m_layerActivationFunction = object;
                    break;
                }
            } else {
                this.m_layerActivationFunction = NeuralNetwork.this.m_activationFunction;
            }
            this.m_layerThreshold = (object2 = element.getAttribute("threshold")) != null && ((String)object2).length() > 0 ? Double.parseDouble((String)object2) : NeuralNetwork.this.m_threshold;
            String string2 = element.getAttribute("width");
            this.m_layerWidth = string2 != null && string2.length() > 0 ? Double.parseDouble(string2) : NeuralNetwork.this.m_width;
            String string3 = element.getAttribute("altitude");
            this.m_layerAltitude = string3 != null && string3.length() > 0 ? Double.parseDouble(string3) : NeuralNetwork.this.m_altitude;
            object = element.getAttribute("normalizationMethod");
            if (object != null && ((String)object).length() > 0) {
                for (Normalization normalization : Normalization.values()) {
                    if (!normalization.toString().equals(object)) continue;
                    this.m_layerNormalization = normalization;
                    break;
                }
            } else {
                this.m_layerNormalization = NeuralNetwork.this.m_normalizationMethod;
            }
            NodeList nodeList = element.getElementsByTagName("Neuron");
            this.m_numNeurons = nodeList.getLength();
            this.m_layerNeurons = new Neuron[this.m_numNeurons];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                this.m_layerNeurons[i] = new Neuron((Element)node, this);
            }
        }

        protected ActivationFunction getActivationFunction() {
            return this.m_layerActivationFunction;
        }

        protected double getThreshold() {
            return this.m_layerThreshold;
        }

        protected double getWidth() {
            return this.m_layerWidth;
        }

        protected double getAltitude() {
            return this.m_layerAltitude;
        }

        protected Normalization getNormalization() {
            return this.m_layerNormalization;
        }

        protected HashMap<String, Double> computeOutput(HashMap<String, Double> hashMap) throws Exception {
            double d;
            int n;
            this.m_layerOutput.clear();
            double d2 = 0.0;
            for (n = 0; n < this.m_layerNeurons.length; ++n) {
                d = this.m_layerNeurons[n].getValue(hashMap);
                String string = this.m_layerNeurons[n].getID();
                if (this.m_layerNormalization == Normalization.SOFTMAX) {
                    d2 += Math.exp(d);
                } else if (this.m_layerNormalization == Normalization.SIMPLEMAX) {
                    d2 += d;
                }
                this.m_layerOutput.put(string, d);
            }
            if (this.m_layerNormalization != Normalization.NONE) {
                for (n = 0; n < this.m_layerNeurons.length; ++n) {
                    d = this.m_layerOutput.get(this.m_layerNeurons[n].getID());
                    d = this.m_layerNormalization == Normalization.SOFTMAX ? Math.exp(d) / d2 : (d /= d2);
                    this.m_layerOutput.put(this.m_layerNeurons[n].getID(), d);
                }
            }
            return this.m_layerOutput;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("activation: " + (Object)((Object)this.getActivationFunction()) + "\n");
            if (!Double.isNaN(this.getThreshold())) {
                stringBuffer.append("threshold: " + this.getThreshold() + "\n");
            }
            if (!Double.isNaN(this.getWidth())) {
                stringBuffer.append("width: " + this.getWidth() + "\n");
            }
            if (!Double.isNaN(this.getAltitude())) {
                stringBuffer.append("altitude: " + this.getAltitude() + "\n");
            }
            stringBuffer.append("normalization: " + (Object)((Object)this.m_layerNormalization) + "\n");
            for (int i = 0; i < this.m_numNeurons; ++i) {
                stringBuffer.append(this.m_layerNeurons[i] + "\n");
            }
            return stringBuffer.toString();
        }
    }

    static class NeuralInput
    implements Serializable {
        private static final long serialVersionUID = -1902233762824835563L;
        private DerivedFieldMetaInfo m_field;
        private String m_ID = null;

        private String getID() {
            return this.m_ID;
        }

        protected NeuralInput(Element element, MiningSchema miningSchema) throws Exception {
            this.m_ID = element.getAttribute("id");
            NodeList nodeList = element.getElementsByTagName("DerivedField");
            if (nodeList.getLength() != 1) {
                throw new Exception("[NeuralInput] expecting just one derived field!");
            }
            Element element2 = (Element)nodeList.item(0);
            Instances instances = miningSchema.getFieldsAsInstances();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            for (int i = 0; i < instances.numAttributes(); ++i) {
                arrayList.add(instances.attribute(i));
            }
            this.m_field = new DerivedFieldMetaInfo(element2, arrayList, miningSchema.getTransformationDictionary());
        }

        protected double getValue(double[] dArray) throws Exception {
            return this.m_field.getDerivedValue(dArray);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Nueral input (" + this.getID() + ")\n");
            stringBuffer.append(this.m_field);
            return stringBuffer.toString();
        }
    }
}

