/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MathematicalExpression;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SingleIndex;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.filters.AllFilter;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.Center;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class KernelFilter
extends SimpleBatchFilter
implements UnsupervisedFilter,
TechnicalInformationHandler {
    static final long serialVersionUID = 213800899640387499L;
    protected int m_NumTrainInstances;
    protected Kernel m_Kernel = new PolyKernel();
    protected Kernel m_ActualKernel = null;
    protected boolean m_checksTurnedOff;
    protected NominalToBinary m_NominalToBinary;
    protected ReplaceMissingValues m_Missing;
    protected File m_InitFile = new File(System.getProperty("user.dir"));
    protected SingleIndex m_InitFileClassIndex = new SingleIndex("last");
    protected boolean m_Initialized = false;
    protected String m_KernelFactorExpression = "1";
    protected double m_KernelFactor = 1.0;
    protected Filter m_Filter = new Center();
    protected Filter m_ActualFilter = null;

    public String globalInfo() {
        return "Converts the given set of predictor variables into a kernel matrix. The class value remains unchangedm, as long as the preprocessing filter doesn't change it.\nBy default, the data is preprocessed with the Center filter, but the user can choose any filter (NB: one must be careful that the filter does not alter the class attribute unintentionally). With weka.filters.AllFilter the preprocessing gets disabled.\n\nFor more information regarding preprocessing the data, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "K.P. Bennett and M.J. Embrechts");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "An Optimization Perspective on Kernel Partial Least Squares Regression");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation.setValue(TechnicalInformation.Field.EDITOR, "J. Suykens et al.");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Advances in Learning Theory: Methods, Models and Applications");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "227-249");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "IOS Press, Amsterdam, The Netherlands");
        technicalInformation.setValue(TechnicalInformation.Field.SERIES, "NATO Science Series, Series III: Computer and System Sciences");
        technicalInformation.setValue(TechnicalInformation.Field.VOLUME, "190");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tTurns off all checks - use with caution!\n\tTurning them off assumes that data is purely numeric, doesn't\n\tcontain any missing values, and has a nominal class. Turning them\n\toff also means that no header information will be stored if the\n\tmachine is linear. Finally, it also assumes that no instance has\n\ta weight equal to 0.\n\t(default: checks on)", "no-checks", 0, "-no-checks"));
        vector.addElement(new Option("\tThe file to initialize the filter with (optional).", "F", 1, "-F <filename>"));
        vector.addElement(new Option("\tThe class index for the file to initialize with,\n\tFirst and last are valid (optional, default: last).", "C", 1, "-C <num>"));
        vector.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        vector.addElement(new Option("\tDefines a factor for the kernel.\n\t\t- RBFKernel: a factor for gamma\n\t\t\tStandardize: 1/(2*N)\n\t\t\tNormalize..: 6/N\n\tAvailable parameters are:\n\t\tN for # of instances, A for # of attributes\n\t(default: 1)", "kernel-factor", 0, "-kernel-factor"));
        vector.addElement(new Option("\tThe Filter used for preprocessing (use weka.filters.AllFilter\n\tto disable preprocessing).\n\t(default: " + Center.class.getName() + ")", "P", 1, "-P <classname and parameters>"));
        vector.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        enumeration = this.getKernel().listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        if (this.getPreprocessing() instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to preprocessing filter " + this.getPreprocessing().getClass().getName() + ":"));
            enumeration = ((OptionHandler)((Object)this.getPreprocessing())).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (this.getChecksTurnedOff()) {
            vector.add("-no-checks");
        }
        if (this.getInitFile() != null && this.getInitFile().isFile()) {
            vector.add("-F");
            vector.add("" + this.getInitFile().getAbsolutePath());
            vector.add("-C");
            vector.add("" + this.getInitFileClassIndex());
        }
        vector.add("-K");
        vector.add("" + this.getKernel().getClass().getName() + " " + Utils.joinOptions(this.getKernel().getOptions()));
        vector.add("-kernel-factor");
        vector.add("" + this.getKernelFactorExpression());
        vector.add("-P");
        String string = this.getPreprocessing().getClass().getName();
        if (this.getPreprocessing() instanceof OptionHandler) {
            string = string + " " + Utils.joinOptions(((OptionHandler)((Object)this.getPreprocessing())).getOptions());
        }
        vector.add("" + string);
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setChecksTurnedOff(Utils.getFlag("no-checks", stringArray));
        String string = Utils.getOption('F', stringArray);
        if (string.length() != 0) {
            this.setInitFile(new File(string));
        } else {
            this.setInitFile(null);
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setInitFileClassIndex(string);
        } else {
            this.setInitFileClassIndex("last");
        }
        string = Utils.getOption('K', stringArray);
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setKernel(Kernel.forName(string, stringArray2));
        }
        if ((string = Utils.getOption("kernel-factor", stringArray)).length() != 0) {
            this.setKernelFactorExpression(string);
        } else {
            this.setKernelFactorExpression("1");
        }
        string = Utils.getOption("P", stringArray);
        stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setPreprocessing((Filter)Utils.forName(Filter.class, string, stringArray2));
        } else {
            this.setPreprocessing(new Center());
        }
        super.setOptions(stringArray);
    }

    public String initFileTipText() {
        return "The dataset to initialize the filter with.";
    }

    public File getInitFile() {
        return this.m_InitFile;
    }

    public void setInitFile(File file) {
        this.m_InitFile = file;
    }

    public String initFileClassIndexTipText() {
        return "The class index of the dataset to initialize the filter with (first and last are valid).";
    }

    public String getInitFileClassIndex() {
        return this.m_InitFileClassIndex.getSingleIndex();
    }

    public void setInitFileClassIndex(String string) {
        this.m_InitFileClassIndex.setSingleIndex(string);
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_Kernel;
    }

    public void setKernel(Kernel kernel) {
        this.m_Kernel = kernel;
    }

    public void setChecksTurnedOff(boolean bl) {
        this.m_checksTurnedOff = bl;
    }

    public boolean getChecksTurnedOff() {
        return this.m_checksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    public String kernelFactorExpressionTipText() {
        return "The factor for the kernel, with A = # of attributes and N = # of instances.";
    }

    public String getKernelFactorExpression() {
        return this.m_KernelFactorExpression;
    }

    public void setKernelFactorExpression(String string) {
        this.m_KernelFactorExpression = string;
    }

    public String preprocessingTipText() {
        return "Sets the filter to use for preprocessing (use the AllFilter for no preprocessing).";
    }

    public void setPreprocessing(Filter filter) {
        this.m_Filter = filter;
        this.m_ActualFilter = null;
    }

    public Filter getPreprocessing() {
        return this.m_Filter;
    }

    protected void reset() {
        super.reset();
        this.m_Initialized = false;
    }

    protected Instances determineOutputFormat(Instances instances) throws Exception {
        return new Instances(instances);
    }

    public void initFilter(Instances instances) throws Exception {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        hashMap.put("A", new Double(instances.numAttributes()));
        hashMap.put("N", new Double(instances.numInstances()));
        this.m_KernelFactor = MathematicalExpression.evaluate(this.getKernelFactorExpression(), hashMap);
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getKernel().getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean bl = true;
            if (!this.m_checksTurnedOff) {
                for (int i = 0; i < instances.numAttributes(); ++i) {
                    if (i == instances.classIndex() || instances.attribute(i).isNumeric()) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(instances);
                instances = Filter.useFilter(instances, this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        if (this.m_Filter != null && this.m_Filter.getClass() != AllFilter.class) {
            this.m_ActualFilter = Filter.makeCopy(this.m_Filter);
            this.m_ActualFilter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_ActualFilter);
        } else {
            this.m_ActualFilter = null;
        }
        this.m_NumTrainInstances = instances.numInstances();
        this.m_ActualKernel = Kernel.makeCopy(this.m_Kernel);
        if (this.m_ActualKernel instanceof RBFKernel) {
            ((RBFKernel)this.m_ActualKernel).setGamma(this.m_KernelFactor * ((RBFKernel)this.m_ActualKernel).getGamma());
        }
        this.m_ActualKernel.buildKernel(instances);
        this.m_Initialized = true;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        if (this.getKernel() == null) {
            capabilities = super.getCapabilities();
            capabilities.disableAll();
        } else {
            capabilities = this.getKernel().getCapabilities();
        }
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    protected Instances process(Instances instances) throws Exception {
        Object object;
        if (!this.m_Initialized) {
            if (this.getInitFile() != null && this.getInitFile().isFile()) {
                object = new ConverterUtils.DataSource(this.getInitFile().getAbsolutePath());
                Instances instances2 = ((ConverterUtils.DataSource)object).getDataSet();
                this.m_InitFileClassIndex.setUpper(instances2.numAttributes() - 1);
                instances2.setClassIndex(this.m_InitFileClassIndex.getIndex());
                this.initFilter(instances2);
            } else {
                this.initFilter(instances);
            }
        }
        if (this.m_Missing != null) {
            instances = Filter.useFilter(instances, this.m_Missing);
        }
        if (this.m_NominalToBinary != null) {
            instances = Filter.useFilter(instances, this.m_NominalToBinary);
        }
        if (this.m_ActualFilter != null) {
            instances = Filter.useFilter(instances, this.m_ActualFilter);
        }
        object = instances.attributeToDoubleArray(instances.classIndex());
        int n = instances.classIndex();
        instances.setClassIndex(-1);
        instances.deleteAttributeAt(n);
        FastVector fastVector = new FastVector();
        for (int i = 0; i < this.m_NumTrainInstances; ++i) {
            fastVector.addElement(new Attribute("Kernel " + i));
        }
        fastVector.addElement(new Attribute("Class"));
        Instances instances3 = new Instances("Kernel", fastVector, 0);
        instances3.setClassIndex(instances3.numAttributes() - 1);
        for (int i = 0; i < instances.numInstances(); ++i) {
            double[] dArray = new double[this.m_NumTrainInstances + 1];
            for (int j = 0; j < this.m_NumTrainInstances; ++j) {
                double d;
                dArray[j] = d = this.m_ActualKernel.eval(-1, j, instances.instance(i));
            }
            dArray[dArray.length - 1] = (double)object[i];
            Instance instance = new Instance(1.0, dArray);
            instances3.add(instance);
        }
        if (!this.isFirstBatchDone()) {
            this.setOutputFormat(instances3);
        }
        return instances3;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5543 $");
    }

    public static void main(String[] stringArray) {
        KernelFilter.runFilter(new KernelFilter(), stringArray);
    }
}

