/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.FastVector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.FileSourcedConverter;

public abstract class AbstractFileSaver
extends AbstractSaver
implements OptionHandler,
FileSourcedConverter,
EnvironmentHandler {
    private File m_outputFile;
    private transient BufferedWriter m_writer;
    private String FILE_EXTENSION;
    private String m_prefix;
    private String m_dir;
    protected int m_incrementalCounter;
    protected boolean m_useRelativePath = false;
    protected transient Environment m_env;

    public void resetOptions() {
        super.resetOptions();
        this.m_outputFile = null;
        this.m_writer = null;
        this.m_prefix = "";
        this.m_dir = "";
        this.m_incrementalCounter = 0;
    }

    public BufferedWriter getWriter() {
        return this.m_writer;
    }

    public void resetWriter() {
        this.m_writer = null;
    }

    public String getFileExtension() {
        return this.FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    protected void setFileExtension(String string) {
        this.FILE_EXTENSION = string;
    }

    public File retrieveFile() {
        return this.m_outputFile;
    }

    public void setFile(File file) throws IOException {
        this.m_outputFile = file;
        this.setDestination(file);
    }

    public void setFilePrefix(String string) {
        this.m_prefix = string;
    }

    public String filePrefix() {
        return this.m_prefix;
    }

    public void setDir(String string) {
        this.m_dir = string;
    }

    public String retrieveDir() {
        return this.m_dir;
    }

    public void setEnvironment(Environment environment) {
        this.m_env = environment;
        if (this.m_outputFile != null) {
            try {
                this.setFile(this.m_outputFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Enumeration listOptions() {
        FastVector fastVector = new FastVector();
        fastVector.addElement(new Option("\tThe input file", "i", 1, "-i <the input file>"));
        fastVector.addElement(new Option("\tThe output file", "o", 1, "-o <the output file>"));
        return fastVector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        File file;
        String string = Utils.getOption('o', stringArray);
        String string2 = Utils.getOption('i', stringArray);
        ArffLoader arffLoader = new ArffLoader();
        this.resetOptions();
        if (string2.length() != 0) {
            try {
                file = new File(string2);
                arffLoader.setFile(file);
                this.setInstances(arffLoader.getDataSet());
            }
            catch (Exception exception) {
                throw new IOException("No data set loaded. Data set has to be in ARFF format.");
            }
        } else {
            throw new IOException("No data set to save.");
        }
        if (string.length() != 0) {
            if (!string.endsWith(this.FILE_EXTENSION)) {
                string = string.lastIndexOf(46) != -1 ? string.substring(0, string.lastIndexOf(46)) + this.FILE_EXTENSION : string + this.FILE_EXTENSION;
            }
            try {
                file = new File(string);
                this.setFile(file);
            }
            catch (Exception exception) {
                throw new IOException("Cannot create output file (Reason: " + exception.toString() + "). Standard out is used.");
            }
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[10];
        int n = 0;
        if (this.m_outputFile != null) {
            stringArray[n++] = "-o";
            stringArray[n++] = "" + this.m_outputFile;
        } else {
            stringArray[n++] = "-o";
            stringArray[n++] = "";
        }
        if (this.getInstances() != null) {
            stringArray[n++] = "-i";
            stringArray[n++] = "" + this.getInstances().relationName();
        } else {
            stringArray[n++] = "-i";
            stringArray[n++] = "";
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public void cancel() {
        if (this.getWriteMode() == 2) {
            if (this.m_outputFile != null && this.m_outputFile.exists() && this.m_outputFile.delete()) {
                System.out.println("File deleted.");
            }
            this.resetOptions();
        }
    }

    public void setDestination(File file) throws IOException {
        boolean bl = false;
        String string = file.getPath();
        try {
            if (this.m_env == null) {
                this.m_env = Environment.getSystemWide();
            }
            string = this.m_env.substitute(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        file = new File(string);
        String string2 = file.getAbsolutePath();
        if (this.m_outputFile != null) {
            try {
                block19: {
                    try {
                        if (file.exists() && !file.delete()) {
                            throw new IOException("File already exists.");
                        }
                        if (string2.lastIndexOf(File.separatorChar) == -1) {
                            bl = file.createNewFile();
                        } else {
                            String string3 = string2.substring(0, string2.lastIndexOf(File.separatorChar));
                            File file2 = new File(string3);
                            if (file2.exists()) {
                                bl = file.createNewFile();
                            } else {
                                file2.mkdirs();
                                bl = file.createNewFile();
                            }
                        }
                        if (!bl) break block19;
                        if (this.m_useRelativePath) {
                            try {
                                this.m_outputFile = Utils.convertToRelativePath(file);
                            }
                            catch (Exception exception) {
                                this.m_outputFile = file;
                            }
                        } else {
                            this.m_outputFile = file;
                        }
                        this.setDestination(new FileOutputStream(this.m_outputFile));
                    }
                    catch (Exception exception) {
                        throw new IOException("Cannot create a new output file (Reason: " + exception.toString() + "). Standard out is used.");
                    }
                }
                Object var8_10 = null;
                if (!bl) {
                    System.err.println("Cannot create a new output file. Standard out is used.");
                    this.m_outputFile = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (!bl) {
                    System.err.println("Cannot create a new output file. Standard out is used.");
                    this.m_outputFile = null;
                }
                throw throwable;
            }
        }
    }

    public void setDestination(OutputStream outputStream) throws IOException {
        this.m_writer = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public void setDirAndPrefix(String string, String string2) {
        try {
            if (this.m_dir.equals("")) {
                this.setDir(System.getProperty("user.dir"));
            }
            if (this.m_prefix.equals("")) {
                if (string.length() == 0) {
                    throw new IOException("[Saver] Empty filename!!");
                }
                this.setFile(new File(this.m_dir + File.separator + string + string2 + this.FILE_EXTENSION));
            } else {
                if (string.length() > 0) {
                    string = "_" + string;
                }
                this.setFile(new File(this.m_dir + File.separator + this.m_prefix + string + string2 + this.FILE_EXTENSION));
            }
        }
        catch (Exception exception) {
            System.err.println("File prefix and/or directory could not have been set.");
            exception.printStackTrace();
        }
    }

    public abstract String getFileDescription();

    public String useRelativePathTipText() {
        return "Use relative rather than absolute paths";
    }

    public void setUseRelativePath(boolean bl) {
        this.m_useRelativePath = bl;
    }

    public boolean getUseRelativePath() {
        return this.m_useRelativePath;
    }

    protected static String makeOptionStr(AbstractFileSaver abstractFileSaver) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(abstractFileSaver.getClass().getName().replaceAll(".*\\.", ""));
        stringBuffer.append(" options:\n\n");
        Enumeration enumeration = abstractFileSaver.listOptions();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            stringBuffer.append(option.synopsis() + "\n");
            stringBuffer.append(option.description() + "\n");
        }
        return stringBuffer.toString();
    }

    public static void runFileSaver(AbstractFileSaver abstractFileSaver, String[] stringArray) {
        try {
            String[] stringArray2 = (String[])stringArray.clone();
            if (Utils.getFlag('h', stringArray2)) {
                System.err.println("\nHelp requested\n" + AbstractFileSaver.makeOptionStr(abstractFileSaver));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            try {
                abstractFileSaver.setOptions(stringArray);
            }
            catch (Exception exception) {
                System.err.println(AbstractFileSaver.makeOptionStr(abstractFileSaver));
                System.exit(1);
            }
            abstractFileSaver.writeBatch();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

