/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.pmml.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltInString
extends Function {
    private static final long serialVersionUID = -7391516909331728653L;
    protected StringFunc m_func;
    protected Attribute m_outputDef = null;

    BuiltInString(StringFunc stringFunc) {
        this.m_func = stringFunc;
        this.m_functionName = this.m_func.toString();
    }

    @Override
    public Attribute getOutputDef() {
        if (this.m_outputDef == null) {
            if (this.m_func == StringFunc.SUBSTRING) {
                this.m_outputDef = new Attribute("BuiltInStringResult:substring", (FastVector)null);
            }
            Attribute attribute = (Attribute)this.m_parameterDefs.get(0);
            FastVector fastVector = new FastVector();
            for (int i = 0; i < attribute.numValues(); ++i) {
                String string = attribute.value(i);
                fastVector.addElement(this.m_func.eval(new Object[]{string}));
            }
            this.m_outputDef = new Attribute("BuiltInStringResult:" + this.m_func.toString(), fastVector);
        }
        return this.m_outputDef;
    }

    @Override
    public String[] getParameterNames() {
        return this.m_func.getParameterNames();
    }

    private Object[] setUpArgs(double[] dArray) {
        Object[] objectArray = new Object[dArray.length];
        Attribute attribute = (Attribute)this.m_parameterDefs.get(0);
        objectArray[0] = attribute.value((int)dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            objectArray[i] = new Integer((int)dArray[i]);
        }
        return objectArray;
    }

    @Override
    public double getResult(double[] dArray) throws Exception {
        if (this.m_parameterDefs == null) {
            throw new Exception("[BuiltInString] incoming parameter structure has not been set");
        }
        if (!this.m_func.legalNumParams(dArray.length)) {
            throw new Exception("[BuiltInString] wrong number of parameters!");
        }
        Object[] objectArray = this.setUpArgs(dArray);
        String string = this.m_func.eval(objectArray);
        int n = this.m_outputDef.indexOfValue(string);
        if (n < 0) {
            if (this.m_outputDef.isString()) {
                n = this.m_outputDef.addStringValue(string);
            } else {
                throw new Exception("[BuiltInString] unable to find value " + string + " in nominal result type!");
            }
        }
        return n;
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> arrayList) throws Exception {
        this.m_parameterDefs = arrayList;
        if (!this.m_func.legalNumParams(this.m_parameterDefs.size())) {
            throw new Exception("[BuiltInMath] illegal number of parameters for function: " + this.m_functionName);
        }
    }

    @Override
    public String toString() {
        String string = this.m_func.toString() + "(";
        for (int i = 0; i < this.m_parameterDefs.size(); ++i) {
            string = string + ((Attribute)this.m_parameterDefs.get(i)).name();
            string = i != this.m_parameterDefs.size() - 1 ? string + ", " : string + ")";
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StringFunc {
        UPPERCASE("uppercase"){

            String eval(Object[] objectArray) {
                return ((String)objectArray[0]).toUpperCase();
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"input"};
            }
        }
        ,
        SUBSTRING("substring"){

            String eval(Object[] objectArray) {
                String string = (String)objectArray[0];
                int n = (Integer)objectArray[1];
                int n2 = (Integer)objectArray[2];
                return string.substring(n - 1, n + n2);
            }

            boolean legalNumParams(int n) {
                return n == 3;
            }

            String[] getParameterNames() {
                return new String[]{"input", "startPos", "length"};
            }
        }
        ,
        TRIMBLANKS("trimBlanks"){

            String eval(Object[] objectArray) {
                return ((String)objectArray[0]).trim();
            }

            boolean legalNumParams(int n) {
                return n == 1;
            }

            String[] getParameterNames() {
                return new String[]{"input"};
            }
        };

        private String m_stringVal;

        abstract String eval(Object[] var1);

        abstract boolean legalNumParams(int var1);

        abstract String[] getParameterNames();

        private StringFunc(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

