/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import weka.classifiers.EnsembleLibrary;
import weka.gui.CostMatrixEditor;
import weka.gui.GenericArrayEditor;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;
import weka.gui.PropertyText;
import weka.gui.PropertyValueSelector;
import weka.gui.ensembleLibraryEditor.AddModelsPanel;
import weka.gui.ensembleLibraryEditor.ListModelsPanel;

public class EnsembleLibraryEditor
implements PropertyEditor {
    protected EnsembleLibrary m_Library;
    protected transient PropertyChangeSupport m_PropSupport = new PropertyChangeSupport(this);
    protected transient CustomEditor m_CustomEditor = new CustomEditor();
    protected transient JTabbedPane m_ModelOptionsPane = new JTabbedPane();
    protected transient ListModelsPanel m_ListModelsPanel = new ListModelsPanel(this.m_Library);

    public EnsembleLibraryEditor() {
        this.m_PropSupport = new PropertyChangeSupport(this);
        this.m_CustomEditor = new CustomEditor();
    }

    public void setValue(Object object) {
        this.m_Library = (EnsembleLibrary)object;
        this.m_ListModelsPanel.setLibrary(this.m_Library);
    }

    public Object getValue() {
        return this.m_Library;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.drawString(this.m_Library.size() + " models selected", rectangle.x, rectangle.y + rectangle.height);
    }

    public String getJavaInitializationString() {
        return "new Library(" + this.m_Library.size() + ")";
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
        throw new IllegalArgumentException("LibraryEditor: Library properties cannot be expressed as text");
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this.m_CustomEditor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_Library.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_PropSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static Object getEditorValue(Object object) {
        Object object2 = null;
        if (object instanceof GenericArrayEditor) {
            object2 = ((GenericArrayEditor)object).getValue();
        } else if (object instanceof CostMatrixEditor) {
            object2 = ((CostMatrixEditor)object).getValue();
        } else if (object instanceof PropertyText) {
            object2 = ((PropertyText)object).getText();
        } else if (object instanceof PropertyEditor) {
            object2 = ((PropertyEditor)object).getValue();
        }
        return object2;
    }

    public static Component getDefaultRenderer(PropertyEditor propertyEditor) {
        JComponent jComponent = null;
        if (propertyEditor.isPaintable() && propertyEditor.supportsCustomEditor()) {
            jComponent = new PropertyPanel(propertyEditor);
        } else if (propertyEditor.getTags() != null) {
            jComponent = new PropertyValueSelector(propertyEditor);
        } else if (propertyEditor.getAsText() != null) {
            jComponent = new PropertyText(propertyEditor);
            ((PropertyText)jComponent).setColumns(20);
        } else {
            System.err.println("Warning: Property \"" + propertyEditor.getClass().toString() + "\" has non-displayabale editor.  Skipping.");
        }
        return jComponent;
    }

    public static Component createGenericObjectRenderer(GenericObjectEditor genericObjectEditor) {
        PropertyPanel propertyPanel = new PropertyPanel(genericObjectEditor);
        return propertyPanel;
    }

    public static void main(String[] stringArray) {
        EnsembleLibrary ensembleLibrary = new EnsembleLibrary();
        EnsembleLibraryEditor ensembleLibraryEditor = new EnsembleLibraryEditor();
        ensembleLibraryEditor.setValue(ensembleLibrary);
        JPanel jPanel = (JPanel)ensembleLibraryEditor.getCustomEditor();
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(jPanel);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class CustomEditor
    extends JPanel {
        private static final long serialVersionUID = -1553490570313707008L;

        public CustomEditor() {
            EnsembleLibraryEditor.this.m_ModelOptionsPane = new JTabbedPane();
            EnsembleLibraryEditor.this.m_ListModelsPanel = new ListModelsPanel(EnsembleLibraryEditor.this.m_Library);
            EnsembleLibraryEditor.this.m_ModelOptionsPane.addTab("Current Library", EnsembleLibraryEditor.this.m_ListModelsPanel);
            EnsembleLibraryEditor.this.m_ModelOptionsPane.addTab("Add Models", new AddModelsPanel(EnsembleLibraryEditor.this.m_ListModelsPanel));
            this.setLayout(new BorderLayout());
            this.add((Component)EnsembleLibraryEditor.this.m_ModelOptionsPane, "Center");
        }
    }
}

