/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import weka.core.RevisionUtils;
import weka.estimators.ConditionalEstimator;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;
import weka.estimators.KernelEstimator;

public class DKConditionalEstimator
implements ConditionalEstimator {
    private KernelEstimator[] m_Estimators;
    private DiscreteEstimator m_Weights;

    public DKConditionalEstimator(int n, double d) {
        this.m_Estimators = new KernelEstimator[n];
        for (int i = 0; i < n; ++i) {
            this.m_Estimators[i] = new KernelEstimator(d);
        }
        this.m_Weights = new DiscreteEstimator(n, true);
    }

    public void addValue(double d, double d2, double d3) {
        this.m_Estimators[(int)d].addValue(d2, d3);
        this.m_Weights.addValue((int)d, d3);
    }

    public Estimator getEstimator(double d) {
        DiscreteEstimator discreteEstimator = new DiscreteEstimator(this.m_Estimators.length, false);
        for (int i = 0; i < this.m_Estimators.length; ++i) {
            ((Estimator)discreteEstimator).addValue(i, this.m_Weights.getProbability(i) * this.m_Estimators[i].getProbability(d));
        }
        return discreteEstimator;
    }

    public double getProbability(double d, double d2) {
        return this.getEstimator(d2).getProbability(d);
    }

    public String toString() {
        String string = "DK Conditional Estimator. " + this.m_Estimators.length + " sub-estimators:\n";
        for (int i = 0; i < this.m_Estimators.length; ++i) {
            string = string + "Sub-estimator " + i + ": " + this.m_Estimators[i];
        }
        string = string + "Weights of each estimator given by " + this.m_Weights;
        return string;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            int n2;
            if (stringArray.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int n3 = n2 = Integer.parseInt(stringArray[0]);
            int n4 = n = Integer.parseInt(stringArray[1]);
            for (int i = 2; i < stringArray.length - 1; i += 2) {
                n2 = Integer.parseInt(stringArray[i]);
                n = Integer.parseInt(stringArray[i + 1]);
                if (n2 > n3) {
                    n3 = n2;
                }
                if (n <= n4) continue;
                n4 = n;
            }
            DKConditionalEstimator dKConditionalEstimator = new DKConditionalEstimator(n3 + 1, 1.0);
            for (int i = 0; i < stringArray.length - 1; i += 2) {
                n2 = Integer.parseInt(stringArray[i]);
                n = Integer.parseInt(stringArray[i + 1]);
                System.out.println(dKConditionalEstimator);
                System.out.println("Prediction for " + n2 + '|' + n + " = " + dKConditionalEstimator.getProbability(n2, n));
                dKConditionalEstimator.addValue(n2, n, 1.0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

