/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trie
implements Serializable,
Cloneable,
Collection<String>,
RevisionHandler {
    private static final long serialVersionUID = -5897980928817779048L;
    protected TrieNode m_Root = new TrieNode(null);
    protected int m_HashCode;
    protected boolean m_RecalcHashCode = true;

    @Override
    public boolean add(String string) {
        return this.m_Root.add(string + TrieNode.STOP);
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        boolean bl = false;
        Iterator<? extends String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl = this.add(iterator.next()) || bl;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.m_Root.removeAllChildren();
        this.m_RecalcHashCode = true;
    }

    public Object clone() {
        Trie trie = new Trie();
        trie.m_Root = (TrieNode)this.m_Root.clone();
        return trie;
    }

    @Override
    public boolean contains(Object object) {
        return this.m_Root.contains((String)object + TrieNode.STOP);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        boolean bl = true;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean containsPrefix(String string) {
        return this.m_Root.contains(string);
    }

    @Override
    public boolean equals(Object object) {
        return this.m_Root.equals(((Trie)object).getRoot());
    }

    public String getCommonPrefix() {
        return this.m_Root.getCommonPrefix();
    }

    public TrieNode getRoot() {
        return this.m_Root;
    }

    public Vector<String> getWithPrefix(String string) {
        Vector<String> vector = new Vector<String>();
        if (this.containsPrefix(string)) {
            TrieNode trieNode = this.m_Root.find(string);
            TrieIterator trieIterator = new TrieIterator(trieNode);
            while (trieIterator.hasNext()) {
                vector.add(trieIterator.next());
            }
        }
        return vector;
    }

    @Override
    public int hashCode() {
        if (this.m_RecalcHashCode) {
            this.m_HashCode = this.toString().hashCode();
            this.m_RecalcHashCode = false;
        }
        return this.m_HashCode;
    }

    @Override
    public boolean isEmpty() {
        return this.m_Root.getChildCount() == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return new TrieIterator(this.m_Root);
    }

    @Override
    public boolean remove(Object object) {
        boolean bl;
        this.m_RecalcHashCode = bl = this.m_Root.remove((String)object + TrieNode.STOP);
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl = this.remove(iterator.next()) || bl;
        }
        this.m_RecalcHashCode = bl;
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        for (String string : this) {
            if (collection.contains(string)) continue;
            bl = this.remove(string) || bl;
        }
        this.m_RecalcHashCode = bl;
        return bl;
    }

    @Override
    public int size() {
        return this.m_Root.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new String[0]);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        Vector<String> vector = new Vector<String>();
        Iterator<String> iterator = this.iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next());
        }
        Object[] objectArray = Array.getLength(TArray) != vector.size() ? (Object[])Array.newInstance(TArray.getClass().getComponentType(), vector.size()) : TArray;
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = vector.get(i);
        }
        return objectArray;
    }

    protected String toString(TrieNode trieNode) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = 0; n < trieNode.getLevel(); ++n) {
            stringBuffer2.append(" | ");
        }
        stringBuffer.append(stringBuffer2.toString());
        if (trieNode.getChar() == null) {
            stringBuffer.append("<root>");
        } else if (trieNode.getChar() == TrieNode.STOP) {
            stringBuffer.append("STOP");
        } else {
            stringBuffer.append("'" + trieNode.getChar() + "'");
        }
        stringBuffer.append("\n");
        for (n = 0; n < trieNode.getChildCount(); ++n) {
            stringBuffer.append(this.toString((TrieNode)trieNode.getChildAt(n)));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(this.m_Root);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = stringArray.length == 0 ? new String[]{"this is a test", "this is another test", "and something else"} : (String[])stringArray.clone();
        Trie trie = new Trie();
        for (int i = 0; i < stringArray2.length; ++i) {
            trie.add(stringArray2[i]);
        }
        System.out.println(trie);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TrieIterator
    implements Iterator<String>,
    RevisionHandler {
        protected TrieNode m_Root;
        protected TrieNode m_LastLeaf;
        protected TrieNode m_CurrentLeaf;

        public TrieIterator(TrieNode trieNode) {
            this.m_Root = trieNode;
            this.m_CurrentLeaf = (TrieNode)this.m_Root.getFirstLeaf();
            this.m_LastLeaf = (TrieNode)this.m_Root.getLastLeaf();
        }

        @Override
        public boolean hasNext() {
            return this.m_CurrentLeaf != null;
        }

        @Override
        public String next() {
            String string = this.m_CurrentLeaf.getString();
            string = string.substring(0, string.length() - 1);
            this.m_CurrentLeaf = this.m_CurrentLeaf != this.m_LastLeaf ? (TrieNode)this.m_CurrentLeaf.getNextLeaf() : null;
            return string;
        }

        @Override
        public void remove() {
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.2 $");
        }
    }

    public static class TrieNode
    extends DefaultMutableTreeNode
    implements RevisionHandler {
        private static final long serialVersionUID = -2252907099391881148L;
        public static final Character STOP = Character.valueOf('\u0000');
        protected Hashtable<Character, TrieNode> m_Children = new Hashtable(100);

        public TrieNode(char c) {
            this(new Character(c));
        }

        public TrieNode(Character c) {
            super(c);
        }

        public Character getChar() {
            return (Character)this.getUserObject();
        }

        public void setChar(Character c) {
            this.setUserObject(c);
        }

        public boolean add(String string) {
            boolean bl = false;
            Character c = Character.valueOf(string.charAt(0));
            String string2 = string.substring(1);
            TrieNode trieNode = this.m_Children.get(c);
            if (trieNode == null) {
                bl = true;
                trieNode = this.add(c);
            }
            if (string2.length() > 0) {
                bl = trieNode.add(string2) || bl;
            }
            return bl;
        }

        protected TrieNode add(Character c) {
            TrieNode trieNode = new TrieNode(c);
            this.add(trieNode);
            this.m_Children.put(c, trieNode);
            return trieNode;
        }

        protected void remove(Character c) {
            TrieNode trieNode = this.m_Children.get(c);
            this.remove(trieNode);
            this.m_Children.remove(c);
        }

        public boolean remove(String string) {
            boolean bl;
            Character c = Character.valueOf(string.charAt(0));
            String string2 = string.substring(1);
            TrieNode trieNode = this.m_Children.get(c);
            if (trieNode == null) {
                bl = false;
            } else if (string2.length() == 0) {
                this.remove(c);
                bl = true;
            } else {
                bl = trieNode.remove(string2);
                if (trieNode.getChildCount() == 0) {
                    this.remove(trieNode.getChar());
                }
            }
            return bl;
        }

        public boolean contains(String string) {
            Character c = Character.valueOf(string.charAt(0));
            String string2 = string.substring(1);
            TrieNode trieNode = this.m_Children.get(c);
            boolean bl = trieNode == null ? false : (string2.length() == 0 ? true : trieNode.contains(string2));
            return bl;
        }

        public Object clone() {
            TrieNode trieNode = new TrieNode(this.getChar());
            Enumeration<Character> enumeration = this.m_Children.keys();
            while (enumeration.hasMoreElements()) {
                Character c = enumeration.nextElement();
                TrieNode trieNode2 = (TrieNode)this.m_Children.get(c).clone();
                trieNode.add(trieNode2);
                trieNode.m_Children.put(c, trieNode2);
            }
            return trieNode;
        }

        public boolean equals(Object object) {
            boolean bl;
            block1: {
                Character c;
                TrieNode trieNode = (TrieNode)object;
                bl = this.getChar() == null ? trieNode.getChar() == null : this.getChar().equals(trieNode.getChar());
                if (!bl) break block1;
                Enumeration<Character> enumeration = this.m_Children.keys();
                while (enumeration.hasMoreElements() && (bl = this.m_Children.get(c = enumeration.nextElement()).equals(trieNode.m_Children.get(c)))) {
                }
            }
            return bl;
        }

        public TrieNode find(String string) {
            Character c = Character.valueOf(string.charAt(0));
            String string2 = string.substring(1);
            TrieNode trieNode = this.m_Children.get(c);
            TrieNode trieNode2 = trieNode == null ? null : (string2.length() == 0 ? trieNode : trieNode.find(string2));
            return trieNode2;
        }

        public String getCommonPrefix() {
            return this.getCommonPrefix("");
        }

        public String getCommonPrefix(String string) {
            TrieNode trieNode = string.length() == 0 ? this : this.find(string);
            String string2 = trieNode == null ? null : string + trieNode.determineCommonPrefix("");
            return string2;
        }

        protected String determineCommonPrefix(String string) {
            String string2 = !this.isRoot() && this.getChar() != STOP ? string + this.getChar() : string;
            String string3 = this.m_Children.size() == 1 ? ((TrieNode)this.getChildAt(0)).determineCommonPrefix(string2) : string2;
            return string3;
        }

        public int size() {
            int n = 0;
            for (TrieNode trieNode = (TrieNode)this.getFirstLeaf(); trieNode != null; trieNode = (TrieNode)trieNode.getNextLeaf()) {
                if (trieNode == this.getRoot()) continue;
                ++n;
            }
            return n;
        }

        public String getString() {
            char[] cArray = new char[this.getLevel()];
            TrieNode trieNode = this;
            while (trieNode.getParent() != null && !trieNode.isRoot()) {
                cArray[trieNode.getLevel() - 1] = trieNode.getChar().charValue();
                trieNode = (TrieNode)trieNode.getParent();
            }
            return new String(cArray);
        }

        public String toString() {
            return "" + this.getChar();
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.2 $");
        }
    }
}

