/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.trees.adtree.ReferenceInstances;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class LADTree
extends Classifier
implements Drawable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = -4940716114518300302L;
    protected double Z_MAX = 4.0;
    protected int m_numOfClasses;
    protected ReferenceInstances m_trainInstances;
    protected PredictionNode m_root = null;
    protected int m_lastAddedSplitNum = 0;
    protected int[] m_numericAttIndices;
    protected double m_search_smallestLeastSquares;
    protected PredictionNode m_search_bestInsertionNode;
    protected Splitter m_search_bestSplitter;
    protected Instances m_search_bestPathInstances;
    protected FastVector m_staticPotentialSplitters2way;
    protected int m_nodesExpanded = 0;
    protected int m_examplesCounted = 0;
    protected int m_boostingIterations = 10;

    public String globalInfo() {
        return "Class for generating a multi-class alternating decision tree using the LogitBoost strategy. For more info, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Geoffrey Holmes and Bernhard Pfahringer and Richard Kirkby and Eibe Frank and Mark Hall");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Multiclass alternating decision trees");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "ECML");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2001");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "161-172");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return technicalInformation;
    }

    public void initClassifier(Instances instances) throws Exception {
        this.m_nodesExpanded = 0;
        this.m_examplesCounted = 0;
        this.m_lastAddedSplitNum = 0;
        this.m_numOfClasses = instances.numClasses();
        if (instances.checkForStringAttributes()) {
            throw new Exception("Can't handle string attributes!");
        }
        if (!instances.classAttribute().isNominal()) {
            throw new Exception("Class must be nominal!");
        }
        this.m_trainInstances = new ReferenceInstances(instances, instances.numInstances());
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (instance.classIsMissing()) continue;
            LADInstance lADInstance = new LADInstance(instance);
            this.m_trainInstances.addReference(lADInstance);
            lADInstance.setDataset(this.m_trainInstances);
        }
        this.m_root = new PredictionNode(new double[this.m_numOfClasses]);
        this.generateStaticPotentialSplittersAndNumericIndices();
    }

    public void next(int n) throws Exception {
        this.boost();
    }

    public void done() throws Exception {
    }

    private void boost() throws Exception {
        if (this.m_trainInstances == null) {
            throw new Exception("Trying to boost with no training data");
        }
        this.searchForBestTest();
        if (this.m_Debug) {
            System.out.println("Best split found: " + this.m_search_bestSplitter.getNumOfBranches() + "-way split on " + this.m_search_bestSplitter.attributeString() + "\nBestGain = " + this.m_search_smallestLeastSquares);
        }
        if (this.m_search_bestSplitter == null) {
            return;
        }
        for (int i = 0; i < this.m_search_bestSplitter.getNumOfBranches(); ++i) {
            Instances instances = this.m_search_bestSplitter.instancesDownBranch(i, this.m_search_bestPathInstances);
            double[] dArray = this.calcPredictionValues(instances);
            PredictionNode predictionNode = new PredictionNode(dArray);
            this.updateWeights(instances, dArray);
            this.m_search_bestSplitter.setChildForBranch(i, predictionNode);
        }
        this.m_search_bestInsertionNode.addChild(this.m_search_bestSplitter);
        if (this.m_Debug) {
            System.out.println("Tree is now:\n" + this.toString(this.m_root, 1) + "\n");
        }
        this.m_search_bestPathInstances = null;
    }

    private void updateWeights(Instances instances, double[] dArray) {
        for (int i = 0; i < instances.numInstances(); ++i) {
            ((LADInstance)instances.instance(i)).updateWeights(dArray);
        }
    }

    private void generateStaticPotentialSplittersAndNumericIndices() {
        int n;
        this.m_staticPotentialSplitters2way = new FastVector();
        FastVector fastVector = new FastVector();
        for (n = 0; n < this.m_trainInstances.numAttributes(); ++n) {
            if (n == this.m_trainInstances.classIndex()) continue;
            if (this.m_trainInstances.attribute(n).isNumeric()) {
                fastVector.addElement(new Integer(n));
                continue;
            }
            int n2 = this.m_trainInstances.attribute(n).numValues();
            if (n2 == 2) {
                this.m_staticPotentialSplitters2way.addElement(new TwoWayNominalSplit(n, 0));
                continue;
            }
            for (int i = 0; i < n2; ++i) {
                this.m_staticPotentialSplitters2way.addElement(new TwoWayNominalSplit(n, i));
            }
        }
        this.m_numericAttIndices = new int[fastVector.size()];
        for (n = 0; n < fastVector.size(); ++n) {
            this.m_numericAttIndices[n] = (Integer)fastVector.elementAt(n);
        }
    }

    private void searchForBestTest() throws Exception {
        if (this.m_Debug) {
            System.out.println("Searching for best split...");
        }
        this.m_search_smallestLeastSquares = 0.0;
        this.searchForBestTest(this.m_root, this.m_trainInstances);
    }

    private void searchForBestTest(PredictionNode predictionNode, Instances instances) throws Exception {
        ++this.m_nodesExpanded;
        this.m_examplesCounted += instances.numInstances();
        Enumeration enumeration = this.m_staticPotentialSplitters2way.elements();
        while (enumeration.hasMoreElements()) {
            this.evaluateSplitter((Splitter)enumeration.nextElement(), predictionNode, instances);
        }
        if (this.m_Debug) {
            // empty if block
        }
        for (int i = 0; i < this.m_numericAttIndices.length; ++i) {
            this.evaluateNumericSplit(predictionNode, instances, this.m_numericAttIndices[i]);
        }
        if (predictionNode.getChildren().size() == 0) {
            return;
        }
        this.goDownAllPaths(predictionNode, instances);
    }

    private void goDownAllPaths(PredictionNode predictionNode, Instances instances) throws Exception {
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter = (Splitter)enumeration.nextElement();
            for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                this.searchForBestTest(splitter.getChildForBranch(i), splitter.instancesDownBranch(i, instances));
            }
        }
    }

    private void evaluateSplitter(Splitter splitter, PredictionNode predictionNode, Instances instances) throws Exception {
        double d = this.leastSquaresNonMissing(instances, splitter.attIndex);
        for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
            d -= this.leastSquares(splitter.instancesDownBranch(i, instances));
        }
        if (this.m_Debug) {
            System.out.print(splitter.getNumOfBranches() + "-way split on " + splitter.attributeString() + " has leastSquares value of " + Utils.doubleToString(d, 3));
        }
        if (d > this.m_search_smallestLeastSquares) {
            if (this.m_Debug) {
                System.out.print(" (best so far)");
            }
            this.m_search_smallestLeastSquares = d;
            this.m_search_bestInsertionNode = predictionNode;
            this.m_search_bestSplitter = splitter;
            this.m_search_bestPathInstances = instances;
        }
        if (this.m_Debug) {
            System.out.print("\n");
        }
    }

    private void evaluateNumericSplit(PredictionNode predictionNode, Instances instances, int n) {
        double[] dArray = this.findNumericSplitpointAndLS(instances, n);
        double d = this.leastSquaresNonMissing(instances, n) - dArray[1];
        if (this.m_Debug) {
            System.out.print("Numeric split on " + instances.attribute(n).name() + " has leastSquares value of " + Utils.doubleToString(d, 3));
        }
        if (d > this.m_search_smallestLeastSquares) {
            if (this.m_Debug) {
                System.out.print(" (best so far)");
            }
            this.m_search_smallestLeastSquares = d;
            this.m_search_bestInsertionNode = predictionNode;
            this.m_search_bestSplitter = new TwoWayNumericSplit(n, dArray[0]);
            this.m_search_bestPathInstances = instances;
        }
        if (this.m_Debug) {
            System.out.print("\n");
        }
    }

    private double[] findNumericSplitpointAndLS(Instances instances, int n) {
        double d;
        double d2 = this.leastSquares(instances);
        double[] dArray = new double[this.m_numOfClasses];
        double[] dArray2 = new double[this.m_numOfClasses];
        double[] dArray3 = new double[this.m_numOfClasses];
        double[] dArray4 = new double[this.m_numOfClasses];
        double[] dArray5 = new double[this.m_numOfClasses];
        double[] dArray6 = new double[this.m_numOfClasses];
        double[] dArray7 = new double[this.m_numOfClasses];
        double[] dArray8 = new double[this.m_numOfClasses];
        double[] dArray9 = new double[this.m_numOfClasses];
        double[] dArray10 = new double[this.m_numOfClasses];
        double[] dArray11 = new double[this.m_numOfClasses];
        double[] dArray12 = new double[this.m_numOfClasses];
        for (int i = 0; i < this.m_numOfClasses; ++i) {
            for (int j = 0; j < instances.numInstances(); ++j) {
                LADInstance lADInstance = (LADInstance)instances.instance(j);
                d = lADInstance.wVector[i] * lADInstance.zVector[i];
                int n2 = i;
                dArray6[n2] = dArray6[n2] + d * lADInstance.zVector[i];
                int n3 = i;
                dArray7[n3] = dArray7[n3] + d;
                int n4 = i;
                dArray8[n4] = dArray8[n4] + lADInstance.wVector[i];
                int n5 = i;
                dArray9[n5] = dArray9[n5] + lADInstance.wVector[i] * lADInstance.zVector[i];
            }
        }
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = 0.0;
        instances.sort(n);
        for (int i = 0; i < instances.numInstances() - 1 && !instances.instance(i + 1).isMissing(n); ++i) {
            boolean bl = instances.instance(i + 1).value(n) > instances.instance(i).value(n);
            LADInstance lADInstance = (LADInstance)instances.instance(i);
            double d5 = 0.0;
            for (int j = 0; j < this.m_numOfClasses; ++j) {
                d = lADInstance.wVector[j] * lADInstance.zVector[j];
                double d6 = d * lADInstance.zVector[j];
                double d7 = lADInstance.wVector[j] * lADInstance.zVector[j];
                int n6 = j;
                dArray[n6] = dArray[n6] + d6;
                int n7 = j;
                dArray2[n7] = dArray2[n7] + d;
                int n8 = j;
                dArray3[n8] = dArray3[n8] + lADInstance.wVector[j];
                int n9 = j;
                dArray6[n9] = dArray6[n9] - d6;
                int n10 = j;
                dArray7[n10] = dArray7[n10] - d;
                int n11 = j;
                dArray8[n11] = dArray8[n11] - lADInstance.wVector[j];
                int n12 = j;
                dArray4[n12] = dArray4[n12] + d7;
                int n13 = j;
                dArray9[n13] = dArray9[n13] - d7;
                if (!bl) continue;
                double d8 = dArray4[j] / dArray3[j];
                double d9 = dArray9[j] / dArray8[j];
                d5 += dArray[j] - 2.0 * d8 * dArray2[j] + d8 * d8 * dArray3[j];
                d5 += dArray6[j] - 2.0 * d9 * dArray7[j] + d9 * d9 * dArray8[j];
            }
            if (this.m_Debug && bl) {
                System.out.println(n + "/" + (instances.instance(i).value(n) + instances.instance(i + 1).value(n)) / 2.0 + " = " + (d2 - d5));
            }
            if (!bl || !(d5 < d3)) continue;
            d4 = (instances.instance(i).value(n) + instances.instance(i + 1).value(n)) / 2.0;
            d3 = d5;
        }
        double[] dArray13 = new double[]{d4, d3 > 0.0 ? d3 : 0.0};
        return dArray13;
    }

    private double leastSquares(Instances instances) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[this.m_numOfClasses];
        double[] dArray2 = new double[this.m_numOfClasses];
        for (int i = 0; i < instances.numInstances(); ++i) {
            LADInstance lADInstance = (LADInstance)instances.instance(i);
            for (n = 0; n < this.m_numOfClasses; ++n) {
                int n2 = n;
                dArray[n2] = dArray[n2] + lADInstance.zVector[n] * lADInstance.wVector[n];
                int n3 = n;
                dArray2[n3] = dArray2[n3] + lADInstance.wVector[n];
            }
        }
        double d3 = instances.numInstances();
        for (n = 0; n < this.m_numOfClasses; ++n) {
            if (dArray2[n] == 0.0) continue;
            int n4 = n;
            dArray[n4] = dArray[n4] / dArray2[n];
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            for (int i = 0; i < this.m_numOfClasses; ++i) {
                LADInstance lADInstance = (LADInstance)instances.instance(n);
                double d4 = lADInstance.wVector[i];
                double d5 = lADInstance.zVector[i] - dArray[i];
                d += d4 * (d5 * d5);
                d2 += d4;
            }
        }
        return d > 0.0 ? d : 0.0;
    }

    private double leastSquaresNonMissing(Instances instances, int n) {
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = new double[this.m_numOfClasses];
        double[] dArray2 = new double[this.m_numOfClasses];
        for (int i = 0; i < instances.numInstances(); ++i) {
            LADInstance lADInstance = (LADInstance)instances.instance(i);
            for (n2 = 0; n2 < this.m_numOfClasses; ++n2) {
                int n3 = n2;
                dArray[n3] = dArray[n3] + lADInstance.zVector[n2] * lADInstance.wVector[n2];
                int n4 = n2;
                dArray2[n4] = dArray2[n4] + lADInstance.wVector[n2];
            }
        }
        double d3 = instances.numInstances();
        for (n2 = 0; n2 < this.m_numOfClasses; ++n2) {
            if (dArray2[n2] == 0.0) continue;
            int n5 = n2;
            dArray[n5] = dArray[n5] / dArray2[n2];
        }
        for (n2 = 0; n2 < instances.numInstances(); ++n2) {
            for (int i = 0; i < this.m_numOfClasses; ++i) {
                LADInstance lADInstance = (LADInstance)instances.instance(n2);
                if (lADInstance.isMissing(n)) continue;
                double d4 = lADInstance.wVector[i];
                double d5 = lADInstance.zVector[i] - dArray[i];
                d += d4 * (d5 * d5);
                d2 += d4;
            }
        }
        return d > 0.0 ? d : 0.0;
    }

    private double[] calcPredictionValues(Instances instances) {
        int n;
        double[] dArray = new double[this.m_numOfClasses];
        double d = 0.0;
        double d2 = (double)(this.m_numOfClasses - 1) / (double)this.m_numOfClasses;
        double[] dArray2 = new double[this.m_numOfClasses];
        for (int i = 0; i < instances.numInstances(); ++i) {
            LADInstance lADInstance = (LADInstance)instances.instance(i);
            for (n = 0; n < this.m_numOfClasses; ++n) {
                int n2 = n;
                dArray[n2] = dArray[n2] + lADInstance.zVector[n] * lADInstance.wVector[n];
                int n3 = n;
                dArray2[n3] = dArray2[n3] + lADInstance.wVector[n];
            }
        }
        double d3 = instances.numInstances();
        for (n = 0; n < this.m_numOfClasses; ++n) {
            if (dArray2[n] != 0.0) {
                int n4 = n;
                dArray[n4] = dArray[n4] / dArray2[n];
            }
            d += dArray[n];
        }
        d /= (double)this.m_numOfClasses;
        for (n = 0; n < this.m_numOfClasses; ++n) {
            dArray[n] = d2 * (dArray[n] - d);
        }
        return dArray;
    }

    public double[] distributionForInstance(Instance instance) {
        double[] dArray = new double[this.m_numOfClasses];
        for (int i = 0; i < this.m_numOfClasses; ++i) {
            dArray[i] = 0.0;
        }
        double[] dArray2 = this.predictionValuesForInstance(instance, this.m_root, dArray);
        double d = dArray2[Utils.maxIndex(dArray2)];
        for (int i = 0; i < this.m_numOfClasses; ++i) {
            dArray2[i] = Math.exp(dArray2[i] - d);
        }
        double d2 = Utils.sum(dArray2);
        if (d2 > 0.0) {
            Utils.normalize(dArray2, d2);
        }
        return dArray2;
    }

    private double[] predictionValuesForInstance(Instance instance, PredictionNode predictionNode, double[] dArray) {
        double[] dArray2 = predictionNode.getValues();
        for (int i = 0; i < this.m_numOfClasses; ++i) {
            int n = i;
            dArray[n] = dArray[n] + dArray2[i];
        }
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter = (Splitter)enumeration.nextElement();
            int n = splitter.branchInstanceGoesDown(instance);
            if (n < 0) continue;
            dArray = this.predictionValuesForInstance(instance, splitter.getChildForBranch(n), dArray);
        }
        return dArray;
    }

    public String toString() {
        String string = this.getClass().getName();
        if (this.m_root == null) {
            return string + " not built yet";
        }
        return string + ":\n\n" + this.toString(this.m_root, 1) + "\nLegend: " + this.legend() + "\n#Tree size (total): " + this.numOfAllNodes(this.m_root) + "\n#Tree size (number of predictor nodes): " + this.numOfPredictionNodes(this.m_root) + "\n#Leaves (number of predictor nodes): " + this.numOfLeafNodes(this.m_root) + "\n#Expanded nodes: " + this.m_nodesExpanded + "\n#Processed examples: " + this.m_examplesCounted + "\n#Ratio e/n: " + (double)this.m_examplesCounted / (double)this.m_nodesExpanded;
    }

    private String toString(PredictionNode predictionNode, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(": ");
        double[] dArray = predictionNode.getValues();
        for (int i = 0; i < this.m_numOfClasses; ++i) {
            stringBuffer.append(Utils.doubleToString(dArray[i], 3));
            if (i >= this.m_numOfClasses - 1) continue;
            stringBuffer.append(",");
        }
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter = (Splitter)enumeration.nextElement();
            for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                PredictionNode predictionNode2 = splitter.getChildForBranch(i);
                if (predictionNode2 == null) continue;
                stringBuffer.append("\n");
                for (int j = 0; j < n; ++j) {
                    stringBuffer.append("|  ");
                }
                stringBuffer.append("(" + splitter.orderAdded + ")");
                stringBuffer.append(splitter.attributeString() + " " + splitter.comparisonString(i));
                stringBuffer.append(this.toString(predictionNode2, n + 1));
            }
        }
        return stringBuffer.toString();
    }

    public String graph() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digraph ADTree {\n");
        this.graphTraverse(this.m_root, stringBuffer, 0, 0);
        return stringBuffer.toString() + "}\n";
    }

    protected void graphTraverse(PredictionNode predictionNode, StringBuffer stringBuffer, int n, int n2) throws Exception {
        stringBuffer.append("S" + n + "P" + n2 + " [label=\"");
        double[] dArray = predictionNode.getValues();
        for (int i = 0; i < this.m_numOfClasses; ++i) {
            stringBuffer.append(Utils.doubleToString(dArray[i], 3));
            if (i >= this.m_numOfClasses - 1) continue;
            stringBuffer.append(",");
        }
        if (n == 0) {
            stringBuffer.append(" (" + this.legend() + ")");
        }
        stringBuffer.append("\" shape=box style=filled]\n");
        Enumeration enumeration = predictionNode.children();
        while (enumeration.hasMoreElements()) {
            Splitter splitter = (Splitter)enumeration.nextElement();
            stringBuffer.append("S" + n + "P" + n2 + "->" + "S" + splitter.orderAdded + " [style=dotted]\n");
            stringBuffer.append("S" + splitter.orderAdded + " [label=\"" + splitter.orderAdded + ": " + splitter.attributeString() + "\"]\n");
            for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                PredictionNode predictionNode2 = splitter.getChildForBranch(i);
                if (predictionNode2 == null) continue;
                stringBuffer.append("S" + splitter.orderAdded + "->" + "S" + splitter.orderAdded + "P" + i + " [label=\"" + splitter.comparisonString(i) + "\"]\n");
                this.graphTraverse(predictionNode2, stringBuffer, splitter.orderAdded, i);
            }
        }
    }

    public String legend() {
        Attribute attribute = null;
        if (this.m_trainInstances == null) {
            return "";
        }
        try {
            attribute = this.m_trainInstances.classAttribute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_numOfClasses == 1) {
            return "-ve = " + attribute.value(0) + ", +ve = " + attribute.value(1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_numOfClasses; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(attribute.value(i));
        }
        return stringBuffer.toString();
    }

    public String numOfBoostingIterationsTipText() {
        return "The number of boosting iterations to use, which determines the size of the tree.";
    }

    public int getNumOfBoostingIterations() {
        return this.m_boostingIterations;
    }

    public void setNumOfBoostingIterations(int n) {
        this.m_boostingIterations = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tNumber of boosting iterations.\n\t(Default = 10)", "B", 1, "-B <number of boosting iterations>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('B', stringArray);
        if (string.length() != 0) {
            this.setNumOfBoostingIterations(Integer.parseInt(string));
        }
        super.setOptions(stringArray);
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[2 + super.getOptions().length];
        int n = 0;
        stringArray[n++] = "-B";
        stringArray[n++] = "" + this.getNumOfBoostingIterations();
        System.arraycopy(super.getOptions(), 0, stringArray, n, super.getOptions().length);
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public double measureTreeSize() {
        return this.numOfAllNodes(this.m_root);
    }

    public double measureNumLeaves() {
        return this.numOfPredictionNodes(this.m_root);
    }

    public double measureNumPredictionLeaves() {
        return this.numOfLeafNodes(this.m_root);
    }

    public double measureNodesExpanded() {
        return this.m_nodesExpanded;
    }

    public double measureExamplesCounted() {
        return this.m_examplesCounted;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(5);
        vector.addElement("measureTreeSize");
        vector.addElement("measureNumLeaves");
        vector.addElement("measureNumPredictionLeaves");
        vector.addElement("measureNodesExpanded");
        vector.addElement("measureExamplesCounted");
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (string.equals("measureTreeSize")) {
            return this.measureTreeSize();
        }
        if (string.equals("measureNodesExpanded")) {
            return this.measureNodesExpanded();
        }
        if (string.equals("measureNumLeaves")) {
            return this.measureNumLeaves();
        }
        if (string.equals("measureNumPredictionLeaves")) {
            return this.measureNumPredictionLeaves();
        }
        if (string.equals("measureExamplesCounted")) {
            return this.measureExamplesCounted();
        }
        throw new IllegalArgumentException(string + " not supported (ADTree)");
    }

    protected int numOfPredictionNodes(PredictionNode predictionNode) {
        int n = 0;
        if (predictionNode != null) {
            ++n;
            Enumeration enumeration = predictionNode.children();
            while (enumeration.hasMoreElements()) {
                Splitter splitter = (Splitter)enumeration.nextElement();
                for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                    n += this.numOfPredictionNodes(splitter.getChildForBranch(i));
                }
            }
        }
        return n;
    }

    protected int numOfLeafNodes(PredictionNode predictionNode) {
        int n = 0;
        if (predictionNode.getChildren().size() > 0) {
            Enumeration enumeration = predictionNode.children();
            while (enumeration.hasMoreElements()) {
                Splitter splitter = (Splitter)enumeration.nextElement();
                for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                    n += this.numOfLeafNodes(splitter.getChildForBranch(i));
                }
            }
        } else {
            n = 1;
        }
        return n;
    }

    protected int numOfAllNodes(PredictionNode predictionNode) {
        int n = 0;
        if (predictionNode != null) {
            ++n;
            Enumeration enumeration = predictionNode.children();
            while (enumeration.hasMoreElements()) {
                ++n;
                Splitter splitter = (Splitter)enumeration.nextElement();
                for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                    n += this.numOfAllNodes(splitter.getChildForBranch(i));
                }
            }
        }
        return n;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.initClassifier(instances);
        for (int i = 0; i < this.m_boostingIterations; ++i) {
            this.boost();
        }
    }

    public int predictiveError(Instances instances) {
        int n = 0;
        for (int i = instances.numInstances() - 1; i >= 0; --i) {
            Instance instance = instances.instance(i);
            try {
                if (this.classifyInstance(instance) == instance.classValue()) continue;
                ++n;
                continue;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        return n;
    }

    public void merge(LADTree lADTree) throws Exception {
        if (this.m_root == null || lADTree.m_root == null) {
            throw new Exception("Trying to merge an uninitialized tree");
        }
        if (this.m_numOfClasses != lADTree.m_numOfClasses) {
            throw new Exception("Trees not suitable for merge - different sized prediction nodes");
        }
        this.m_root.merge(lADTree.m_root);
    }

    public int graphType() {
        return 1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4819 $");
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public static void main(String[] stringArray) {
        LADTree.runClassifier(new LADTree(), stringArray);
    }

    protected class TwoWayNumericSplit
    extends Splitter
    implements Cloneable {
        private double splitPoint;
        private PredictionNode[] children;

        public TwoWayNumericSplit(int n, double d) {
            this.attIndex = n;
            this.splitPoint = d;
            this.children = new PredictionNode[2];
        }

        public TwoWayNumericSplit(int n, Instances instances) throws Exception {
            this.attIndex = n;
            this.splitPoint = this.findSplit(instances, this.attIndex);
            this.children = new PredictionNode[2];
        }

        public int getNumOfBranches() {
            return 2;
        }

        public int branchInstanceGoesDown(Instance instance) {
            if (instance.isMissing(this.attIndex)) {
                return -1;
            }
            if (instance.value(this.attIndex) < this.splitPoint) {
                return 0;
            }
            return 1;
        }

        public Instances instancesDownBranch(int n, Instances instances) {
            ReferenceInstances referenceInstances = new ReferenceInstances(instances, 1);
            if (n == -1) {
                Enumeration enumeration = instances.enumerateInstances();
                while (enumeration.hasMoreElements()) {
                    Instance instance = (Instance)enumeration.nextElement();
                    if (!instance.isMissing(this.attIndex)) continue;
                    referenceInstances.addReference(instance);
                }
            } else if (n == 0) {
                Enumeration enumeration = instances.enumerateInstances();
                while (enumeration.hasMoreElements()) {
                    Instance instance = (Instance)enumeration.nextElement();
                    if (instance.isMissing(this.attIndex) || !(instance.value(this.attIndex) < this.splitPoint)) continue;
                    referenceInstances.addReference(instance);
                }
            } else {
                Enumeration enumeration = instances.enumerateInstances();
                while (enumeration.hasMoreElements()) {
                    Instance instance = (Instance)enumeration.nextElement();
                    if (instance.isMissing(this.attIndex) || !(instance.value(this.attIndex) >= this.splitPoint)) continue;
                    referenceInstances.addReference(instance);
                }
            }
            return referenceInstances;
        }

        public String attributeString() {
            return LADTree.this.m_trainInstances.attribute(this.attIndex).name();
        }

        public String comparisonString(int n) {
            return (n == 0 ? "< " : ">= ") + Utils.doubleToString(this.splitPoint, 3);
        }

        public boolean equalTo(Splitter splitter) {
            if (splitter instanceof TwoWayNumericSplit) {
                TwoWayNumericSplit twoWayNumericSplit = (TwoWayNumericSplit)splitter;
                return this.attIndex == twoWayNumericSplit.attIndex && this.splitPoint == twoWayNumericSplit.splitPoint;
            }
            return false;
        }

        public void setChildForBranch(int n, PredictionNode predictionNode) {
            this.children[n] = predictionNode;
        }

        public PredictionNode getChildForBranch(int n) {
            return this.children[n];
        }

        public Object clone() {
            TwoWayNumericSplit twoWayNumericSplit = new TwoWayNumericSplit(this.attIndex, this.splitPoint);
            if (this.children[0] != null) {
                twoWayNumericSplit.setChildForBranch(0, (PredictionNode)this.children[0].clone());
            }
            if (this.children[1] != null) {
                twoWayNumericSplit.setChildForBranch(1, (PredictionNode)this.children[1].clone());
            }
            return twoWayNumericSplit;
        }

        private double findSplit(Instances instances, int n) throws Exception {
            Instance instance;
            int n2;
            double d = 0.0;
            double d2 = Double.MAX_VALUE;
            int n3 = 0;
            double[][] dArray = new double[3][instances.numClasses()];
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                instance = instances.instance(n2);
                if (!instance.isMissing(n)) {
                    double[] dArray2 = dArray[1];
                    int n4 = (int)instance.classValue();
                    dArray2[n4] = dArray2[n4] + 1.0;
                    continue;
                }
                double[] dArray3 = dArray[2];
                int n5 = (int)instance.classValue();
                dArray3[n5] = dArray3[n5] + 1.0;
                ++n3;
            }
            instances.sort(n);
            for (n2 = 0; n2 < instances.numInstances() - (n3 + 1); ++n2) {
                instance = instances.instance(n2);
                Instance instance2 = instances.instance(n2 + 1);
                double[] dArray4 = dArray[0];
                int n6 = (int)instance.classValue();
                dArray4[n6] = dArray4[n6] + instance.weight();
                double[] dArray5 = dArray[1];
                int n7 = (int)instance.classValue();
                dArray5[n7] = dArray5[n7] - instance.weight();
                if (!Utils.sm(instance.value(n), instance2.value(n))) continue;
                double d3 = (instance.value(n) + instance2.value(n)) / 2.0;
                double d4 = ContingencyTables.entropyConditionedOnRows(dArray);
                if (!Utils.sm(d4, d2)) continue;
                d = d3;
                d2 = d4;
            }
            return d;
        }
    }

    protected class TwoWayNominalSplit
    extends Splitter {
        private int trueSplitValue;
        private PredictionNode[] children;

        public TwoWayNominalSplit(int n, int n2) {
            this.attIndex = n;
            this.trueSplitValue = n2;
            this.children = new PredictionNode[2];
        }

        public int getNumOfBranches() {
            return 2;
        }

        public int branchInstanceGoesDown(Instance instance) {
            if (instance.isMissing(this.attIndex)) {
                return -1;
            }
            if (instance.value(this.attIndex) == (double)this.trueSplitValue) {
                return 0;
            }
            return 1;
        }

        public Instances instancesDownBranch(int n, Instances instances) {
            ReferenceInstances referenceInstances = new ReferenceInstances(instances, 1);
            if (n == -1) {
                Enumeration enumeration = instances.enumerateInstances();
                while (enumeration.hasMoreElements()) {
                    Instance instance = (Instance)enumeration.nextElement();
                    if (!instance.isMissing(this.attIndex)) continue;
                    referenceInstances.addReference(instance);
                }
            } else if (n == 0) {
                Enumeration enumeration = instances.enumerateInstances();
                while (enumeration.hasMoreElements()) {
                    Instance instance = (Instance)enumeration.nextElement();
                    if (instance.isMissing(this.attIndex) || instance.value(this.attIndex) != (double)this.trueSplitValue) continue;
                    referenceInstances.addReference(instance);
                }
            } else {
                Enumeration enumeration = instances.enumerateInstances();
                while (enumeration.hasMoreElements()) {
                    Instance instance = (Instance)enumeration.nextElement();
                    if (instance.isMissing(this.attIndex) || instance.value(this.attIndex) == (double)this.trueSplitValue) continue;
                    referenceInstances.addReference(instance);
                }
            }
            return referenceInstances;
        }

        public String attributeString() {
            return LADTree.this.m_trainInstances.attribute(this.attIndex).name();
        }

        public String comparisonString(int n) {
            Attribute attribute = LADTree.this.m_trainInstances.attribute(this.attIndex);
            if (attribute.numValues() != 2) {
                return (n == 0 ? "= " : "!= ") + attribute.value(this.trueSplitValue);
            }
            return "= " + (n == 0 ? attribute.value(this.trueSplitValue) : attribute.value(this.trueSplitValue == 0 ? 1 : 0));
        }

        public boolean equalTo(Splitter splitter) {
            if (splitter instanceof TwoWayNominalSplit) {
                TwoWayNominalSplit twoWayNominalSplit = (TwoWayNominalSplit)splitter;
                return this.attIndex == twoWayNominalSplit.attIndex && this.trueSplitValue == twoWayNominalSplit.trueSplitValue;
            }
            return false;
        }

        public void setChildForBranch(int n, PredictionNode predictionNode) {
            this.children[n] = predictionNode;
        }

        public PredictionNode getChildForBranch(int n) {
            return this.children[n];
        }

        public Object clone() {
            TwoWayNominalSplit twoWayNominalSplit = new TwoWayNominalSplit(this.attIndex, this.trueSplitValue);
            if (this.children[0] != null) {
                twoWayNominalSplit.setChildForBranch(0, (PredictionNode)this.children[0].clone());
            }
            if (this.children[1] != null) {
                twoWayNominalSplit.setChildForBranch(1, (PredictionNode)this.children[1].clone());
            }
            return twoWayNominalSplit;
        }
    }

    protected abstract class Splitter
    implements Serializable,
    Cloneable {
        protected int attIndex;
        public int orderAdded;

        protected Splitter() {
        }

        public abstract int getNumOfBranches();

        public abstract int branchInstanceGoesDown(Instance var1);

        public abstract Instances instancesDownBranch(int var1, Instances var2);

        public abstract String attributeString();

        public abstract String comparisonString(int var1);

        public abstract boolean equalTo(Splitter var1);

        public abstract void setChildForBranch(int var1, PredictionNode var2);

        public abstract PredictionNode getChildForBranch(int var1);

        public abstract Object clone();
    }

    protected class PredictionNode
    implements Serializable,
    Cloneable {
        private double[] values;
        private FastVector children;

        public PredictionNode(double[] dArray) {
            this.values = new double[LADTree.this.m_numOfClasses];
            this.setValues(dArray);
            this.children = new FastVector();
        }

        public void setValues(double[] dArray) {
            System.arraycopy(dArray, 0, this.values, 0, LADTree.this.m_numOfClasses);
        }

        public double[] getValues() {
            return this.values;
        }

        public FastVector getChildren() {
            return this.children;
        }

        public Enumeration children() {
            return this.children.elements();
        }

        public void addChild(Splitter splitter) {
            Cloneable cloneable;
            Splitter splitter2 = null;
            Object object = this.children();
            while (object.hasMoreElements()) {
                cloneable = (Splitter)object.nextElement();
                if (!splitter.equalTo((Splitter)cloneable)) continue;
                splitter2 = cloneable;
                break;
            }
            if (splitter2 == null) {
                object = (Splitter)splitter.clone();
                ((Splitter)object).orderAdded = ++LADTree.this.m_lastAddedSplitNum;
                this.children.addElement(object);
            } else {
                for (int i = 0; i < splitter.getNumOfBranches(); ++i) {
                    cloneable = splitter2.getChildForBranch(i);
                    PredictionNode predictionNode = splitter.getChildForBranch(i);
                    if (cloneable == null || predictionNode == null) continue;
                    ((PredictionNode)cloneable).merge(predictionNode);
                }
            }
        }

        public Object clone() {
            PredictionNode predictionNode = new PredictionNode(this.values);
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                predictionNode.children.addElement((Splitter)((Splitter)enumeration.nextElement()).clone());
            }
            return predictionNode;
        }

        public void merge(PredictionNode predictionNode) {
            for (int i = 0; i < LADTree.this.m_numOfClasses; ++i) {
                int n = i;
                this.values[n] = this.values[n] + predictionNode.values[i];
            }
            Enumeration enumeration = predictionNode.children();
            while (enumeration.hasMoreElements()) {
                this.addChild((Splitter)enumeration.nextElement());
            }
        }
    }

    protected class LADInstance
    extends Instance {
        public double[] fVector;
        public double[] wVector;
        public double[] pVector;
        public double[] zVector;

        public LADInstance(Instance instance) {
            super(instance);
            this.setDataset(instance.dataset());
            this.fVector = new double[LADTree.this.m_numOfClasses];
            this.wVector = new double[LADTree.this.m_numOfClasses];
            this.pVector = new double[LADTree.this.m_numOfClasses];
            this.zVector = new double[LADTree.this.m_numOfClasses];
            double d = 1.0 / (double)LADTree.this.m_numOfClasses;
            for (int i = 0; i < LADTree.this.m_numOfClasses; ++i) {
                this.pVector[i] = d;
            }
            this.updateZVector();
            this.updateWVector();
        }

        public void updateWeights(double[] dArray) {
            for (int i = 0; i < this.fVector.length; ++i) {
                int n = i;
                this.fVector[n] = this.fVector[n] + dArray[i];
            }
            this.updateVectors(this.fVector);
        }

        public void updateVectors(double[] dArray) {
            this.updatePVector(dArray);
            this.updateZVector();
            this.updateWVector();
        }

        public void updatePVector(double[] dArray) {
            double d = dArray[Utils.maxIndex(dArray)];
            for (int i = 0; i < this.pVector.length; ++i) {
                this.pVector[i] = Math.exp(dArray[i] - d);
            }
            Utils.normalize(this.pVector);
        }

        public void updateWVector() {
            for (int i = 0; i < this.wVector.length; ++i) {
                this.wVector[i] = (this.yVector(i) - this.pVector[i]) / this.zVector[i];
            }
        }

        public void updateZVector() {
            for (int i = 0; i < this.zVector.length; ++i) {
                if (this.yVector(i) == 1.0) {
                    this.zVector[i] = 1.0 / this.pVector[i];
                    if (!(this.zVector[i] > LADTree.this.Z_MAX)) continue;
                    this.zVector[i] = LADTree.this.Z_MAX;
                    continue;
                }
                this.zVector[i] = -1.0 / (1.0 - this.pVector[i]);
                if (!(this.zVector[i] < -LADTree.this.Z_MAX)) continue;
                this.zVector[i] = -LADTree.this.Z_MAX;
            }
        }

        public double yVector(int n) {
            return n == (int)this.classValue() ? 1.0 : 0.0;
        }

        public Object copy() {
            LADInstance lADInstance = new LADInstance((Instance)super.copy());
            System.arraycopy(this.fVector, 0, lADInstance.fVector, 0, this.fVector.length);
            System.arraycopy(this.wVector, 0, lADInstance.wVector, 0, this.wVector.length);
            System.arraycopy(this.pVector, 0, lADInstance.pVector, 0, this.pVector.length);
            System.arraycopy(this.zVector, 0, lADInstance.zVector, 0, this.zVector.length);
            return lADInstance;
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" * F(");
            for (n = 0; n < this.fVector.length; ++n) {
                stringBuffer.append(Utils.doubleToString(this.fVector[n], 3));
                if (n >= this.fVector.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(") P(");
            for (n = 0; n < this.pVector.length; ++n) {
                stringBuffer.append(Utils.doubleToString(this.pVector[n], 3));
                if (n >= this.pVector.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(") W(");
            for (n = 0; n < this.wVector.length; ++n) {
                stringBuffer.append(Utils.doubleToString(this.wVector[n], 3));
                if (n >= this.wVector.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(")");
            return super.toString() + stringBuffer.toString();
        }
    }
}

