/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.File;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.experiment.Experiment;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;

public class RemoteExperimentSubTask
implements Task,
RevisionHandler {
    private TaskStatusInfo m_result = new TaskStatusInfo();
    private Experiment m_experiment;

    public RemoteExperimentSubTask() {
        this.m_result.setStatusMessage("Not running.");
        this.m_result.setExecutionStatus(0);
    }

    public void setExperiment(Experiment experiment) {
        this.m_experiment = experiment;
    }

    public Experiment getExperiment() {
        return this.m_experiment;
    }

    public void execute() {
        this.m_result = new TaskStatusInfo();
        this.m_result.setStatusMessage("Running...");
        String string = "(sub)experiment completed successfully";
        String string2 = this.m_experiment.getRunLower() != this.m_experiment.getRunUpper() ? "(dataset " + ((File)this.m_experiment.getDatasets().elementAt(0)).getName() : "(exp run # " + this.m_experiment.getRunLower();
        try {
            System.err.println("Initializing " + string2 + ")...");
            this.m_experiment.initialize();
            System.err.println("Iterating " + string2 + ")...");
            this.m_experiment.runExperiment();
            System.err.println("Postprocessing " + string2 + ")...");
            this.m_experiment.postProcess();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = "(sub)experiment " + string2 + ") failed : " + exception.toString();
            this.m_result.setExecutionStatus(2);
            this.m_result.setStatusMessage(string3);
            this.m_result.setTaskResult("Failed");
            return;
        }
        this.m_result.setExecutionStatus(3);
        this.m_result.setStatusMessage(string + " " + string2 + ").");
        this.m_result.setTaskResult("No errors");
    }

    public TaskStatusInfo getTaskStatus() {
        return this.m_result;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }
}

