/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import weka.core.parser.JFlex.StateSetEnumerator;

public final class StateSet {
    private final boolean DEBUG = false;
    public static final StateSet EMPTY = new StateSet();
    static final int BITS = 6;
    static final int MASK = 63;
    long[] bits;

    public StateSet() {
        this(256);
    }

    public StateSet(int n) {
        this.bits = new long[this.size2nbits(n)];
    }

    public StateSet(int n, int n2) {
        this(n);
        this.addState(n2);
    }

    public StateSet(StateSet stateSet) {
        this.bits = new long[stateSet.bits.length];
        System.arraycopy(stateSet.bits, 0, this.bits, 0, stateSet.bits.length);
    }

    public void addState(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            this.resize(n);
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] | 1L << (n & 0x3F);
    }

    private int size2nbits(int n) {
        return (n >> 6) + 1;
    }

    private void resize(int n) {
        int n2 = this.size2nbits(n);
        long[] lArray = new long[Math.max(this.bits.length * 4, n2)];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public void clear() {
        int n = this.bits.length;
        for (int i = 0; i < n; ++i) {
            this.bits[i] = 0L;
        }
    }

    public boolean isElement(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & 1L << (n & 0x3F)) != 0L;
    }

    public int getAndRemoveElement() {
        int n = 0;
        int n2 = 0;
        long l = 1L;
        while (this.bits[n] == 0L) {
            ++n;
        }
        while ((this.bits[n] & l) == 0L) {
            l <<= 1;
            ++n2;
        }
        int n3 = n;
        this.bits[n3] = this.bits[n3] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        return (n << 6) + n2;
    }

    public void remove(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            return;
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public StateSet complement(StateSet stateSet) {
        if (stateSet == null) {
            return null;
        }
        StateSet stateSet2 = new StateSet();
        stateSet2.bits = new long[stateSet.bits.length];
        int n = Math.min(this.bits.length, stateSet.bits.length);
        for (int i = 0; i < n; ++i) {
            stateSet2.bits[i] = (this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL) & stateSet.bits[i];
        }
        if (this.bits.length < stateSet.bits.length) {
            System.arraycopy(stateSet.bits, n, stateSet2.bits, n, stateSet2.bits.length - n);
        }
        return stateSet2;
    }

    public void add(StateSet stateSet) {
        long[] lArray;
        if (stateSet == null) {
            return;
        }
        long[] lArray2 = stateSet.bits;
        int n = lArray2.length;
        if (this.bits.length < n) {
            lArray = new long[n];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        } else {
            lArray = this.bits;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            lArray[n2] = lArray[n2] | lArray2[i];
        }
        this.bits = lArray;
    }

    public boolean containsSet(StateSet stateSet) {
        int n;
        int n2 = Math.min(this.bits.length, stateSet.bits.length);
        for (n = 0; n < n2; ++n) {
            if ((this.bits[n] & stateSet.bits[n]) == stateSet.bits[n]) continue;
            return false;
        }
        for (n = n2; n < stateSet.bits.length; ++n) {
            if (stateSet.bits[n] == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        int n;
        StateSet stateSet = (StateSet)object;
        int n2 = this.bits.length;
        int n3 = stateSet.bits.length;
        if (n2 <= n3) {
            for (n = 0; n < n2; ++n) {
                if (this.bits[n] == stateSet.bits[n]) continue;
                return false;
            }
            while (n < n3) {
                if (stateSet.bits[n++] == 0L) continue;
                return false;
            }
        } else {
            while (n < n3) {
                if (this.bits[n] != stateSet.bits[n]) {
                    return false;
                }
                ++n;
            }
            while (n < n2) {
                if (this.bits[n++] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n;
        long l = 1234L;
        long[] lArray = this.bits;
        for (n = this.bits.length - 1; n >= 0 && lArray[n] == 0L; --n) {
        }
        while (n >= 0) {
            l ^= lArray[n--] * (long)n;
        }
        return (int)(l >> 32 ^ l);
    }

    public StateSetEnumerator states() {
        return new StateSetEnumerator(this);
    }

    public boolean containsElements() {
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == 0L) continue;
            return true;
        }
        return false;
    }

    public StateSet copy() {
        StateSet stateSet = new StateSet();
        stateSet.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, stateSet.bits, 0, this.bits.length);
        return stateSet;
    }

    public void copy(StateSet stateSet) {
        if (stateSet == null) {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
            return;
        }
        if (this.bits.length < stateSet.bits.length) {
            this.bits = new long[stateSet.bits.length];
        } else {
            for (int i = stateSet.bits.length; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        }
        System.arraycopy(stateSet.bits, 0, this.bits, 0, this.bits.length);
    }

    public String toString() {
        StateSetEnumerator stateSetEnumerator = this.states();
        StringBuffer stringBuffer = new StringBuffer("{");
        if (stateSetEnumerator.hasMoreElements()) {
            stringBuffer.append("" + stateSetEnumerator.nextElement());
        }
        while (stateSetEnumerator.hasMoreElements()) {
            int n = stateSetEnumerator.nextElement();
            stringBuffer.append(", " + n);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

