/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import weka.core.parser.JFlex.CharSet;

public final class CharSetEnumerator {
    private int index;
    private int offset;
    private long mask = 1L;
    private CharSet set;

    public CharSetEnumerator(CharSet charSet) {
        this.set = charSet;
        while (this.index < this.set.bits.length && this.set.bits[this.index] == 0L) {
            ++this.index;
        }
        if (this.index >= this.set.bits.length) {
            return;
        }
        while (this.offset <= 63 && (this.set.bits[this.index] & this.mask) == 0L) {
            this.mask <<= 1;
            ++this.offset;
        }
    }

    private void advance() {
        do {
            ++this.offset;
            this.mask <<= 1;
        } while (this.offset <= 63 && (this.set.bits[this.index] & this.mask) == 0L);
        if (this.offset > 63) {
            do {
                ++this.index;
            } while (this.index < this.set.bits.length && this.set.bits[this.index] == 0L);
            if (this.index >= this.set.bits.length) {
                return;
            }
            this.offset = 0;
            this.mask = 1L;
            while (this.offset <= 63 && (this.set.bits[this.index] & this.mask) == 0L) {
                this.mask <<= 1;
                ++this.offset;
            }
        }
    }

    public boolean hasMoreElements() {
        return this.index < this.set.bits.length;
    }

    public int nextElement() {
        int n = (this.index << 6) + this.offset;
        this.advance();
        return n;
    }
}

