/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class ResultSetHelper {
    protected ResultSet m_ResultSet;
    protected boolean m_Initialized = false;
    protected int m_MaxRows = 0;
    protected int m_ColumnCount = 0;
    protected int m_RowCount = 0;
    protected String[] m_ColumnNames = null;
    protected boolean[] m_NumericColumns = null;
    protected Class[] m_ColumnClasses = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public ResultSetHelper(ResultSet resultSet) {
        this(resultSet, 0);
    }

    public ResultSetHelper(ResultSet resultSet, int n) {
        this.m_ResultSet = resultSet;
        this.m_MaxRows = n;
    }

    protected void initialize() {
        if (this.m_Initialized) {
            return;
        }
        try {
            block17: {
                int n;
                ResultSetMetaData resultSetMetaData = this.m_ResultSet.getMetaData();
                this.m_ColumnNames = new String[resultSetMetaData.getColumnCount()];
                for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                    this.m_ColumnNames[n - 1] = resultSetMetaData.getColumnName(n);
                }
                this.m_NumericColumns = new boolean[resultSetMetaData.getColumnCount()];
                for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                    this.m_NumericColumns[n - 1] = ResultSetHelper.typeIsNumeric(resultSetMetaData.getColumnType(n));
                }
                this.m_ColumnClasses = new Class[resultSetMetaData.getColumnCount()];
                for (n = 1; n <= resultSetMetaData.getColumnCount(); ++n) {
                    try {
                        this.m_ColumnClasses[n - 1] = Class.forName(resultSetMetaData.getColumnClassName(n));
                        continue;
                    }
                    catch (Exception exception) {
                        try {
                            this.m_ColumnClasses[n - 1] = ResultSetHelper.typeToClass(resultSetMetaData.getColumnType(n));
                            continue;
                        }
                        catch (Exception exception2) {
                            this.m_ColumnClasses[n - 1] = class$java$lang$String == null ? ResultSetHelper.class$("java.lang.String") : class$java$lang$String;
                        }
                    }
                }
                this.m_ColumnCount = resultSetMetaData.getColumnCount();
                this.m_RowCount = 0;
                this.m_ResultSet.first();
                if (this.m_MaxRows > 0) {
                    try {
                        this.m_ResultSet.absolute(this.m_MaxRows);
                        this.m_RowCount = this.m_ResultSet.getRow();
                    }
                    catch (Exception exception) {}
                } else {
                    this.m_ResultSet.last();
                    this.m_RowCount = this.m_ResultSet.getRow();
                }
                try {
                    if (this.m_RowCount != 0 || !this.m_ResultSet.first()) break block17;
                    this.m_RowCount = 1;
                    while (this.m_ResultSet.next()) {
                        ++this.m_RowCount;
                        if (this.m_ResultSet.getRow() != this.m_MaxRows) continue;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_Initialized = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ResultSet getResultSet() {
        return this.m_ResultSet;
    }

    public int getColumnCount() {
        this.initialize();
        return this.m_ColumnCount;
    }

    public int getRowCount() {
        this.initialize();
        return this.m_RowCount;
    }

    public String[] getColumnNames() {
        this.initialize();
        return this.m_ColumnNames;
    }

    public boolean[] getNumericColumns() {
        this.initialize();
        return this.m_NumericColumns;
    }

    public Class[] getColumnClasses() {
        this.initialize();
        return this.m_ColumnClasses;
    }

    public boolean hasMaxRows() {
        return this.m_MaxRows > 0;
    }

    public int getMaxRows() {
        return this.m_MaxRows;
    }

    public Object[][] getCells() {
        this.initialize();
        Object[][] objectArray = new Object[this.getRowCount()][this.getColumnCount()];
        try {
            this.m_ResultSet.first();
            for (int i = 0; i < this.getRowCount(); ++i) {
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    objectArray[i][j] = this.m_ResultSet.getObject(j + 1);
                }
                if (i != this.getRowCount() - 1) {
                    this.m_ResultSet.next();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return objectArray;
    }

    public static Class typeToClass(int n) {
        Class clazz;
        switch (n) {
            case -5: {
                clazz = class$java$lang$Long == null ? (class$java$lang$Long = ResultSetHelper.class$("java.lang.Long")) : class$java$lang$Long;
                break;
            }
            case -2: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = ResultSetHelper.class$("java.lang.String")) : class$java$lang$String;
            }
            case -7: {
                clazz = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ResultSetHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                break;
            }
            case 1: {
                clazz = class$java$lang$Character == null ? (class$java$lang$Character = ResultSetHelper.class$("java.lang.Character")) : class$java$lang$Character;
                break;
            }
            case 91: {
                clazz = class$java$sql$Date == null ? (class$java$sql$Date = ResultSetHelper.class$("java.sql.Date")) : class$java$sql$Date;
                break;
            }
            case 3: {
                clazz = class$java$lang$Double == null ? (class$java$lang$Double = ResultSetHelper.class$("java.lang.Double")) : class$java$lang$Double;
                break;
            }
            case 8: {
                clazz = class$java$lang$Double == null ? (class$java$lang$Double = ResultSetHelper.class$("java.lang.Double")) : class$java$lang$Double;
                break;
            }
            case 6: {
                clazz = class$java$lang$Float == null ? (class$java$lang$Float = ResultSetHelper.class$("java.lang.Float")) : class$java$lang$Float;
                break;
            }
            case 4: {
                clazz = class$java$lang$Integer == null ? (class$java$lang$Integer = ResultSetHelper.class$("java.lang.Integer")) : class$java$lang$Integer;
                break;
            }
            case -4: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = ResultSetHelper.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case -1: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = ResultSetHelper.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 0: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = ResultSetHelper.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 2: {
                clazz = class$java$lang$Double == null ? (class$java$lang$Double = ResultSetHelper.class$("java.lang.Double")) : class$java$lang$Double;
                break;
            }
            case 1111: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = ResultSetHelper.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 7: {
                clazz = class$java$lang$Double == null ? (class$java$lang$Double = ResultSetHelper.class$("java.lang.Double")) : class$java$lang$Double;
                break;
            }
            case 5: {
                clazz = class$java$lang$Short == null ? (class$java$lang$Short = ResultSetHelper.class$("java.lang.Short")) : class$java$lang$Short;
                break;
            }
            case 92: {
                clazz = class$java$sql$Time == null ? (class$java$sql$Time = ResultSetHelper.class$("java.sql.Time")) : class$java$sql$Time;
                break;
            }
            case 93: {
                clazz = class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ResultSetHelper.class$("java.sql.Timestamp")) : class$java$sql$Timestamp;
                break;
            }
            case -6: {
                clazz = class$java$lang$Short == null ? (class$java$lang$Short = ResultSetHelper.class$("java.lang.Short")) : class$java$lang$Short;
                break;
            }
            case -3: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = ResultSetHelper.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            case 12: {
                clazz = class$java$lang$String == null ? (class$java$lang$String = ResultSetHelper.class$("java.lang.String")) : class$java$lang$String;
                break;
            }
            default: {
                clazz = null;
            }
        }
        return clazz;
    }

    public static boolean typeIsNumeric(int n) {
        boolean bl;
        switch (n) {
            case -5: {
                bl = true;
                break;
            }
            case -2: {
                bl = false;
            }
            case -7: {
                bl = false;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            case 91: {
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 8: {
                bl = true;
                break;
            }
            case 6: {
                bl = true;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            case -4: {
                bl = false;
                break;
            }
            case -1: {
                bl = false;
                break;
            }
            case 0: {
                bl = false;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 1111: {
                bl = false;
                break;
            }
            case 7: {
                bl = true;
                break;
            }
            case 5: {
                bl = true;
                break;
            }
            case 92: {
                bl = false;
                break;
            }
            case 93: {
                bl = true;
                break;
            }
            case -6: {
                bl = true;
                break;
            }
            case -3: {
                bl = false;
                break;
            }
            case 12: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

