/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.Utils;
import weka.gui.ComponentHelper;
import weka.gui.JTableHelper;
import weka.gui.ListSelectorDialog;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.arffviewer.ArffTable;
import weka.gui.arffviewer.ArffTableCellRenderer;

public class ArffPanel
extends JPanel
implements ActionListener,
ChangeListener,
MouseListener,
Undoable {
    public static final String TAB_INSTANCES = "Instances";
    private ArffTable tableArff;
    private JPopupMenu popupHeader;
    private JPopupMenu popupRows;
    private JLabel labelName;
    private JMenuItem menuItemMean;
    private JMenuItem menuItemSetAllValues;
    private JMenuItem menuItemSetMissingValues;
    private JMenuItem menuItemReplaceValues;
    private JMenuItem menuItemRenameAttribute;
    private JMenuItem menuItemAttributeAsClass;
    private JMenuItem menuItemDeleteAttribute;
    private JMenuItem menuItemDeleteAttributes;
    private JMenuItem menuItemSortInstances;
    private JMenuItem menuItemDeleteSelectedInstance;
    private JMenuItem menuItemDeleteAllSelectedInstances;
    private JMenuItem menuItemSearch;
    private JMenuItem menuItemClearSearch;
    private JMenuItem menuItemUndo;
    private JMenuItem menuItemCopy;
    private JMenuItem menuItemOptimalColWidth;
    private JMenuItem menuItemOptimalColWidths;
    private String filename;
    private String title;
    private int currentCol;
    private boolean changed;
    private HashSet changeListeners;
    private String lastSearch;
    private String lastReplace;

    public ArffPanel() {
        this.initialize();
        this.createPanel();
    }

    public ArffPanel(String string) {
        this();
        this.loadFile(string);
    }

    public ArffPanel(Instances instances) {
        this();
        this.filename = "";
        this.setInstances(instances);
    }

    protected void initialize() {
        this.filename = "";
        this.title = "";
        this.currentCol = -1;
        this.lastSearch = "";
        this.lastReplace = "";
        this.changed = false;
        this.changeListeners = new HashSet();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.popupHeader = new JPopupMenu();
        this.popupHeader.addMouseListener(this);
        this.menuItemMean = new JMenuItem("Get mean...");
        this.menuItemMean.addActionListener(this);
        this.popupHeader.add(this.menuItemMean);
        this.popupHeader.addSeparator();
        this.menuItemSetAllValues = new JMenuItem("Set all values to...");
        this.menuItemSetAllValues.addActionListener(this);
        this.popupHeader.add(this.menuItemSetAllValues);
        this.menuItemSetMissingValues = new JMenuItem("Set missing values to...");
        this.menuItemSetMissingValues.addActionListener(this);
        this.popupHeader.add(this.menuItemSetMissingValues);
        this.menuItemReplaceValues = new JMenuItem("Replace values with...");
        this.menuItemReplaceValues.addActionListener(this);
        this.popupHeader.add(this.menuItemReplaceValues);
        this.popupHeader.addSeparator();
        this.menuItemRenameAttribute = new JMenuItem("Rename attribute...");
        this.menuItemRenameAttribute.addActionListener(this);
        this.popupHeader.add(this.menuItemRenameAttribute);
        this.menuItemAttributeAsClass = new JMenuItem("Attribute as class");
        this.menuItemAttributeAsClass.addActionListener(this);
        this.popupHeader.add(this.menuItemAttributeAsClass);
        this.menuItemDeleteAttribute = new JMenuItem("Delete attribute");
        this.menuItemDeleteAttribute.addActionListener(this);
        this.popupHeader.add(this.menuItemDeleteAttribute);
        this.menuItemDeleteAttributes = new JMenuItem("Delete attributes...");
        this.menuItemDeleteAttributes.addActionListener(this);
        this.popupHeader.add(this.menuItemDeleteAttributes);
        this.menuItemSortInstances = new JMenuItem("Sort data (ascending)");
        this.menuItemSortInstances.addActionListener(this);
        this.popupHeader.add(this.menuItemSortInstances);
        this.popupHeader.addSeparator();
        this.menuItemOptimalColWidth = new JMenuItem("Optimal column width (current)");
        this.menuItemOptimalColWidth.addActionListener(this);
        this.popupHeader.add(this.menuItemOptimalColWidth);
        this.menuItemOptimalColWidths = new JMenuItem("Optimal column width (all)");
        this.menuItemOptimalColWidths.addActionListener(this);
        this.popupHeader.add(this.menuItemOptimalColWidths);
        this.popupRows = new JPopupMenu();
        this.popupRows.addMouseListener(this);
        this.menuItemUndo = new JMenuItem("Undo");
        this.menuItemUndo.addActionListener(this);
        this.popupRows.add(this.menuItemUndo);
        this.popupRows.addSeparator();
        this.menuItemCopy = new JMenuItem("Copy");
        this.menuItemCopy.addActionListener(this);
        this.popupRows.add(this.menuItemCopy);
        this.popupRows.addSeparator();
        this.menuItemSearch = new JMenuItem("Search...");
        this.menuItemSearch.addActionListener(this);
        this.popupRows.add(this.menuItemSearch);
        this.menuItemClearSearch = new JMenuItem("Clear search");
        this.menuItemClearSearch.addActionListener(this);
        this.popupRows.add(this.menuItemClearSearch);
        this.popupRows.addSeparator();
        this.menuItemDeleteSelectedInstance = new JMenuItem("Delete selected instance");
        this.menuItemDeleteSelectedInstance.addActionListener(this);
        this.popupRows.add(this.menuItemDeleteSelectedInstance);
        this.menuItemDeleteAllSelectedInstances = new JMenuItem("Delete ALL selected instances");
        this.menuItemDeleteAllSelectedInstances.addActionListener(this);
        this.popupRows.add(this.menuItemDeleteAllSelectedInstances);
        this.tableArff = new ArffTable();
        this.tableArff.setToolTipText("Right click for context menu");
        this.tableArff.getTableHeader().addMouseListener(this);
        this.tableArff.getTableHeader().setToolTipText("<html><b>Sort view:</b> left click = ascending / Shift + left click = descending<br><b>Menu:</b> right click</html>");
        this.tableArff.getTableHeader().setDefaultRenderer(new ArffTableCellRenderer());
        this.tableArff.addChangeListener(this);
        this.tableArff.addMouseListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.tableArff);
        this.add((Component)jScrollPane, "Center");
        this.labelName = new JLabel();
        this.add((Component)this.labelName, "North");
    }

    private void setMenu() {
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.tableArff.getModel();
        boolean bl = arffSortedTableModel.getInstances().numAttributes() > 0;
        boolean bl2 = arffSortedTableModel.getInstances().numInstances() > 0;
        boolean bl3 = bl && this.currentCol > 0;
        boolean bl4 = bl3 && arffSortedTableModel.getAttributeAt(this.currentCol).isNumeric();
        this.menuItemUndo.setEnabled(this.canUndo());
        this.menuItemCopy.setEnabled(true);
        this.menuItemSearch.setEnabled(true);
        this.menuItemClearSearch.setEnabled(true);
        this.menuItemMean.setEnabled(bl4);
        this.menuItemSetAllValues.setEnabled(bl3);
        this.menuItemSetMissingValues.setEnabled(bl3);
        this.menuItemReplaceValues.setEnabled(bl3);
        this.menuItemRenameAttribute.setEnabled(bl3);
        this.menuItemDeleteAttribute.setEnabled(bl3);
        this.menuItemDeleteAttributes.setEnabled(bl3);
        this.menuItemSortInstances.setEnabled(bl2 && bl3);
        this.menuItemDeleteSelectedInstance.setEnabled(bl2 && this.tableArff.getSelectedRow() > -1);
        this.menuItemDeleteAllSelectedInstances.setEnabled(bl2 && this.tableArff.getSelectedRows().length > 0);
    }

    public ArffTable getTable() {
        return this.tableArff;
    }

    public String getTitle() {
        return this.title;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
        this.createTitle();
    }

    public Instances getInstances() {
        Instances instances = null;
        if (this.tableArff.getModel() != null) {
            instances = ((ArffSortedTableModel)this.tableArff.getModel()).getInstances();
        }
        return instances;
    }

    public void setInstances(Instances instances) {
        this.filename = TAB_INSTANCES;
        this.createTitle();
        ArffSortedTableModel arffSortedTableModel = instances == null ? null : new ArffSortedTableModel(instances);
        this.tableArff.setModel(arffSortedTableModel);
        this.clearUndo();
        this.setChanged(false);
        this.createName();
    }

    public Vector getAttributes() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.getInstances().numAttributes(); ++i) {
            vector.add(this.getInstances().attribute(i).name());
        }
        Collections.sort(vector);
        return vector;
    }

    public void setChanged(boolean bl) {
        if (!bl) {
            this.changed = bl;
            this.createTitle();
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isUndoEnabled() {
        return ((ArffSortedTableModel)this.tableArff.getModel()).isUndoEnabled();
    }

    public void setUndoEnabled(boolean bl) {
        ((ArffSortedTableModel)this.tableArff.getModel()).setUndoEnabled(bl);
    }

    public void clearUndo() {
        ((ArffSortedTableModel)this.tableArff.getModel()).clearUndo();
    }

    public boolean canUndo() {
        return ((ArffSortedTableModel)this.tableArff.getModel()).canUndo();
    }

    public void undo() {
        if (this.canUndo()) {
            ((ArffSortedTableModel)this.tableArff.getModel()).undo();
            this.notifyListener();
        }
    }

    public void addUndoPoint() {
        ((ArffSortedTableModel)this.tableArff.getModel()).addUndoPoint();
        this.setMenu();
    }

    private void createTitle() {
        if (this.filename.equals("")) {
            this.title = "-none-";
        } else if (this.filename.equals(TAB_INSTANCES)) {
            this.title = TAB_INSTANCES;
        } else {
            try {
                File file = new File(this.filename);
                this.title = file.getName();
            }
            catch (Exception exception) {
                this.title = "-none-";
            }
        }
        if (this.isChanged()) {
            this.title = this.title + " *";
        }
    }

    private void createName() {
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.tableArff.getModel();
        if (arffSortedTableModel != null) {
            this.labelName.setText("Relation: " + arffSortedTableModel.getInstances().relationName());
        } else {
            this.labelName.setText("");
        }
    }

    private void loadFile(String string) {
        this.filename = string;
        this.createTitle();
        ArffSortedTableModel arffSortedTableModel = string.equals("") ? null : new ArffSortedTableModel(string);
        this.tableArff.setModel(arffSortedTableModel);
        this.setChanged(false);
        this.createName();
    }

    private void calcMean() {
        if (this.currentCol == -1) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.tableArff.getModel();
        if (!arffSortedTableModel.getAttributeAt(this.currentCol).isNumeric()) {
            return;
        }
        double d = 0.0;
        for (int i = 0; i < arffSortedTableModel.getRowCount(); ++i) {
            d += arffSortedTableModel.getInstances().instance(i).value(this.currentCol - 1);
        }
        ComponentHelper.showMessageBox(this.getParent(), "Mean for attribute...", "Mean for attribute '" + this.tableArff.getPlainColumnName(this.currentCol) + "':\n\t" + Utils.doubleToString(d /= (double)arffSortedTableModel.getRowCount(), 3), 2, -1);
    }

    private void setValues(Object object) {
        String string;
        String string2;
        String string3 = "";
        String string4 = "";
        if (object == this.menuItemSetMissingValues) {
            string2 = "Replace missing values...";
            string = "New value for MISSING values";
        } else if (object == this.menuItemSetAllValues) {
            string2 = "Set all values...";
            string = "New value for ALL values";
        } else if (object == this.menuItemReplaceValues) {
            string2 = "Replace values...";
            string = "Old value";
        } else {
            return;
        }
        string3 = ComponentHelper.showInputBox(this.tableArff.getParent(), string2, string, this.lastSearch);
        if (string3 == null) {
            return;
        }
        this.lastSearch = string3;
        if (object == this.menuItemReplaceValues) {
            string4 = ComponentHelper.showInputBox(this.tableArff.getParent(), string2, "New value", this.lastReplace);
            if (string4 == null) {
                return;
            }
            this.lastReplace = string4;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.tableArff.getModel();
        arffSortedTableModel.setNotificationEnabled(false);
        this.addUndoPoint();
        arffSortedTableModel.setUndoEnabled(false);
        for (int i = 0; i < this.tableArff.getRowCount(); ++i) {
            if (object == this.menuItemSetAllValues) {
                arffSortedTableModel.setValueAt(string3, i, this.currentCol);
                continue;
            }
            if (object == this.menuItemSetMissingValues && arffSortedTableModel.isMissingAt(i, this.currentCol)) {
                arffSortedTableModel.setValueAt(string3, i, this.currentCol);
                continue;
            }
            if (object != this.menuItemReplaceValues || !arffSortedTableModel.getValueAt(i, this.currentCol).toString().equals(string3)) continue;
            arffSortedTableModel.setValueAt(string4, i, this.currentCol);
        }
        arffSortedTableModel.setUndoEnabled(true);
        arffSortedTableModel.setNotificationEnabled(true);
        arffSortedTableModel.notifyListener(new TableModelEvent(arffSortedTableModel, 0, arffSortedTableModel.getRowCount(), this.currentCol, 0));
        this.tableArff.repaint();
    }

    public void deleteAttribute() {
        if (this.currentCol == -1) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.tableArff.getModel();
        if (arffSortedTableModel.getAttributeAt(this.currentCol) == null) {
            return;
        }
        if (ComponentHelper.showMessageBox(this.getParent(), "Confirm...", "Do you really want to delete the attribute '" + arffSortedTableModel.getAttributeAt(this.currentCol).name() + "'?", 0, 3) != 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        arffSortedTableModel.deleteAttributeAt(this.currentCol);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteAttributes() {
        JList jList = new JList(this.getAttributes());
        ListSelectorDialog listSelectorDialog = new ListSelectorDialog(null, jList);
        int n = listSelectorDialog.showDialog();
        if (n != 0) {
            return;
        }
        Object[] objectArray = jList.getSelectedValues();
        if (ComponentHelper.showMessageBox(this.getParent(), "Confirm...", "Do you really want to delete these " + objectArray.length + " attributes?", 0, 3) != 0) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.tableArff.getModel();
        int[] nArray = new int[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nArray[i] = arffSortedTableModel.getAttributeColumn(objectArray[i].toString());
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        arffSortedTableModel.deleteAttributes(nArray);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void attributeAsClass() {
        if (this.currentCol == -1) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.tableArff.getModel();
        if (arffSortedTableModel.getAttributeAt(this.currentCol) == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        arffSortedTableModel.attributeAsClassAt(this.currentCol);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void renameAttribute() {
        if (this.currentCol == -1) {
            return;
        }
        ArffSortedTableModel arffSortedTableModel = (ArffSortedTableModel)this.tableArff.getModel();
        if (arffSortedTableModel.getAttributeAt(this.currentCol) == null) {
            return;
        }
        String string = ComponentHelper.showInputBox(this.getParent(), "Rename attribute...", "Enter new Attribute name", arffSortedTableModel.getAttributeAt(this.currentCol).name());
        if (string == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        arffSortedTableModel.renameAttributeAt(this.currentCol, string);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteInstance() {
        int n = this.tableArff.getSelectedRow();
        if (n == -1) {
            return;
        }
        ((ArffSortedTableModel)this.tableArff.getModel()).deleteInstanceAt(n);
    }

    public void deleteInstances() {
        if (this.tableArff.getSelectedRow() == -1) {
            return;
        }
        int[] nArray = this.tableArff.getSelectedRows();
        ((ArffSortedTableModel)this.tableArff.getModel()).deleteInstances(nArray);
    }

    public void sortInstances() {
        if (this.currentCol == -1) {
            return;
        }
        ((ArffSortedTableModel)this.tableArff.getModel()).sortInstances(this.currentCol);
    }

    public void copyContent() {
        StringSelection stringSelection = this.getTable().getStringSelection();
        if (stringSelection == null) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    public void search() {
        String string = ComponentHelper.showInputBox(this.getParent(), "Search...", "Enter the string to search for", this.lastSearch);
        if (string != null) {
            this.lastSearch = string;
        }
        this.getTable().setSearchString(string);
    }

    public void clearSearch() {
        this.getTable().setSearchString("");
    }

    public void setOptimalColWidth() {
        if (this.currentCol == -1) {
            return;
        }
        JTableHelper.setOptimalColumnWidth(this.getTable(), this.currentCol);
    }

    public void setOptimalColWidths() {
        JTableHelper.setOptimalColumnWidth(this.getTable());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.menuItemMean) {
            this.calcMean();
        } else if (object == this.menuItemSetAllValues) {
            this.setValues(this.menuItemSetAllValues);
        } else if (object == this.menuItemSetMissingValues) {
            this.setValues(this.menuItemSetMissingValues);
        } else if (object == this.menuItemReplaceValues) {
            this.setValues(this.menuItemReplaceValues);
        } else if (object == this.menuItemRenameAttribute) {
            this.renameAttribute();
        } else if (object == this.menuItemAttributeAsClass) {
            this.attributeAsClass();
        } else if (object == this.menuItemDeleteAttribute) {
            this.deleteAttribute();
        } else if (object == this.menuItemDeleteAttributes) {
            this.deleteAttributes();
        } else if (object == this.menuItemDeleteSelectedInstance) {
            this.deleteInstance();
        } else if (object == this.menuItemDeleteAllSelectedInstances) {
            this.deleteInstances();
        } else if (object == this.menuItemSortInstances) {
            this.sortInstances();
        } else if (object == this.menuItemSearch) {
            this.search();
        } else if (object == this.menuItemClearSearch) {
            this.clearSearch();
        } else if (object == this.menuItemUndo) {
            this.undo();
        } else if (object == this.menuItemCopy) {
            this.copyContent();
        } else if (object == this.menuItemOptimalColWidth) {
            this.setOptimalColWidth();
        } else if (object == this.menuItemOptimalColWidths) {
            this.setOptimalColWidths();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.tableArff.columnAtPoint(mouseEvent.getPoint());
        if (mouseEvent.getSource() == this.tableArff.getTableHeader()) {
            this.currentCol = n;
            if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
                mouseEvent.consume();
                this.setMenu();
                this.popupHeader.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (mouseEvent.getSource() == this.tableArff && mouseEvent.getButton() == 3 && mouseEvent.getClickCount() == 1) {
            mouseEvent.consume();
            this.setMenu();
            this.popupRows.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1 && n > -1) {
            this.tableArff.setSelectedColumn(n);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.changed = true;
        this.createTitle();
        this.notifyListener();
    }

    public void notifyListener() {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }
}

