/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.NormalizedPolyKernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Statistics;
import weka.core.Tag;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.core.matrix.LUDecomposition;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class GaussianProcesses
extends Classifier
implements OptionHandler,
IntervalEstimator {
    protected boolean m_onlyNumeric;
    protected NominalToBinary m_NominalToBinary;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_checksTurnedOff = false;
    protected boolean m_featureSpaceNormalization = false;
    protected boolean m_usePoly = false;
    protected int m_cacheSize = 1;
    protected boolean m_lowerOrder = false;
    protected double m_exponent = 1.0;
    protected double m_gamma = 1.0;
    protected double m_delta = 1.0;
    protected int m_classIndex = -1;
    protected double m_Alin;
    protected double m_Blin;
    protected Kernel m_kernel;
    protected Instances m_data;
    protected double m_avg_target;
    protected Matrix m_C;
    protected Matrix m_t;

    public String globalInfo() {
        return "Implements Gaussian Processes for regression without hyperparameter-tuning. For more information see\n\nDavid J.C. Mackay, Introduction to Gaussian Processes. http://wol.ra.phy.cam.ac.uk/mackay/gpB.ps.gz";
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!this.m_checksTurnedOff) {
            if (instances.checkForStringAttributes()) {
                throw new UnsupportedAttributeTypeException("Cannot handle string attributes!");
            }
            if (instances.classAttribute().isNominal()) {
                throw new UnsupportedClassTypeException("This implementation of Gaussian Processes can't handle a nominal class!");
            }
            instances = new Instances(instances);
            instances.deleteWithMissingClass();
            if (instances.numInstances() == 0) {
                throw new Exception("No training instances without a missing class!");
            }
        }
        this.m_onlyNumeric = true;
        if (!this.m_checksTurnedOff) {
            for (int i = 0; i < instances.numAttributes(); ++i) {
                if (i == instances.classIndex() || instances.attribute(i).isNumeric()) continue;
                this.m_onlyNumeric = false;
                break;
            }
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary = new NominalToBinary();
            this.m_NominalToBinary.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_NominalToBinary);
        } else {
            this.m_NominalToBinary = null;
        }
        this.m_classIndex = instances.classIndex();
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_data = instances;
        if (this.m_Filter != null) {
            Instance instance = (Instance)instances.instance(0).copy();
            instance.setValue(this.m_classIndex, 0.0);
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            Instance instance2 = this.m_Filter.output();
            this.m_Blin = instance2.value(this.m_classIndex);
            instance.setValue(this.m_classIndex, 1.0);
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance2 = this.m_Filter.output();
            this.m_Alin = instance2.value(this.m_classIndex) - this.m_Blin;
        } else {
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
        }
        this.m_kernel = !this.m_usePoly ? new RBFKernel(this.m_data, this.m_cacheSize, this.m_gamma) : (this.m_featureSpaceNormalization ? new NormalizedPolyKernel(this.m_data, this.m_cacheSize, this.m_exponent, this.m_lowerOrder) : new PolyKernel(this.m_data, this.m_cacheSize, this.m_exponent, this.m_lowerOrder));
        this.m_C = new Matrix(this.m_data.numInstances(), this.m_data.numInstances());
        double d = 0.0;
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            d += this.m_data.instance(i).classValue();
            for (int j = 0; j < i; ++j) {
                double d2 = this.m_kernel.eval(i, j, this.m_data.instance(i));
                this.m_C.set(i, j, d2);
                this.m_C.set(j, i, d2);
            }
            double d3 = this.m_kernel.eval(i, i, this.m_data.instance(i));
            this.m_C.set(i, i, d3 + this.m_delta * this.m_delta);
        }
        this.m_avg_target = d / (double)this.m_data.numInstances();
        LUDecomposition lUDecomposition = new LUDecomposition(this.m_C);
        if (!lUDecomposition.isNonsingular()) {
            throw new Exception("Singular Matrix?!?");
        }
        Matrix matrix = Matrix.identity(this.m_data.numInstances(), this.m_data.numInstances());
        this.m_C = lUDecomposition.solve(matrix);
        this.m_t = new Matrix(this.m_data.numInstances(), 1);
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            this.m_t.set(i, 0, this.m_data.instance(i).classValue() - this.m_avg_target);
        }
        this.m_t = this.m_C.times(this.m_t);
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        Matrix matrix = new Matrix(this.m_data.numInstances(), 1);
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            matrix.set(i, 0, this.m_kernel.eval(-1, i, instance));
        }
        double d = matrix.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        return d;
    }

    public double[][] predictInterval(Instance instance, double d) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary.input(instance);
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        Matrix matrix = new Matrix(this.m_data.numInstances(), 1);
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            matrix.set(i, 0, this.m_kernel.eval(-1, i, instance));
        }
        double d2 = this.m_kernel.eval(-1, -1, instance) + this.m_delta * this.m_delta;
        double d3 = matrix.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        double d4 = Math.sqrt(d2 - matrix.transpose().times(this.m_C).times(matrix).get(0, 0));
        d = 1.0 - (1.0 - d) / 2.0;
        double d5 = Statistics.normalInverse(d);
        double[][] dArray = new double[1][2];
        dArray[0][0] = d3 - d5 * d4;
        dArray[0][1] = d3 + d5 * d4;
        return dArray;
    }

    public double getStandardDeviation(Instance instance) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(instance);
            this.m_Missing.batchFinished();
            instance = this.m_Missing.output();
        }
        if (!this.m_onlyNumeric) {
            this.m_NominalToBinary.input(instance);
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
            this.m_NominalToBinary.batchFinished();
            instance = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        Matrix matrix = new Matrix(this.m_data.numInstances(), 1);
        for (int i = 0; i < this.m_data.numInstances(); ++i) {
            matrix.set(i, 0, this.m_kernel.eval(-1, i, instance));
        }
        double d = this.m_kernel.eval(-1, -1, instance) + this.m_delta * this.m_delta;
        double d2 = d - matrix.transpose().times(this.m_C).times(matrix).get(0, 0);
        if (d2 < 0.0) {
            System.out.println("Aiaiai: variance is negative (" + d2 + ")!!!");
        }
        double d3 = Math.sqrt(d2);
        return d3;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tThe exponent for the polynomial kernel. (default 1)", "E", 1, "-E <double>"));
        vector.addElement(new Option("\tGamma for the RBF kernel. (default 0.01)", "G", 1, "-G <double>"));
        vector.addElement(new Option("\tLevel of Gaussian Noise. (default 0.1)", "L", 1, "-L <double>"));
        vector.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither. (default 0=normalize)", "N", 1, "-N"));
        vector.addElement(new Option("\tFeature-space normalization (only for\n\tnon-linear polynomial kernels).", "F", 0, "-F"));
        vector.addElement(new Option("\tUse lower-order terms (only for non-linear\n\tpolynomial kernels).", "O", 0, "-O"));
        vector.addElement(new Option("\tUse Polynomial kernel. (default false)", "P", 0, "-P"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('E', stringArray);
        this.m_exponent = string.length() != 0 ? new Double(string) : 1.0;
        String string2 = Utils.getOption('G', stringArray);
        this.m_gamma = string2.length() != 0 ? new Double(string2) : 1.0;
        String string3 = Utils.getOption('L', stringArray);
        this.m_delta = string3.length() != 0 ? new Double(string3) : 1.0;
        this.m_usePoly = Utils.getFlag('P', stringArray);
        String string4 = Utils.getOption('N', stringArray);
        if (string4.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(string4), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        this.m_featureSpaceNormalization = Utils.getFlag('F', stringArray);
        if (!this.m_usePoly && this.m_featureSpaceNormalization) {
            throw new Exception("RBF machine doesn't require feature-space normalization.");
        }
        if (this.m_exponent == 1.0 && this.m_featureSpaceNormalization) {
            throw new Exception("Can't use feature-space normalization with linear kernel.");
        }
        this.m_lowerOrder = Utils.getFlag('O', stringArray);
        if (!this.m_usePoly && this.m_lowerOrder) {
            throw new Exception("Can't use lower-order terms with RBF kernel.");
        }
        if (this.m_exponent == 1.0 && this.m_lowerOrder) {
            throw new Exception("Can't use lower-order terms with linear kernel.");
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-E");
        vector.add("" + this.m_exponent);
        vector.add("-G");
        vector.add("" + this.m_gamma);
        vector.add("-L");
        vector.add("" + this.m_delta);
        vector.add("-N");
        vector.add("" + this.m_filterType);
        if (this.m_featureSpaceNormalization) {
            vector.add("-F");
        }
        if (this.m_lowerOrder) {
            vector.add("-O");
        }
        if (this.m_usePoly) {
            vector.add("-P");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_FILTER) {
            this.m_filterType = selectedTag.getSelectedTag().getID();
        }
    }

    public String exponentTipText() {
        return "The exponent for the polynomial kernel.";
    }

    public double getExponent() {
        return this.m_exponent;
    }

    public void setExponent(double d) {
        if (d == 1.0) {
            this.m_featureSpaceNormalization = false;
            this.m_lowerOrder = false;
        }
        this.m_exponent = d;
    }

    public String gammaTipText() {
        return "The value of the gamma parameter for RBF kernels.";
    }

    public double getGamma() {
        return this.m_gamma;
    }

    public void setGamma(double d) {
        this.m_gamma = d;
    }

    public String noiseTipText() {
        return "The level of Gaussian Noise (added to the diagonal of the Covariance Matrix).";
    }

    public double getNoise() {
        return this.m_delta;
    }

    public void setNoise(double d) {
        this.m_delta = d;
    }

    public String usePolyTipText() {
        return "Whether to use an Polynomial kernel instead of an RBF one.";
    }

    public boolean getUsePoly() {
        return this.m_usePoly;
    }

    public void setUsePoly(boolean bl) {
        if (!bl) {
            this.m_featureSpaceNormalization = false;
            this.m_lowerOrder = false;
        }
        this.m_usePoly = bl;
    }

    public String featureSpaceNormalizationTipText() {
        return "Whether feature-space normalization is performed (only available for non-linear polynomial kernels).";
    }

    public boolean getFeatureSpaceNormalization() throws Exception {
        return this.m_featureSpaceNormalization;
    }

    public void setFeatureSpaceNormalization(boolean bl) throws Exception {
        this.m_featureSpaceNormalization = !this.m_usePoly || this.m_exponent == 1.0 ? false : bl;
    }

    public String lowerOrderTermsTipText() {
        return "Whether lower order polyomials are also used (only available for non-linear polynomial kernels).";
    }

    public boolean getLowerOrderTerms() {
        return this.m_lowerOrder;
    }

    public void setLowerOrderTerms(boolean bl) {
        this.m_lowerOrder = this.m_exponent == 1.0 || !this.m_usePoly ? false : bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_t == null) {
            return "Gaussian Processes: No model built yet.";
        }
        try {
            int n;
            stringBuffer.append("Gaussian Processes\n\n");
            stringBuffer.append("Kernel used : \n");
            if (!this.m_usePoly) {
                stringBuffer.append("  RBF kernel : K(x,y) = e^-(" + this.m_gamma + "* <x-y,x-y>^2)");
            } else if (this.m_exponent == 1.0) {
                stringBuffer.append("  Linear Kernel : K(x,y) = <x,y>");
            } else if (this.m_featureSpaceNormalization) {
                if (this.m_lowerOrder) {
                    stringBuffer.append("  Normalized Poly Kernel with lower order : K(x,y) = (<x,y>+1)^" + this.m_exponent + "/" + "((<x,x>+1)^" + this.m_exponent + "*" + "(<y,y>+1)^" + this.m_exponent + ")^(1/2)");
                } else {
                    stringBuffer.append("  Normalized Poly Kernel : K(x,y) = <x,y>^" + this.m_exponent + "/" + "(<x,x>^" + this.m_exponent + "*" + "<y,y>^" + this.m_exponent + ")^(1/2)");
                }
            } else if (this.m_lowerOrder) {
                stringBuffer.append("  Poly Kernel with lower order : K(x,y) = (<x,y> + 1)^" + this.m_exponent);
            } else {
                stringBuffer.append("  Poly Kernel : K(x,y) = <x,y>^" + this.m_exponent);
            }
            stringBuffer.append("\n\n");
            stringBuffer.append("Average Target Value : " + this.m_avg_target + "\n");
            stringBuffer.append("Inverted Covariance Matrix:\n");
            double d = this.m_C.get(0, 0);
            double d2 = this.m_C.get(0, 0);
            for (n = 0; n < this.m_data.numInstances(); ++n) {
                for (int i = 0; i < this.m_data.numInstances(); ++i) {
                    if (this.m_C.get(n, i) < d) {
                        d = this.m_C.get(n, i);
                        continue;
                    }
                    if (!(this.m_C.get(n, i) > d2)) continue;
                    d2 = this.m_C.get(n, i);
                }
            }
            stringBuffer.append("    Lowest Value = " + d + "\n");
            stringBuffer.append("    Highest Value = " + d2 + "\n");
            stringBuffer.append("Inverted Covariance Matrix * Target-value Vector:\n");
            d = this.m_t.get(0, 0);
            d2 = this.m_t.get(0, 0);
            for (n = 0; n < this.m_data.numInstances(); ++n) {
                if (this.m_t.get(n, 0) < d) {
                    d = this.m_t.get(n, 0);
                    continue;
                }
                if (!(this.m_t.get(n, 0) > d2)) continue;
                d2 = this.m_t.get(n, 0);
            }
            stringBuffer.append("    Lowest Value = " + d + "\n");
            stringBuffer.append("    Highest Value = " + d2 + "\n \n");
        }
        catch (Exception exception) {
            return "Can't print the classifier.";
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            GaussianProcesses gaussianProcesses = new GaussianProcesses();
            System.out.println(Evaluation.evaluateModel(gaussianProcesses, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

