/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import weka.classifiers.bayes.net.search.local.Scoreable;
import weka.core.Statistics;
import weka.core.Utils;
import weka.estimators.DiscreteEstimator;
import weka.estimators.Estimator;

public class DiscreteEstimatorBayes
implements Estimator,
Scoreable {
    protected double[] m_Counts;
    protected double m_SumOfCounts;
    protected int m_nSymbols = 0;
    protected double m_fPrior = 0.0;

    public DiscreteEstimatorBayes(int n, double d) {
        this.m_fPrior = d;
        this.m_nSymbols = n;
        this.m_Counts = new double[this.m_nSymbols];
        for (int i = 0; i < this.m_nSymbols; ++i) {
            this.m_Counts[i] = this.m_fPrior;
        }
        this.m_SumOfCounts = this.m_fPrior * (double)this.m_nSymbols;
    }

    public void addValue(double d, double d2) {
        int n = (int)d;
        this.m_Counts[n] = this.m_Counts[n] + d2;
        this.m_SumOfCounts += d2;
    }

    public double getProbability(double d) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)d] / this.m_SumOfCounts;
    }

    public double getCount(double d) {
        if (this.m_SumOfCounts == 0.0) {
            return 0.0;
        }
        return this.m_Counts[(int)d];
    }

    public int getNumSymbols() {
        return this.m_Counts == null ? 0 : this.m_Counts.length;
    }

    public double logScore(int n) {
        double d = 0.0;
        switch (n) {
            case 0: {
                for (int i = 0; i < this.m_nSymbols; ++i) {
                    d += Statistics.lnGamma(this.m_Counts[i]);
                }
                d -= Statistics.lnGamma(this.m_SumOfCounts);
                if (this.m_fPrior == 0.0) break;
                d -= (double)this.m_nSymbols * Statistics.lnGamma(this.m_fPrior);
                d += Statistics.lnGamma((double)this.m_nSymbols * this.m_fPrior);
                break;
            }
            case 1: {
                for (int i = 0; i < this.m_nSymbols; ++i) {
                    d += Statistics.lnGamma(this.m_Counts[i]);
                }
                d -= Statistics.lnGamma(this.m_SumOfCounts);
                d -= (double)this.m_nSymbols * Statistics.lnGamma(1.0);
                d += Statistics.lnGamma((double)this.m_nSymbols * 1.0);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                for (int i = 0; i < this.m_nSymbols; ++i) {
                    double d2 = this.getProbability(i);
                    d += this.m_Counts[i] * Math.log(d2);
                }
                break;
            }
        }
        return d;
    }

    public String toString() {
        String string = "Discrete Estimator. Counts = ";
        if (this.m_SumOfCounts > 1.0) {
            for (int i = 0; i < this.m_Counts.length; ++i) {
                string = string + " " + Utils.doubleToString(this.m_Counts[i], 2);
            }
            string = string + "  (Total = " + Utils.doubleToString(this.m_SumOfCounts, 2) + ")\n";
        } else {
            for (int i = 0; i < this.m_Counts.length; ++i) {
                string = string + " " + this.m_Counts[i];
            }
            string = string + "  (Total = " + this.m_SumOfCounts + ")\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            if (stringArray.length == 0) {
                System.out.println("Please specify a set of instances.");
                return;
            }
            int n2 = n = Integer.parseInt(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                n = Integer.parseInt(stringArray[i]);
                if (n <= n2) continue;
                n2 = n;
            }
            DiscreteEstimator discreteEstimator = new DiscreteEstimator(n2 + 1, true);
            for (int i = 0; i < stringArray.length; ++i) {
                n = Integer.parseInt(stringArray[i]);
                System.out.println(discreteEstimator);
                System.out.println("Prediction for " + n + " = " + discreteEstimator.getProbability(n));
                discreteEstimator.addValue(n, 1.0);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }
}

