/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes;

import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class HNB
extends Classifier
implements TechnicalInformationHandler {
    static final long serialVersionUID = -4503874444306113214L;
    private double[] m_ClassCounts;
    private double[][][] m_ClassAttAttCounts;
    private int[] m_NumAttValues;
    private int m_TotalAttValues;
    private int m_NumClasses;
    private int m_NumAttributes;
    private int m_NumInstances;
    private int m_ClassIndex;
    private int[] m_StartAttIndex;
    private double[][] m_condiMutualInfo;

    public String globalInfo() {
        return "Contructs Hidden Naive Bayes classification model with high classification accuracy and AUC.\n\nFor more information refer to:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "H. Zhang and L. Jiang and J. Su");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Hidden Naive Bayes");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Twentieth National Conference on Artificial Intelligence");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "919-924");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "AAAI Press");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        int n2;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_NumClasses = instances.numClasses();
        this.m_ClassIndex = instances.classIndex();
        this.m_NumAttributes = instances.numAttributes();
        this.m_NumInstances = instances.numInstances();
        this.m_TotalAttValues = 0;
        this.m_StartAttIndex = new int[this.m_NumAttributes];
        this.m_NumAttValues = new int[this.m_NumAttributes];
        for (n2 = 0; n2 < this.m_NumAttributes; ++n2) {
            if (n2 != this.m_ClassIndex) {
                this.m_StartAttIndex[n2] = this.m_TotalAttValues;
                this.m_NumAttValues[n2] = instances.attribute(n2).numValues();
                this.m_TotalAttValues += this.m_NumAttValues[n2];
                continue;
            }
            this.m_StartAttIndex[n2] = -1;
            this.m_NumAttValues[n2] = this.m_NumClasses;
        }
        this.m_ClassCounts = new double[this.m_NumClasses];
        this.m_ClassAttAttCounts = new double[this.m_NumClasses][this.m_TotalAttValues][this.m_TotalAttValues];
        for (n2 = 0; n2 < this.m_NumInstances; ++n2) {
            int n3;
            int n4 = n = (int)instances.instance(n2).classValue();
            this.m_ClassCounts[n4] = this.m_ClassCounts[n4] + 1.0;
            int[] nArray = new int[this.m_NumAttributes];
            for (n3 = 0; n3 < this.m_NumAttributes; ++n3) {
                nArray[n3] = n3 == this.m_ClassIndex ? -1 : this.m_StartAttIndex[n3] + (int)instances.instance(n2).value(n3);
            }
            for (n3 = 0; n3 < this.m_NumAttributes; ++n3) {
                if (nArray[n3] == -1) continue;
                for (int i = 0; i < this.m_NumAttributes; ++i) {
                    if (nArray[i] == -1) continue;
                    double[] dArray = this.m_ClassAttAttCounts[n][nArray[n3]];
                    int n5 = nArray[i];
                    dArray[n5] = dArray[n5] + 1.0;
                }
            }
        }
        this.m_condiMutualInfo = new double[this.m_NumAttributes][this.m_NumAttributes];
        for (n2 = 0; n2 < this.m_NumAttributes; ++n2) {
            if (n2 == this.m_ClassIndex) continue;
            for (n = 0; n < this.m_NumAttributes; ++n) {
                if (n == this.m_ClassIndex || n2 == n) continue;
                this.m_condiMutualInfo[n2][n] = this.conditionalMutualInfo(n2, n);
            }
        }
    }

    private double conditionalMutualInfo(int n, int n2) throws Exception {
        int n3;
        int n4;
        int n5;
        double d = 0.0;
        int n6 = this.m_StartAttIndex[n];
        int n7 = this.m_StartAttIndex[n2];
        double[] dArray = new double[this.m_NumClasses];
        double[][] dArray2 = new double[this.m_NumClasses][this.m_NumAttValues[n]];
        double[][] dArray3 = new double[this.m_NumClasses][this.m_NumAttValues[n2]];
        double[][][] dArray4 = new double[this.m_NumClasses][this.m_NumAttValues[n2]][this.m_NumAttValues[n]];
        for (n5 = 0; n5 < this.m_NumClasses; ++n5) {
            dArray[n5] = this.m_ClassCounts[n5] / (double)this.m_NumInstances;
        }
        for (n5 = 0; n5 < this.m_NumClasses; ++n5) {
            for (n4 = 0; n4 < this.m_NumAttValues[n]; ++n4) {
                dArray2[n5][n4] = this.m_ClassAttAttCounts[n5][n6 + n4][n6 + n4] / (double)this.m_NumInstances;
            }
        }
        for (n5 = 0; n5 < this.m_NumClasses; ++n5) {
            for (n4 = 0; n4 < this.m_NumAttValues[n2]; ++n4) {
                dArray3[n5][n4] = this.m_ClassAttAttCounts[n5][n7 + n4][n7 + n4] / (double)this.m_NumInstances;
            }
        }
        for (n5 = 0; n5 < this.m_NumClasses; ++n5) {
            for (n4 = 0; n4 < this.m_NumAttValues[n2]; ++n4) {
                for (n3 = 0; n3 < this.m_NumAttValues[n]; ++n3) {
                    dArray4[n5][n4][n3] = this.m_ClassAttAttCounts[n5][n7 + n4][n6 + n3] / (double)this.m_NumInstances;
                }
            }
        }
        for (n5 = 0; n5 < this.m_NumClasses; ++n5) {
            for (n4 = 0; n4 < this.m_NumAttValues[n2]; ++n4) {
                for (n3 = 0; n3 < this.m_NumAttValues[n]; ++n3) {
                    d += dArray4[n5][n4][n3] * this.log2(dArray4[n5][n4][n3] * dArray[n5], dArray3[n5][n4] * dArray2[n5][n3]);
                }
            }
        }
        return d;
    }

    private double log2(double d, double d2) {
        if (d < 1.0E-6 || d2 < 1.0E-6) {
            return 0.0;
        }
        return Math.log(d / d2) / Math.log(2.0);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = new double[this.m_NumClasses];
        int[] nArray = new int[this.m_NumAttributes];
        for (n = 0; n < this.m_NumAttributes; ++n) {
            nArray[n] = n == this.m_ClassIndex ? -1 : this.m_StartAttIndex[n] + (int)instance.value(n);
        }
        for (n = 0; n < this.m_NumClasses; ++n) {
            dArray[n] = (this.m_ClassCounts[n] + 1.0 / (double)this.m_NumClasses) / ((double)this.m_NumInstances + 1.0);
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (nArray[i] == -1) continue;
                int n2 = nArray[i];
                nArray[i] = -1;
                double d = 0.0;
                double d2 = 0.0;
                for (int j = 0; j < this.m_NumAttributes; ++j) {
                    if (nArray[j] == -1) continue;
                    d2 += this.m_condiMutualInfo[i][j];
                    d += this.m_condiMutualInfo[i][j] * (this.m_ClassAttAttCounts[n][nArray[j]][n2] + 1.0 / (double)this.m_NumAttValues[i]) / (this.m_ClassAttAttCounts[n][nArray[j]][nArray[j]] + 1.0);
                }
                if (d2 > 0.0) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] * (d /= d2);
                } else {
                    d = (this.m_ClassAttAttCounts[n][n2][n2] + 1.0 / (double)this.m_NumAttValues[i]) / (this.m_ClassCounts[n] + 1.0);
                    int n4 = n;
                    dArray[n4] = dArray[n4] * d;
                }
                nArray[i] = n2;
            }
        }
        Utils.normalize(dArray);
        return dArray;
    }

    public String toString() {
        return "HNB (Hidden Naive Bayes)";
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new HNB(), stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

