/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Enumeration;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.GainRatioSplitCrit;
import weka.classifiers.trees.j48.InfoGainSplitCrit;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class C45Split
extends ClassifierSplitModel {
    private int m_complexityIndex;
    private int m_attIndex;
    private int m_minNoObj;
    private double m_splitPoint;
    private double m_infoGain;
    private double m_gainRatio;
    private double m_sumOfWeights;
    private int m_index;
    private static InfoGainSplitCrit infoGainCrit = new InfoGainSplitCrit();
    private static GainRatioSplitCrit gainRatioCrit = new GainRatioSplitCrit();

    public C45Split(int n, int n2, double d) {
        this.m_attIndex = n;
        this.m_minNoObj = n2;
        this.m_sumOfWeights = d;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.m_numSubsets = 0;
        this.m_splitPoint = Double.MAX_VALUE;
        this.m_infoGain = 0.0;
        this.m_gainRatio = 0.0;
        if (instances.attribute(this.m_attIndex).isNominal()) {
            this.m_index = this.m_complexityIndex = instances.attribute(this.m_attIndex).numValues();
            this.handleEnumeratedAttribute(instances);
        } else {
            this.m_complexityIndex = 2;
            this.m_index = 0;
            instances.sort(instances.attribute(this.m_attIndex));
            this.handleNumericAttribute(instances);
        }
    }

    public final int attIndex() {
        return this.m_attIndex;
    }

    public final double classProb(int n, Instance instance, int n2) throws Exception {
        if (n2 <= -1) {
            double[] dArray = this.weights(instance);
            if (dArray == null) {
                return this.m_distribution.prob(n);
            }
            double d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d += dArray[i] * this.m_distribution.prob(n, i);
            }
            return d;
        }
        if (Utils.gr(this.m_distribution.perBag(n2), 0.0)) {
            return this.m_distribution.prob(n, n2);
        }
        return this.m_distribution.prob(n);
    }

    public final double codingCost() {
        return Utils.log2(this.m_index);
    }

    public final double gainRatio() {
        return this.m_gainRatio;
    }

    private void handleEnumeratedAttribute(Instances instances) throws Exception {
        this.m_distribution = new Distribution(this.m_complexityIndex, instances.numClasses());
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            Instance instance = (Instance)enumeration.nextElement();
            if (instance.isMissing(this.m_attIndex)) continue;
            this.m_distribution.add((int)instance.value(this.m_attIndex), instance);
        }
        if (this.m_distribution.check(this.m_minNoObj)) {
            this.m_numSubsets = this.m_complexityIndex;
            this.m_infoGain = infoGainCrit.splitCritValue(this.m_distribution, this.m_sumOfWeights);
            this.m_gainRatio = gainRatioCrit.splitCritValue(this.m_distribution, this.m_sumOfWeights, this.m_infoGain);
        }
    }

    private void handleNumericAttribute(Instances instances) throws Exception {
        Instance instance;
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        this.m_distribution = new Distribution(2, instances.numClasses());
        Enumeration enumeration = instances.enumerateInstances();
        int n4 = 0;
        while (enumeration.hasMoreElements() && !(instance = (Instance)enumeration.nextElement()).isMissing(this.m_attIndex)) {
            this.m_distribution.add(1, instance);
            ++n4;
        }
        int n5 = n4;
        double d = 0.1 * this.m_distribution.total() / (double)instances.numClasses();
        if (Utils.smOrEq(d, this.m_minNoObj)) {
            d = this.m_minNoObj;
        } else if (Utils.gr(d, 25.0)) {
            d = 25.0;
        }
        if (Utils.sm(n5, 2.0 * d)) {
            return;
        }
        double d2 = infoGainCrit.oldEnt(this.m_distribution);
        while (n < n5) {
            if (instances.instance(n - 1).value(this.m_attIndex) + 1.0E-5 < instances.instance(n).value(this.m_attIndex)) {
                this.m_distribution.shiftRange(1, 0, instances, n2, n);
                if (Utils.grOrEq(this.m_distribution.perBag(0), d) && Utils.grOrEq(this.m_distribution.perBag(1), d)) {
                    double d3 = infoGainCrit.splitCritValue(this.m_distribution, this.m_sumOfWeights, d2);
                    if (Utils.gr(d3, this.m_infoGain)) {
                        this.m_infoGain = d3;
                        n3 = n - 1;
                    }
                    ++this.m_index;
                }
                n2 = n;
            }
            ++n;
        }
        if (this.m_index == 0) {
            return;
        }
        this.m_infoGain -= Utils.log2(this.m_index) / this.m_sumOfWeights;
        if (Utils.smOrEq(this.m_infoGain, 0.0)) {
            return;
        }
        this.m_numSubsets = 2;
        this.m_splitPoint = (instances.instance(n3 + 1).value(this.m_attIndex) + instances.instance(n3).value(this.m_attIndex)) / 2.0;
        if (this.m_splitPoint == instances.instance(n3 + 1).value(this.m_attIndex)) {
            this.m_splitPoint = instances.instance(n3).value(this.m_attIndex);
        }
        this.m_distribution = new Distribution(2, instances.numClasses());
        this.m_distribution.addRange(0, instances, 0, n3 + 1);
        this.m_distribution.addRange(1, instances, n3 + 1, n5);
        this.m_gainRatio = gainRatioCrit.splitCritValue(this.m_distribution, this.m_sumOfWeights, this.m_infoGain);
    }

    public final double infoGain() {
        return this.m_infoGain;
    }

    public final String leftSide(Instances instances) {
        return instances.attribute(this.m_attIndex).name();
    }

    public final String rightSide(int n, Instances instances) {
        StringBuffer stringBuffer = new StringBuffer();
        if (instances.attribute(this.m_attIndex).isNominal()) {
            stringBuffer.append(" = " + instances.attribute(this.m_attIndex).value(n));
        } else if (n == 0) {
            stringBuffer.append(" <= " + Utils.doubleToString(this.m_splitPoint, 6));
        } else {
            stringBuffer.append(" > " + Utils.doubleToString(this.m_splitPoint, 6));
        }
        return stringBuffer.toString();
    }

    public final String sourceExpression(int n, Instances instances) {
        StringBuffer stringBuffer = null;
        if (n < 0) {
            return "i[" + this.m_attIndex + "] == null";
        }
        if (instances.attribute(this.m_attIndex).isNominal()) {
            stringBuffer = new StringBuffer("i[");
            stringBuffer.append(this.m_attIndex).append("]");
            stringBuffer.append(".equals(\"").append(instances.attribute(this.m_attIndex).value(n)).append("\")");
        } else {
            stringBuffer = new StringBuffer("((Double) i[");
            stringBuffer.append(this.m_attIndex).append("])");
            if (n == 0) {
                stringBuffer.append(".doubleValue() <= ").append(this.m_splitPoint);
            } else {
                stringBuffer.append(".doubleValue() > ").append(this.m_splitPoint);
            }
        }
        return stringBuffer.toString();
    }

    public final void setSplitPoint(Instances instances) {
        double d = -1.7976931348623157E308;
        if (instances.attribute(this.m_attIndex).isNumeric() && this.m_numSubsets > 1) {
            Enumeration enumeration = instances.enumerateInstances();
            while (enumeration.hasMoreElements()) {
                double d2;
                Instance instance = (Instance)enumeration.nextElement();
                if (instance.isMissing(this.m_attIndex) || !Utils.gr(d2 = instance.value(this.m_attIndex), d) || !Utils.smOrEq(d2, this.m_splitPoint)) continue;
                d = d2;
            }
            this.m_splitPoint = d;
        }
    }

    public final double[][] minsAndMaxs(Instances instances, double[][] dArray, int n) {
        double[][] dArray2 = new double[instances.numAttributes()][2];
        for (int i = 0; i < instances.numAttributes(); ++i) {
            dArray2[i][0] = dArray[i][0];
            dArray2[i][1] = dArray[i][1];
            if (i != this.m_attIndex) continue;
            if (instances.attribute(this.m_attIndex).isNominal()) {
                dArray2[this.m_attIndex][1] = 1.0;
                continue;
            }
            dArray2[this.m_attIndex][1 - n] = this.m_splitPoint;
        }
        return dArray2;
    }

    public void resetDistribution(Instances instances) throws Exception {
        Instances instances2 = new Instances(instances, instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (this.whichSubset(instances.instance(i)) <= -1) continue;
            instances2.add(instances.instance(i));
        }
        Distribution distribution = new Distribution(instances2, this);
        distribution.addInstWithUnknown(instances, this.m_attIndex);
        this.m_distribution = distribution;
    }

    public final double[] weights(Instance instance) {
        if (instance.isMissing(this.m_attIndex)) {
            double[] dArray = new double[this.m_numSubsets];
            for (int i = 0; i < this.m_numSubsets; ++i) {
                dArray[i] = this.m_distribution.perBag(i) / this.m_distribution.total();
            }
            return dArray;
        }
        return null;
    }

    public final int whichSubset(Instance instance) throws Exception {
        if (instance.isMissing(this.m_attIndex)) {
            return -1;
        }
        if (instance.attribute(this.m_attIndex).isNominal()) {
            return (int)instance.value(this.m_attIndex);
        }
        if (Utils.smOrEq(instance.value(this.m_attIndex), this.m_splitPoint)) {
            return 0;
        }
        return 1;
    }
}

