/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weka.core.Utils;
import weka.core.Version;
import weka.core.xml.PropertyHandler;
import weka.core.xml.XMLDocument;
import weka.core.xml.XMLSerializationMethodHandler;

public class XMLSerialization {
    protected static boolean DEBUG = false;
    protected Element m_CurrentNode = null;
    public static final String TAG_OBJECT = "object";
    public static final String ATT_VERSION = "version";
    public static final String ATT_NAME = "name";
    public static final String ATT_CLASS = "class";
    public static final String ATT_PRIMITIVE = "primitive";
    public static final String ATT_ARRAY = "array";
    public static final String ATT_NULL = "null";
    public static final String VAL_YES = "yes";
    public static final String VAL_NO = "no";
    public static final String VAL_ROOT = "__root__";
    public static final String ROOT_NODE = "object";
    public static final String ATT_PRIMITIVE_DEFAULT = "no";
    public static final String ATT_ARRAY_DEFAULT = "no";
    public static final String ATT_NULL_DEFAULT = "no";
    public static final String DOCTYPE = "<!DOCTYPE object\n[\n   <!ELEMENT object (#PCDATA | object)*>\n   <!ATTLIST object name      CDATA #REQUIRED>\n   <!ATTLIST object class     CDATA #REQUIRED>\n   <!ATTLIST object primitive CDATA \"no\">\n   <!ATTLIST object array     CDATA \"no\">   <!-- the dimensions of the array; no=0, yes=1 -->\n   <!ATTLIST object null      CDATA \"no\">\n   <!ATTLIST object version   CDATA \"" + Version.VERSION + "\">\n" + "]\n" + ">";
    protected XMLDocument m_Document = null;
    protected PropertyHandler m_Properties = null;
    protected XMLSerializationMethodHandler m_CustomMethods = null;
    protected Hashtable m_ClassnameOverride = null;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public XMLSerialization() throws Exception {
        this.clear();
    }

    protected void trace(Throwable throwable, String string) {
        if (DEBUG && throwable.getStackTrace().length > 0) {
            System.out.println("trace: " + throwable.getStackTrace()[0] + ": " + string);
        }
    }

    public void clear() throws Exception {
        this.m_Document = new XMLDocument();
        this.m_Document.setValidating(true);
        this.m_Document.newDocument(DOCTYPE, "object");
        this.m_Properties = new PropertyHandler();
        this.m_CustomMethods = new XMLSerializationMethodHandler(this);
        this.m_ClassnameOverride = new Hashtable();
        this.m_ClassnameOverride.put(class$java$io$File == null ? (class$java$io$File = XMLSerialization.class$("java.io.File")) : class$java$io$File, (class$java$io$File == null ? (class$java$io$File = XMLSerialization.class$("java.io.File")) : class$java$io$File).getName());
        this.setVersion(Version.VERSION);
        this.m_CurrentNode = null;
    }

    private void setVersion(String string) {
        Document document = this.m_Document.getDocument();
        document.getDocumentElement().setAttribute(ATT_VERSION, string);
    }

    public String getVersion() {
        Document document = this.m_Document.getDocument();
        String string = document.getDocumentElement().getAttribute(ATT_VERSION);
        return string;
    }

    private void checkVersion() {
        Version version = new Version();
        String string = this.getVersion();
        if (string.equals("")) {
            System.out.println("WARNING: has no version!");
        } else if (version.isOlder(string)) {
            System.out.println("WARNING: loading a newer version (" + string + " > " + Version.VERSION + ")!");
        } else if (version.isNewer(string)) {
            System.out.println("NOTE: loading an older version (" + string + " < " + Version.VERSION + ")!");
        }
    }

    protected Hashtable getDescriptors(Object object) throws Exception {
        Hashtable<String, PropertyDescriptor> hashtable = new Hashtable<String, PropertyDescriptor>();
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (propertyDescriptorArray[i].getReadMethod() == null || propertyDescriptorArray[i].getWriteMethod() == null || this.m_Properties.isIgnored(propertyDescriptorArray[i].getDisplayName()) || this.m_Properties.isIgnored(object, propertyDescriptorArray[i].getDisplayName()) || !this.m_Properties.isAllowed(object, propertyDescriptorArray[i].getDisplayName())) continue;
            hashtable.put(propertyDescriptorArray[i].getDisplayName(), propertyDescriptorArray[i]);
        }
        return hashtable;
    }

    protected String getPath(Element element) {
        String string = element.getAttribute(ATT_NAME);
        while (element.getParentNode() != element.getOwnerDocument()) {
            element = (Element)element.getParentNode();
            string = element.getAttribute(ATT_NAME) + "." + string;
        }
        return string;
    }

    protected String booleanToString(boolean bl) {
        if (bl) {
            return VAL_YES;
        }
        return "no";
    }

    protected boolean stringToBoolean(String string) {
        if (string.equals("")) {
            return false;
        }
        if (string.equals(VAL_YES)) {
            return true;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.replaceAll("[0-9]*", "").equals("")) {
            return Integer.parseInt(string) != 0;
        }
        return false;
    }

    protected Element addElement(Element element, String string, String string2, boolean bl) {
        return this.addElement(element, string, string2, bl, 0);
    }

    protected Element addElement(Element element, String string, String string2, boolean bl, int n) {
        return this.addElement(element, string, string2, bl, n, false);
    }

    protected Element addElement(Element element, String string, String string2, boolean bl, int n, boolean bl2) {
        Element element2 = element == null ? this.m_Document.getDocument().getDocumentElement() : (Element)element.appendChild(this.m_Document.getDocument().createElement("object"));
        element2.setAttribute(ATT_NAME, string);
        element2.setAttribute(ATT_CLASS, string2);
        if (!this.booleanToString(bl).equals("no")) {
            element2.setAttribute(ATT_PRIMITIVE, this.booleanToString(bl));
        }
        if (n > 1) {
            element2.setAttribute(ATT_ARRAY, Integer.toString(n));
        } else if (!this.booleanToString(n == 1).equals("no")) {
            element2.setAttribute(ATT_ARRAY, this.booleanToString(n == 1));
        }
        if (!this.booleanToString(bl2).equals("no")) {
            element2.setAttribute(ATT_NULL, this.booleanToString(bl2));
        }
        return element2;
    }

    protected String overrideClassname(Object object) {
        String string = object.getClass().getName();
        Enumeration enumeration = this.m_ClassnameOverride.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            if (!clazz.isInstance(object)) continue;
            string = (String)this.m_ClassnameOverride.get(clazz);
            break;
        }
        return string;
    }

    protected String overrideClassname(String string) {
        String string2 = string;
        Enumeration enumeration = this.m_ClassnameOverride.keys();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            if (!clazz.getName().equals(string)) continue;
            string2 = (String)this.m_ClassnameOverride.get(clazz);
            break;
        }
        return string2;
    }

    protected PropertyDescriptor determineDescriptor(String string, String string2) {
        PropertyDescriptor propertyDescriptor = null;
        try {
            propertyDescriptor = new PropertyDescriptor(string2, Class.forName(string));
        }
        catch (Exception exception) {
            propertyDescriptor = null;
        }
        return propertyDescriptor;
    }

    protected Element writeBooleanToXML(Element element, boolean bl, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Element element2 = this.addElement(element, string, Boolean.TYPE.getName(), true);
        element2.appendChild(element2.getOwnerDocument().createTextNode(new Boolean(bl).toString()));
        return element2;
    }

    protected Element writeByteToXML(Element element, byte by, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Element element2 = this.addElement(element, string, Byte.TYPE.getName(), true);
        element2.appendChild(element2.getOwnerDocument().createTextNode(new Byte(by).toString()));
        return element2;
    }

    protected Element writeCharToXML(Element element, char c, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Element element2 = this.addElement(element, string, Character.TYPE.getName(), true);
        element2.appendChild(element2.getOwnerDocument().createTextNode(new Character(c).toString()));
        return element2;
    }

    protected Element writeDoubleToXML(Element element, double d, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Element element2 = this.addElement(element, string, Double.TYPE.getName(), true);
        element2.appendChild(element2.getOwnerDocument().createTextNode(new Double(d).toString()));
        return element2;
    }

    protected Element writeFloatToXML(Element element, float f, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Element element2 = this.addElement(element, string, Float.TYPE.getName(), true);
        element2.appendChild(element2.getOwnerDocument().createTextNode(new Float(f).toString()));
        return element2;
    }

    protected Element writeIntToXML(Element element, int n, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Element element2 = this.addElement(element, string, Integer.TYPE.getName(), true);
        element2.appendChild(element2.getOwnerDocument().createTextNode(new Integer(n).toString()));
        return element2;
    }

    protected Element writeLongToXML(Element element, long l, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Element element2 = this.addElement(element, string, Long.TYPE.getName(), true);
        element2.appendChild(element2.getOwnerDocument().createTextNode(new Long(l).toString()));
        return element2;
    }

    protected Element writeShortToXML(Element element, short s, String string) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), string);
        }
        this.m_CurrentNode = element;
        Element element2 = this.addElement(element, string, Short.TYPE.getName(), true);
        element2.appendChild(element2.getOwnerDocument().createTextNode(new Short(s).toString()));
        return element2;
    }

    protected boolean isPrimitiveArray(Class clazz) {
        if (clazz.getComponentType().isArray()) {
            return this.isPrimitiveArray(clazz.getComponentType());
        }
        return clazz.getComponentType().isPrimitive();
    }

    public Element writeToXML(Element element, Object object, String string) throws Exception {
        Element element2;
        block12: {
            Hashtable hashtable;
            PropertyDescriptor propertyDescriptor;
            block14: {
                block13: {
                    boolean bl;
                    block11: {
                        String string2;
                        element2 = null;
                        if (DEBUG) {
                            this.trace(new Throwable(), string);
                        }
                        if (object == null) {
                            element2 = this.addElement(element, string, "" + null, false, 0, true);
                            return element2;
                        }
                        Object object2 = null;
                        int n = 0;
                        if (object.getClass().isArray()) {
                            n = Utils.getArrayDimensions(object);
                        }
                        if (n > 0) {
                            string2 = Utils.getArrayClass(object.getClass()).getName();
                            bl = this.isPrimitiveArray(object.getClass());
                        } else {
                            propertyDescriptor = null;
                            if (element != null) {
                                propertyDescriptor = this.determineDescriptor(element.getAttribute(ATT_CLASS), string);
                            }
                            if (bl = propertyDescriptor != null ? propertyDescriptor.getPropertyType().isPrimitive() : object.getClass().isPrimitive()) {
                                string2 = propertyDescriptor.getPropertyType().getName();
                            } else {
                                object2 = object;
                                string2 = object.getClass().getName();
                            }
                        }
                        if (element != null && !element.getAttribute(ATT_ARRAY).equals("") && !element.getAttribute(ATT_ARRAY).equals("no") && this.stringToBoolean(element.getAttribute(ATT_PRIMITIVE))) {
                            bl = true;
                            string2 = element.getAttribute(ATT_CLASS);
                            object2 = null;
                        }
                        string2 = object2 != null ? this.overrideClassname(object2) : this.overrideClassname(string2);
                        element2 = this.addElement(element, string, string2, bl, n);
                        if (n <= 0) break block11;
                        for (int i = 0; i < Array.getLength(object); ++i) {
                            this.invokeWriteToXML(element2, Array.get(object, i), Integer.toString(i));
                        }
                        break block12;
                    }
                    if (!bl) break block13;
                    element2.appendChild(element2.getOwnerDocument().createTextNode(object.toString()));
                    break block12;
                }
                hashtable = this.getDescriptors(object);
                if (hashtable.size() != 0) break block14;
                if (object.toString().equals("")) break block12;
                element2.appendChild(element2.getOwnerDocument().createTextNode(object.toString().replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;")));
                break block12;
            }
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement().toString();
                if (this.m_Properties.isIgnored(string3) || this.m_Properties.isIgnored(this.getPath(element2) + "." + string3) || this.m_Properties.isIgnored(object, this.getPath(element2) + "." + string3) || !this.m_Properties.isAllowed(object, string3)) continue;
                propertyDescriptor = (PropertyDescriptor)hashtable.get(string3);
                Method method = propertyDescriptor.getReadMethod();
                Object object3 = method.invoke(object, (Object[])null);
                this.invokeWriteToXML(element2, object3, string3);
            }
        }
        return element2;
    }

    protected Element invokeWriteToXML(Element element, Object object, String string) throws Exception {
        Element element2 = null;
        Method method = null;
        boolean bl = false;
        this.m_CurrentNode = element;
        if (object == null) {
            bl = true;
        }
        try {
            if (!bl) {
                boolean bl2 = object.getClass().isArray();
                method = this.m_CustomMethods.write().contains(string) ? this.m_CustomMethods.write().get(object.getClass()) : (!bl2 && this.m_CustomMethods.write().contains(object.getClass()) ? this.m_CustomMethods.write().get(object.getClass()) : null);
                boolean bl3 = bl = method == null;
            }
            if (!bl) {
                Class[] classArray = new Class[]{class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLSerialization.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element, class$java$lang$Object == null ? (class$java$lang$Object = XMLSerialization.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = XMLSerialization.class$("java.lang.String")) : class$java$lang$String};
                Object[] objectArray = new Object[]{element, object, string};
                element2 = (Element)method.invoke((Object)this, objectArray);
            } else {
                element2 = this.writeToXML(element, object, string);
            }
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            if (this.m_CurrentNode != null) {
                System.out.println("Happened near: " + this.getPath(this.m_CurrentNode));
                this.m_CurrentNode = null;
            }
            System.out.println("PROBLEM (write): " + string);
            throw (Exception)exception.fillInStackTrace();
        }
        return element2;
    }

    protected Object writePreProcess(Object object) throws Exception {
        return object;
    }

    protected void writePostProcess(Object object) throws Exception {
    }

    public XMLDocument toXML(Object object) throws Exception {
        this.clear();
        this.invokeWriteToXML(null, this.writePreProcess(object), VAL_ROOT);
        this.writePostProcess(object);
        return this.m_Document;
    }

    protected PropertyDescriptor getDescriptorByName(Object object, String string) throws Exception {
        PropertyDescriptor propertyDescriptor = null;
        PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!propertyDescriptorArray[i].getDisplayName().equals(string)) continue;
            propertyDescriptor = propertyDescriptorArray[i];
            break;
        }
        return propertyDescriptor;
    }

    protected Class determineClass(String string) throws Exception {
        Class<Serializable> clazz = string.equals(Boolean.TYPE.getName()) ? Boolean.TYPE : (string.equals(Byte.TYPE.getName()) ? Byte.TYPE : (string.equals(Character.TYPE.getName()) ? Character.TYPE : (string.equals(Double.TYPE.getName()) ? Double.TYPE : (string.equals(Float.TYPE.getName()) ? Float.TYPE : (string.equals(Integer.TYPE.getName()) ? Integer.TYPE : (string.equals(Long.TYPE.getName()) ? Long.TYPE : (string.equals(Short.TYPE.getName()) ? Short.TYPE : Class.forName(string))))))));
        return clazz;
    }

    protected Object getPrimitive(Element element) throws Exception {
        Class clazz = this.determineClass(element.getAttribute(ATT_CLASS));
        Object object = Array.newInstance(clazz, 1);
        if (clazz == Boolean.TYPE) {
            Array.set(object, 0, new Boolean(XMLDocument.getContent(element)));
        } else if (clazz == Byte.TYPE) {
            Array.set(object, 0, new Byte(XMLDocument.getContent(element)));
        } else if (clazz == Character.TYPE) {
            Array.set(object, 0, new Character(XMLDocument.getContent(element).charAt(0)));
        } else if (clazz == Double.TYPE) {
            Array.set(object, 0, new Double(XMLDocument.getContent(element)));
        } else if (clazz == Float.TYPE) {
            Array.set(object, 0, new Float(XMLDocument.getContent(element)));
        } else if (clazz == Integer.TYPE) {
            Array.set(object, 0, new Integer(XMLDocument.getContent(element)));
        } else if (clazz == Long.TYPE) {
            Array.set(object, 0, new Long(XMLDocument.getContent(element)));
        } else if (clazz == Short.TYPE) {
            Array.set(object, 0, new Short(XMLDocument.getContent(element)));
        } else {
            throw new Exception("Cannot get primitive for class '" + clazz.getName() + "'!");
        }
        Object object2 = Array.get(object, 0);
        return object2;
    }

    public boolean readBooleanFromXML(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = element;
        return (Boolean)this.getPrimitive(element);
    }

    public byte readByteFromXML(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = element;
        return (Byte)this.getPrimitive(element);
    }

    public char readCharFromXML(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = element;
        return ((Character)this.getPrimitive(element)).charValue();
    }

    public double readDoubleFromXML(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = element;
        return (Double)this.getPrimitive(element);
    }

    public float readFloatFromXML(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = element;
        return ((Float)this.getPrimitive(element)).floatValue();
    }

    public int readIntFromXML(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = element;
        return (Integer)this.getPrimitive(element);
    }

    public long readLongFromXML(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = element;
        return (Long)this.getPrimitive(element);
    }

    public short readShortFromXML(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = element;
        return (Short)this.getPrimitive(element);
    }

    public Object readFromXML(Object object, String string, Element element) throws Exception {
        Object object2 = object;
        Hashtable hashtable = this.getDescriptors(object2);
        String string2 = element.getAttribute(ATT_NAME);
        if (this.m_Properties.isIgnored(this.getPath(element))) {
            return object2;
        }
        if (this.m_Properties.isIgnored(object2, this.getPath(element))) {
            return object2;
        }
        if (!this.m_Properties.isAllowed(object2, string2)) {
            return object2;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)hashtable.get(string2);
        if (propertyDescriptor == null) {
            if (!this.m_CustomMethods.read().contains(string2)) {
                System.out.println("WARNING: unknown property '" + string + "." + string2 + "'!");
            }
            return object2;
        }
        Method method = propertyDescriptor.getWriteMethod();
        Object[] objectArray = new Object[1];
        Object object3 = this.invokeReadFromXML(element);
        Class<?> clazz = method.getParameterTypes()[0];
        if (clazz.isArray()) {
            if (Array.getLength(object3) == 0) {
                return object2;
            }
            objectArray[0] = (Object[])object3;
        } else {
            objectArray[0] = object3;
        }
        method.invoke(object2, objectArray);
        return object2;
    }

    protected int[] getArrayDimensions(Element element) {
        int[] nArray;
        Vector vector = this.stringToBoolean(element.getAttribute(ATT_ARRAY)) ? XMLDocument.getChildTags(element) : null;
        if (vector != null) {
            int n;
            Vector<Integer> vector2 = new Vector<Integer>();
            if (vector.size() > 0) {
                int[] nArray2 = this.getArrayDimensions((Element)vector.get(0));
                if (nArray2 != null) {
                    for (n = nArray2.length - 1; n >= 0; --n) {
                        vector2.add(new Integer(nArray2[n]));
                    }
                }
                vector2.add(0, new Integer(vector.size()));
            } else {
                vector2.add(new Integer(0));
            }
            nArray = new int[vector2.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)vector2.get(vector2.size() - n - 1);
            }
        } else {
            nArray = null;
        }
        return nArray;
    }

    public Object readFromXML(Element element) throws Exception {
        if (DEBUG) {
            this.trace(new Throwable(), element.getAttribute(ATT_NAME));
        }
        this.m_CurrentNode = element;
        Object object = null;
        String string = element.getAttribute(ATT_NAME);
        String string2 = element.getAttribute(ATT_CLASS);
        boolean bl = this.stringToBoolean(element.getAttribute(ATT_PRIMITIVE));
        boolean bl2 = this.stringToBoolean(element.getAttribute(ATT_ARRAY));
        boolean bl3 = this.stringToBoolean(element.getAttribute(ATT_NULL));
        if (bl3) {
            return object;
        }
        Vector vector = XMLDocument.getChildTags(element);
        Class clazz = this.determineClass(string2);
        if (bl2) {
            object = Array.newInstance(clazz, this.getArrayDimensions(element));
            for (int i = 0; i < vector.size(); ++i) {
                Element element2 = (Element)vector.get(i);
                Array.set(object, Integer.parseInt(element2.getAttribute(ATT_NAME)), this.invokeReadFromXML(element2));
            }
        } else if (vector.size() == 0) {
            if (bl) {
                object = this.getPrimitive(element);
            } else {
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = XMLSerialization.class$("java.lang.String")) : class$java$lang$String};
                Object[] objectArray = new Object[]{XMLDocument.getContent(element)};
                try {
                    Constructor constructor = clazz.getConstructor(classArray);
                    object = constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    try {
                        object = clazz.newInstance();
                    }
                    catch (Exception exception2) {
                        object = null;
                        System.out.println("ERROR: Can't instantiate '" + string2 + "'!");
                    }
                }
            }
        } else {
            object = clazz.newInstance();
            Hashtable hashtable = this.getDescriptors(object);
            for (int i = 0; i < vector.size(); ++i) {
                object = this.readFromXML(object, string, (Element)vector.get(i));
            }
        }
        return object;
    }

    protected Object invokeReadFromXML(Element element) throws Exception {
        boolean bl = false;
        Method method = null;
        this.m_CurrentNode = element;
        try {
            if (this.stringToBoolean(element.getAttribute(ATT_NULL))) {
                bl = true;
            }
            if (!bl) {
                boolean bl2 = this.stringToBoolean(element.getAttribute(ATT_ARRAY));
                method = this.m_CustomMethods.read().contains(element.getAttribute(ATT_NAME)) ? this.m_CustomMethods.read().get(element.getAttribute(ATT_NAME)) : (!bl2 && this.m_CustomMethods.read().contains(this.determineClass(element.getAttribute(ATT_CLASS))) ? this.m_CustomMethods.read().get(this.determineClass(element.getAttribute(ATT_CLASS))) : null);
                boolean bl3 = bl = method == null;
            }
            if (!bl) {
                Class[] classArray = new Class[]{class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = XMLSerialization.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element};
                Object[] objectArray = new Object[]{element};
                return method.invoke((Object)this, objectArray);
            }
            return this.readFromXML(element);
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            if (this.m_CurrentNode != null) {
                System.out.println("Happened near: " + this.getPath(this.m_CurrentNode));
                this.m_CurrentNode = null;
            }
            System.out.println("PROBLEM (read): " + element.getAttribute(ATT_NAME));
            throw (Exception)exception.fillInStackTrace();
        }
    }

    protected Document readPreProcess(Document document) throws Exception {
        return document;
    }

    protected Object readPostProcess(Object object) throws Exception {
        return object;
    }

    public Object fromXML(Document document) throws Exception {
        if (!document.getDocumentElement().getNodeName().equals("object")) {
            throw new Exception("Expected 'object' as root element, but found '" + document.getDocumentElement().getNodeName() + "'!");
        }
        this.m_Document.setDocument(this.readPreProcess(document));
        this.checkVersion();
        return this.readPostProcess(this.invokeReadFromXML(this.m_Document.getDocument().getDocumentElement()));
    }

    public Object read(String string) throws Exception {
        return this.fromXML(this.m_Document.read(string));
    }

    public Object read(File file) throws Exception {
        return this.fromXML(this.m_Document.read(file));
    }

    public Object read(InputStream inputStream) throws Exception {
        return this.fromXML(this.m_Document.read(inputStream));
    }

    public Object read(Reader reader) throws Exception {
        return this.fromXML(this.m_Document.read(reader));
    }

    public void write(String string, Object object) throws Exception {
        this.toXML(object).write(string);
    }

    public void write(File file, Object object) throws Exception {
        this.toXML(object).write(file);
    }

    public void write(OutputStream outputStream, Object object) throws Exception {
        this.toXML(object).write(outputStream);
    }

    public void write(Writer writer, Object object) throws Exception {
        this.toXML(object).write(writer);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            if (stringArray[0].toLowerCase().endsWith(".xml")) {
                System.out.println(new XMLSerialization().read(stringArray[0]).toString());
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
                ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(fileInputStream));
                Object object = objectInputStream.readObject();
                objectInputStream.close();
                new XMLSerialization().write(new BufferedOutputStream(new FileOutputStream(stringArray[0] + ".xml")), object);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[0] + ".exp");
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

