% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue.NormalizedASKAT.R
\name{pvalue.NormalizedASKAT}
\alias{pvalue.NormalizedASKAT}
\title{Compute p-value and score for the normalized ASKAT method}
\usage{
pvalue.NormalizedASKAT(RH0, y, X, Phi, W, G)
}
\arguments{
\item{RH0}{a vector of length 2 which the results (output) of the
\code{\link{Estim.H0.ASKAT}} function (i.e. variance components
estimates under the null model)}

\item{y}{vector of phenotype data (one entry per individual), of
length \eqn{n}.}

\item{X}{matrix of covariates including intercept (dimension:
\eqn{n \times p}, with \eqn{p} the number of covariates)}

\item{Phi}{Relationship matrix (i.e. twice the kinship matrix); an
\eqn{n \times n} square symmetric positive-definite matrix.}

\item{G}{matrix of genotypes}
}
\value{
A list with score and p-value for the Normalized ASKAT
    test on the given data. The list contains the elements
    \code{score} and \code{p.value}
}
\description{
Compute p-value and score for the normalized ASKAT method
}
\author{
Karim Oualkacha
}
\keyword{internal}

