% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{uniformDensity}
\alias{uniformDensity}
\title{The probability density function of the uniform distribution}
\usage{
uniformDensity(xlims)
}
\arguments{
\item{xlims}{a tuple representing the interval of nonzero probability of the distribution.}
}
\value{
Returns a callable function with a single parameter that rerturns the probability of the uniform distribution in each point.
}
\description{
Returns the density function of the uniform distribution in the interval (xlims[[1]], xlims[[2]]).
The returned function is a single parameter function that returns the probability of the uniform distribution in that point.
It is just a convinient wrapper of dunif from the package 'stat' with some parameter checks.
}
\examples{
dist <- uniformDensity(c(-2,2))
dist(-3)
dist(0)
dist(1)
}
\seealso{
Other probability density distributions: 
\code{\link{normalDensity}()}
}
\concept{probability density distributions}
