% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RVCompare.R
\name{CpFromDensities}
\alias{CpFromDensities}
\title{The probability that X_A < X_B given the density functions.}
\usage{
CpFromDensities(densityX_A, densityX_B, xlims)
}
\arguments{
\item{densityX_A}{The probability density function of the random variable X_A.}

\item{densityX_B}{The probability density function of the random variable X_B.}

\item{xlims}{an interval that represents the domain of definition the density functions.}
}
\value{
Returns the probability that X_A < X_B.
}
\description{
Returns a real number in the interval [0,1] that represents the probability that a sample observed from X_A is lower than a sample observed from X_B.
}
\examples{
### Example 1 ###
# If two symmetric distributions are centered in the same point (x = 0 in
# this case), then their Cp will be 0.5.
densityX_A <- normalDensity(0,1)
densityX_B <- uniformDensity(c(-2,2))
Cp = CpFromDensities(densityX_A, densityX_B, c(-5,5))
plot(densityX_A, from=-5, to=5, type="l",  col="red", xlab="x", ylab="probability density")
curve(densityX_B, add=TRUE, col="blue", type="l", lty=2)
mtext(paste("Cp(X_A, X_B) =", format(round(Cp, 3), nsmall = 3)), side=3) # add Cp to plot as text
legend(x = c(-4.5, -2), y = c(0.325, 0.4),legend=c("X_A", "X_B"),
                                          col=c("red", "blue"),
                                          lty=1:2, cex=0.8) # add legend


### Example 2 ###
# If two distributions are equal, Cp will be 0.5.  Cp(X_A,X_A) = 0.5
CpFromDensities(densityX_A, densityX_A, c(-10,10))


### Example 3 ###
densityX_A <- normalDensity(-2,1)
densityX_B <- uniformDensity(c(-2,2))
# Cp(X_A,X_B) = 1 - Cp(X_B, X_A)
CpFromDensities(densityX_A, densityX_B, c(-8,4))
1 - CpFromDensities(densityX_B, densityX_A, c(-8,4))
}
\seealso{
\code{\link{CdFromDensities}}
}
