% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohort.CI.R
\name{cohort.CI}
\alias{cohort.CI}
\title{Bootstrapped confidence intervals - Cohort}
\usage{
cohort.CI(transMatrix,initCount,sim)
}
\arguments{
\item{transMatrix}{list containing average transitions matrices for each time-step.}

\item{initCount}{list containing average start vector counts for each time-step.}

\item{sim}{number of simulations.}
}
\value{
Returns the default probabilites values for the \emph{n} ratings at the 2.5, 5, 25, 50, 75, 95, 97.5 percentiles.
}
\description{
estimate confidence intervals for the TTC transition probabilities using a bootstrapping procedure for cohort method.
}
\details{
The general idea of bootstrapping is to use resampling methods to estimate features of the sampling distribution of
an estimator, especially in situations where 'asymptotic approximations' may provide poor results. In the case of a
\emph{parametric} bootstrap method one samples from the estimated distribution derived using maximum likelihood estimation.
In summary,

\enumerate{
\item Estimate the distribution from the observed sample using maximum likelihood
\item Draw samples from the estimated distribution
\item Calculate the parameter of interest from each of the samples
\item Construct an empirical distribution for the parameter of interest
\item Select percentiles from the empirical distribution
}

One can contrast this method with a \emph{nonparametric bootstrap} in which one samples with replacement from the
empirical cumulative distribution function of the observed sample. Since there are grades with zero observed default
rates, resampling directly from the observed data will not produce meaningful confidence intervals in for credit transition
matrices where historically there are a limited number of defaults in higher credit quality buckets.

The parametric bootstrap method modeled here generates 12-month paths for each obligor represented in the portfolio and
estimates the 12 monthly transition matrices to get a single observation. Annual paths (histories) are simulated using
the estimated monthly transition matrices. A consequence of this approach, is that it is computationally intensive, but once
the bootstrapped distributions of the PD values have been completed, it is simple to identify the percentiles of interest
for calculation of confidence intervals
}
\examples{

\dontrun{

#Set parameters to generate PIT transition matrices
startDate  <- "2000-01-01"
endDate    <- "2005-01-01"
method       <- "cohort"   
snapshots <- 4  
interval <-  .25 
Example<-getPIT(data,startDate, endDate,method, snapshots, interval)

lstInit <- Example$lstInitVec[lapply(Example$lstInitVec,length)>0]
lstCnt <- Example$lstCntMat[lapply(Example$lstCntMat,length)>0]
ExampleTTC <- cohort.TTC(lstCnt,lstInit)

#use $ATMP from the cohort.TTC() as the input into the cohort.CI() function
transMatrix    <- ExampleTTC$ATMP
initCount      <- ExampleTTC$ACP[[1]][,1]
sim            <- 1000
tolerance_Cohort <-cohort.CI(transMatrix,initCount,sim)



Example 2:
#Set parameters to generate PIT transition matrices
startDate  <- "1997-01-01"
endDate    <- "2002-01-01"
method       <- "cohort"   
snapshots <- 12  
interval <-  1 
Example<-getPIT(data,startDate, endDate,method, snapshots, interval)

lstInit <- Example$lstInitVec[lapply(Example$lstInitVec,length)>0]
lstCnt <- Example$lstCntMat[lapply(Example$lstCntMat,length)>0]
ExampleTTC <- cohort.TTC(lstCnt,lstInit)

#use $ATMP from the cohort.TTC() as the input into the cohort.CI() function
transMatrix    <- ExampleTTC$ATMP
initCount      <- ExampleTTC$ACP[[1]][,1]
sim            <- 1000
tolerance_Cohort <-cohort.CI(transMatrix,initCount,sim)
}
}
\references{
Hanson, S. and Schuermann, T. 2005 Confidence Intervals for Probabilities of Default,
Federal Reserve Bank of New York

Jafry, Y. and Schuermann, T. 2003 Metrics for Comparing Credit Migration Matrices,
Wharton Financial Institutions Working Paper 03-08.

Loffler, G., P. N. Posch. 2007 Credit Risk Modeling Using Excel and VBA.
West Sussex, England, Wiley Finance
}
\author{
Abdoulaye (Ab) N'Diaye
}
