% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztnbinom.R
\name{ztnbinom}
\alias{ztnbinom}
\alias{dztnbinom}
\alias{pztnbinom}
\alias{rztnbinom}
\title{Zero-truncated Negative Binomial distribution}
\usage{
dztnbinom(x, size, prob, log = FALSE)

pztnbinom(q, size, prob, lower.tail = TRUE, log.p = FALSE)

rztnbinom(n, size, prob)
}
\arguments{
\item{x, q}{integer vector of counts}

\item{size}{target for number of successful trials, or dispersion parameter (the shape parameter of the gamma mixing distribution). Must be strictly positive, need not be integer.}

\item{prob}{probability of success in each trial. 0 < prob <= 1.}

\item{log, log.p}{logical; return log-density if TRUE}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{n}{number of random values to return.}
}
\value{
\code{dztnbinom} gives the probability mass function, \code{pztnbinom} gives the distribution function, and \code{rztnbinom} generates random deviates.
}
\description{
Probability mass function, distribution function, and random generation for
the zero-truncated Negative Binomial distribution.
}
\details{
This implementation allows for automatic differentiation with \code{RTMB}.

By definition, this distribution only has support on the positive integers (1, 2, ...).
Any zero-truncated distribution is defined as
\deqn{P(X=x | X>0) = P(X=x) / (1 - P(X=0)),}
where \eqn{P(X=x)} is the probability mass function of the corresponding untruncated distribution.
}
\examples{
set.seed(123)
x <- rztnbinom(1, size = 2, prob = 0.5)
d <- dztnbinom(x, size = 2, prob = 0.5)
p <- pztnbinom(x, size = 2, prob = 0.5)
}
