% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewt.R
\name{skewt}
\alias{skewt}
\alias{dskewt}
\alias{pskewt}
\alias{qskewt}
\alias{rskewt}
\title{Skewed students t distribution}
\usage{
dskewt(x, mu = 0, sigma = 1, skew = 0, df = 1000, log = FALSE)

pskewt(q, mu = 0, sigma = 1, skew = 0, df = 1000,
       method = 0, lower.tail = TRUE, log.p = FALSE)

qskewt(p, mu = 0, sigma = 1, skew = 0, df = 1000,
       tol = 1e-8, method = 0)

rskewt(n, mu = 0, sigma = 1, skew = 0, df = 1000)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mu}{location parameter}

\item{sigma}{scale parameter, must be positive.}

\item{skew}{skewness parameter, can be positive or negative.}

\item{df}{degrees of freedom, must be positive.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{method}{an integer value between 0 and 5 which selects the computing method; see ‘Details’ in the \code{\link[sn]{pst}} documentation below for the meaning of these values. If method=0 (default value), an automatic choice is made among the four actual computing methods, depending on the other arguments.}

\item{lower.tail}{logical; if \code{TRUE}, probabilities are \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities}

\item{tol}{a scalar value which regulates the accuracy of the result of qsn, measured on the probability scale.}

\item{n}{number of random values to return.}
}
\value{
\code{dskewt} gives the density, \code{pskewt} gives the distribution function, \code{qskewt} gives the quantile function, and \code{rskewt} generates random deviates.
}
\description{
Density, distribution function, quantile function, and random generation for
the skew t distribution (type 2).
}
\details{
This corresponds to the skew t type 2 distribution in GAMLSS (\code{\link[gamlss.dist]{ST2}}), see pp. 411-412 of Rigby et al. (2019) and the version implemented in the \code{sn} package.
This implementation of \code{dskewt} allows for automatic differentiation with \code{RTMB} while the other functions are imported from the \code{sn} package.
See \code{sn::\link[sn]{dst}} for more details.

\strong{Caution:} In a numerial optimisation, the \code{skew} parameter should NEVER be initialised with exactly zero.
This will cause the initial and all subsequent derivatives to be exactly zero and hence the parameter will remain at its initial value.
}
\examples{
x <- rskewt(1, 1, 2, 5, 2)
d <- dskewt(x, 1, 2, 5, 2)
p <- pskewt(x, 1, 2, 5, 2)
q <- qskewt(p, 1, 2, 5, 2)
}
