% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adcomplex.R
\name{ADcomplex}
\alias{ADcomplex}
\alias{adcomplex}
\alias{Re.adcomplex}
\alias{Im.adcomplex}
\alias{show,adcomplex-method}
\alias{dim.adcomplex}
\alias{dim<-.adcomplex}
\alias{[.adcomplex}
\alias{[<-.adcomplex}
\alias{t.adcomplex}
\alias{length.adcomplex}
\alias{Conj.adcomplex}
\alias{Mod.adcomplex}
\alias{+.adcomplex}
\alias{-.adcomplex}
\alias{*.adcomplex}
\alias{/.adcomplex}
\alias{exp.adcomplex}
\alias{sqrt.adcomplex}
\alias{fft,adcomplex-method}
\alias{fft,advector-method}
\title{AD complex numbers}
\usage{
adcomplex(real, imag = rep(advector(0), length(real)))

\method{Re}{adcomplex}(z)

\method{Im}{adcomplex}(z)

\S4method{show}{adcomplex}(object)

\method{dim}{adcomplex}(x)

\method{dim}{adcomplex}(x) <- value

\method{[}{adcomplex}(x, ...)

\method{[}{adcomplex}(x, ...) <- value

\method{t}{adcomplex}(x)

\method{length}{adcomplex}(x)

\method{Conj}{adcomplex}(z)

\method{Mod}{adcomplex}(z)

\method{+}{adcomplex}(x, y)

\method{-}{adcomplex}(x, y)

\method{*}{adcomplex}(x, y)

\method{/}{adcomplex}(x, y)

\method{exp}{adcomplex}(x)

\method{sqrt}{adcomplex}(x)

\S4method{fft}{adcomplex}(z, inverse = FALSE)

\S4method{fft}{advector}(z, inverse = FALSE)
}
\arguments{
\item{real}{Real part}

\item{imag}{Imaginary part}

\item{z}{An object of class \code{'adcomplex'}}

\item{object}{An object of class \code{'adcomplex'}}

\item{x}{An object of class \code{'adcomplex'}}

\item{value}{Replacement value}

\item{...}{As \link[base]{[}}

\item{y}{An object of class \code{'adcomplex'}}

\item{inverse}{As \link[stats]{fft}}
}
\value{
Object of class \code{"adcomplex"}.
}
\description{
A limited set of complex number operations can be used when constructing AD tapes. The available methods are listed in this help page.
}
\section{Functions}{
\itemize{
\item \code{adcomplex()}: Construct \code{adcomplex} vector

\item \code{Re(adcomplex)}: As \link[base]{complex}

\item \code{Im(adcomplex)}: As \link[base]{complex}

\item \code{show(adcomplex)}: Print method

\item \code{dim(adcomplex)}: As \link[base]{dim}

\item \code{dim(adcomplex) <- value}: As \link[base]{dim}

\item \code{[}: As \link[base]{[}

\item \code{`[`(adcomplex) <- value}: As \link[base]{[<-}

\item \code{t(adcomplex)}: As \link[base]{t}

\item \code{length(adcomplex)}: As \link[base]{length}

\item \code{Conj(adcomplex)}: As \link[base]{complex}

\item \code{Mod(adcomplex)}: As \link[base]{complex}

\item \code{ + }: As \link[base]{complex}

\item \code{ - }: As \link[base]{complex}

\item \code{ * }: As \link[base]{complex}

\item \code{ / }: As \link[base]{complex}

\item \code{exp(adcomplex)}: As \link[base]{complex}

\item \code{sqrt(adcomplex)}: As \link[base]{complex}

\item \code{fft(adcomplex)}: Fast Fourier Transform equivalent to \link[stats]{fft}. Notably this is the \strong{multivariate} transform when \code{x} is an array.

\item \code{fft(advector)}: If real input is supplied it is first converted to complex.

}}
\examples{
## Tape using complex operations
F <- MakeTape(function(x) {
  x <- as.complex(x)
  y <- exp( x * ( 1 + 2i ) )
  c(Re(y), Im(y))
}, numeric(1))
F
F(1)
## Complex FFT on the tape
G <- MakeTape(function(x) sum(Re(fft(x))), numeric(3))
G$simplify()
G$print()
}
