% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGIS.R
\name{getGIS}
\alias{getGIS}
\title{Extract and convert GIS data from a URL}
\usage{
getGIS(
  url = "https://gis.energy.gov.ab.ca/GeoviewData/OS_Agreements_Shape.zip"
)
}
\arguments{
\item{url}{URL of the zipped shapefile. \code{character}}
}
\value{
SpatialPointsDataFrame. \code{SpatialPolygonsDataFrame}
}
\description{
Returns a SpatialPointsDataFrame from a shapefile URL.
@section Examples with EIA and Government of Alberta
\itemize{
\item from https://www.eia.gov/maps/layer_info-m.php :
\item crudepipelines <- getGIS(url = "https://www.eia.gov/maps/map_data/CrudeOil_Pipelines_US_EIA.zip")
\item refineries <- getGIS(url = "https://www.eia.gov/maps/map_data/Petroleum_Refineries_US_EIA.zip")
\item from https://gis.energy.gov.ab.ca/Geoview/OSPNG
\item AB <- getGIS(url = "https://gis.energy.gov.ab.ca/GeoviewData/OS_Agreements_Shape.zip")
}
}
\examples{
\dontrun{
getGIS(url = "https://gis.energy.gov.ab.ca/GeoviewData/OS_Agreements_Shape.zip")
}

}
\author{
Philippe Cote
}
