% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rolladjust.R
\name{rolladjust}
\alias{rolladjust}
\title{Adjusts daily returns for futures contracts roll}
\usage{
rolladjust(x, commodityname = c("cmewti"), rolltype = c("Last.Trade"), ...)
}
\arguments{
\item{x}{A df of returns.}

\item{commodityname}{Name of commodity in expiry_table: unique(expiry_table$cmdty) or "cmecan" for WCW}

\item{rolltype}{Type of contract roll: "Last.Trade" or "First.Notice".}

\item{...}{Other parms}
}
\value{
Roll-adjusted xts object of returns
}
\description{
Returns a xts price or return object adjusted for contract roll. The methodology used to adjust returns is to remove the daily returns on the day after expiry and for prices to adjust historical rolling front month contracts by the size of the roll at each expiry. This is conducive to quantitative trading strategies as it reflects the PL of a financial trader.
}
\examples{
ret <- dplyr::tibble(date = seq.Date(Sys.Date() - 60, Sys.Date(), 1), CL01 = rnorm(61, 0, 1))
rolladjust(x = ret, commodityname = c("cmewti"), rolltype = c("Last.Trade"))
}
\author{
Philippe Cote
}
