% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_standardize_samples.R
\name{standardize_samples}
\alias{standardize_samples}
\title{Age-standardize samples}
\usage{
standardize_samples(
  sample,
  std_pop,
  margin,
  groups = NULL,
  bind_new = FALSE,
  new_name = NULL
)
}
\arguments{
\item{sample}{an \code{array} of samples imported with \code{load_samples()}}

\item{std_pop}{A vector of standard populations.}

\item{margin}{For \code{array}s, The margin on which the groups of interest are stratified.}

\item{groups}{A vector of either indices for each group or a vector of strings for each group name. If set to \code{NULL}, will use all groups in the dataset.}

\item{bind_new}{If set to \code{TRUE}, will bind an \code{array} to the original sample dataset. Otherwise, will generate a standalone array of samples.}

\item{new_name}{The name to assign to the age-standardized group.}
}
\value{
An \code{array} of age-standardized samples.
}
\description{
Age-standardizes samples using a standard population.
}
\examples{
std_pop <- c(113154, 100640, 95799)
age_margin <- 2
# age-standardize by all age groups
samples_3564 <- standardize_samples(minsample, std_pop, age_margin)
# age-standardize only by the first two age groups
samples_3554 <- standardize_samples(minsample, std_pop[1:2], age_margin, groups = 1:2)
# bind age-standardized samples to original samples
samples_as <- standardize_samples(
  minsample,
  std_pop,
  age_margin,
  bind_new = TRUE,
  new_name = "35-64"
)
}
