% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLiteResult.R, R/query.R
\docType{class}
\name{SQLiteResult-class}
\alias{SQLiteResult-class}
\alias{dbIsValid,SQLiteResult-method}
\alias{dbBind,SQLiteResult-method}
\alias{dbFetch,SQLiteResult-method}
\alias{dbClearResult,SQLiteResult-method}
\alias{dbColumnInfo,SQLiteResult-method}
\alias{dbGetRowsAffected,SQLiteResult-method}
\alias{dbGetRowCount,SQLiteResult-method}
\alias{dbHasCompleted,SQLiteResult-method}
\alias{dbGetStatement,SQLiteResult-method}
\title{Class SQLiteResult (and methods)}
\usage{
\S4method{dbIsValid}{SQLiteResult}(dbObj, ...)

\S4method{dbBind}{SQLiteResult}(res, params, ...)

\S4method{dbFetch}{SQLiteResult}(
  res,
  n = -1,
  ...,
  row.names = pkgconfig::get_config("RSQLite::row.names.query", FALSE)
)

\S4method{dbClearResult}{SQLiteResult}(res, ...)

\S4method{dbColumnInfo}{SQLiteResult}(res, ...)

\S4method{dbGetRowsAffected}{SQLiteResult}(res, ...)

\S4method{dbGetRowCount}{SQLiteResult}(res, ...)

\S4method{dbHasCompleted}{SQLiteResult}(res, ...)

\S4method{dbGetStatement}{SQLiteResult}(res, ...)
}
\description{
SQLiteDriver objects are created by \code{\link[=dbSendQuery]{dbSendQuery()}} or \code{\link[=dbSendStatement]{dbSendStatement()}},
and encapsulate the result of an SQL statement (either \code{SELECT} or not).
They are a superclass of the \linkS4class{DBIResult} class.
The "Usage" section lists the class methods overridden by \pkg{RSQLite}.
}
\seealso{
The corresponding generic functions
\code{\link[DBI:dbFetch]{DBI::dbFetch()}}, \code{\link[DBI:dbClearResult]{DBI::dbClearResult()}}, and \code{\link[DBI:dbBind]{DBI::dbBind()}},
\code{\link[DBI:dbColumnInfo]{DBI::dbColumnInfo()}}, \code{\link[DBI:dbGetRowsAffected]{DBI::dbGetRowsAffected()}}, \code{\link[DBI:dbGetRowCount]{DBI::dbGetRowCount()}},
\code{\link[DBI:dbHasCompleted]{DBI::dbHasCompleted()}}, and \code{\link[DBI:dbGetStatement]{DBI::dbGetStatement()}}.
}
\keyword{internal}
