% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-lib.R
\name{RSQL.class}
\alias{RSQL.class}
\title{The class that provides the SQL functionality.}
\description{
This class is intended to simplify SQL commands.
}
\examples{
library(RSQL)
db.name <- getMtcarsdbPath(copy = TRUE)
rsql <- createRSQL(drv = RSQLite::SQLite(), dbname = db.name)
where_values_df <- data.frame(carb = 8, stringsAsFactors = FALSE)
select_sql <- rsql$gen_select(
 select_fields = "*", #c("wt", "qsec"),
 table = "mtcars",
 where_values = where_values_df)
mtcars.observed <- rsql$execute_select(select_sql)
 mtcars.observed

 mtcars.new <- mtcars.observed
mtcars.new$carb <- 9
insert_sql <- rsql$gen_insert(table = "mtcars", values_df = mtcars.new)
rsql$execute_insert(sql_insert = insert_sql)

where_values_df <- data.frame(carb = 9, stringsAsFactors = FALSE)
select_sql <- rsql$gen_select(
  select_fields = "*", #c("wt", "qsec"),
 table = "mtcars",
 where_values = where_values_df)
mtcars.observed <- rsql$execute_select(select_sql)
mtcars.observed

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{driver}}{driver  name}

\item{\code{db.name}}{database name}

\item{\code{available.functions}}{for generating select expressions}

\item{\code{entity.field.regexp}}{for scrape a field or table expression}

\item{\code{entity.select.regexp}}{for scrape a select expressions expression}

\item{\code{conn}}{The connection handler}

\item{\code{last.query}}{The last query}

\item{\code{last.rs}}{The last resultset}

\item{\code{select.counter}}{An instance select counter}

\item{\code{insert.counter}}{An instance insert counter}

\item{\code{update.counter}}{An instance update counter}

\item{\code{delete.counter}}{An instance delete counter}

\item{\code{command.counter}}{An instance command counter}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{RSQL.class$new()}}
\item \href{#method-setupRegexp}{\code{RSQL.class$setupRegexp()}}
\item \href{#method-finalize}{\code{RSQL.class$finalize()}}
\item \href{#method-checkEntitiesNames}{\code{RSQL.class$checkEntitiesNames()}}
\item \href{#method-gen_select}{\code{RSQL.class$gen_select()}}
\item \href{#method-gen_insert}{\code{RSQL.class$gen_insert()}}
\item \href{#method-gen_update}{\code{RSQL.class$gen_update()}}
\item \href{#method-gen_delete}{\code{RSQL.class$gen_delete()}}
\item \href{#method-execute_select}{\code{RSQL.class$execute_select()}}
\item \href{#method-execute_update}{\code{RSQL.class$execute_update()}}
\item \href{#method-execute_insert}{\code{RSQL.class$execute_insert()}}
\item \href{#method-execute_command}{\code{RSQL.class$execute_command()}}
\item \href{#method-execute_delete}{\code{RSQL.class$execute_delete()}}
\item \href{#method-retrieve}{\code{RSQL.class$retrieve()}}
\item \href{#method-retrieve_insert}{\code{RSQL.class$retrieve_insert()}}
\item \href{#method-disconnect}{\code{RSQL.class$disconnect()}}
\item \href{#method-clone}{\code{RSQL.class$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initializes a connection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$new(
  drv,
  dbname,
  user = NULL,
  password = NULL,
  host = NULL,
  port = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{drv}}{driver name}

\item{\code{dbname}}{database name}

\item{\code{user}}{user name}

\item{\code{password}}{password}

\item{\code{host}}{host name}

\item{\code{port}}{port number}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setupRegexp"></a>}}
\if{latex}{\out{\hypertarget{method-setupRegexp}{}}}
\subsection{Method \code{setupRegexp()}}{
initialize regexp for scraping entities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$setupRegexp(force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{force setup?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
regexp for scraping select expressions
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Class destructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-checkEntitiesNames"></a>}}
\if{latex}{\out{\hypertarget{method-checkEntitiesNames}{}}}
\subsection{Method \code{checkEntitiesNames()}}{
Checks if an entity exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$checkEntitiesNames(entities, entity.type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entities}}{entities to check}

\item{\code{entity.type}}{entity type to check against}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gen_select"></a>}}
\if{latex}{\out{\hypertarget{method-gen_select}{}}}
\subsection{Method \code{gen_select()}}{
Generates a select
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$gen_select(
  select_fields,
  table,
  where_fields = names(where_values),
  where_values = NULL,
  group_by = c(),
  order_by = c(),
  top = 0,
  distinct = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{select_fields}}{fields to be selected}

\item{\code{table}}{table to select from}

\item{\code{where_fields}}{fields in the where clause}

\item{\code{where_values}}{values to the fields on the where clause}

\item{\code{group_by}}{fields to group by}

\item{\code{order_by}}{fields to order by}

\item{\code{top}}{where does the resultset starts?}

\item{\code{distinct}}{provides a way to select distinct rows}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gen_insert"></a>}}
\if{latex}{\out{\hypertarget{method-gen_insert}{}}}
\subsection{Method \code{gen_insert()}}{
Generate  insert statement
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$gen_insert(table, values_df, insert_fields = names(values_df))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{The table to insert into}

\item{\code{values_df}}{The values to insert. Must be defined as data.frame of values}

\item{\code{insert_fields}}{the fields to insert into}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gen_update"></a>}}
\if{latex}{\out{\hypertarget{method-gen_update}{}}}
\subsection{Method \code{gen_update()}}{
Generate  insert statement
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$gen_update(
  table,
  update_fields = names(values),
  values,
  where_fields = names(where_values),
  where_values = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{the table to insert into}

\item{\code{update_fields}}{the fields to update}

\item{\code{values}}{the values to update}

\item{\code{where_fields}}{a where clause to the insert}

\item{\code{where_values}}{the values to add to the where clause}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gen_delete"></a>}}
\if{latex}{\out{\hypertarget{method-gen_delete}{}}}
\subsection{Method \code{gen_delete()}}{
Generate a delete statement
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$gen_delete(
  table,
  where_fields = names(where_values),
  where_values = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{the table to insert into}

\item{\code{where_fields}}{a where clause to the insert}

\item{\code{where_values}}{the fields to add to the where clause}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute_select"></a>}}
\if{latex}{\out{\hypertarget{method-execute_select}{}}}
\subsection{Method \code{execute_select()}}{
Performs an execution on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_select(sql_select)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_select}}{the sql select statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute_update"></a>}}
\if{latex}{\out{\hypertarget{method-execute_update}{}}}
\subsection{Method \code{execute_update()}}{
Performs an update on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_update(sql_update)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_update}}{the sql update statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute_insert"></a>}}
\if{latex}{\out{\hypertarget{method-execute_insert}{}}}
\subsection{Method \code{execute_insert()}}{
Performs an insert on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_insert(sql_insert)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_insert}}{the sql insert statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute_command"></a>}}
\if{latex}{\out{\hypertarget{method-execute_command}{}}}
\subsection{Method \code{execute_command()}}{
Performs a command on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_command(sql_command)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_command}}{the sql statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-execute_delete"></a>}}
\if{latex}{\out{\hypertarget{method-execute_delete}{}}}
\subsection{Method \code{execute_delete()}}{
Performs an deletion on the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$execute_delete(sql_delete)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sql_delete}}{the sql delete statement to perform}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Performs an insert on the database. This is a composite function
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$retrieve(
  table,
  fields_uk = names(values_uk),
  values_uk,
  fields = names(values),
  values,
  field_id = "id"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{The table}

\item{\code{fields_uk}}{The fields unique key}

\item{\code{values_uk}}{The values unique key}

\item{\code{fields}}{The fields (Not used. Included for compatibility)}

\item{\code{values}}{The values (Not used. Included for compatibility)}

\item{\code{field_id}}{The field of the serial id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-retrieve_insert"></a>}}
\if{latex}{\out{\hypertarget{method-retrieve_insert}{}}}
\subsection{Method \code{retrieve_insert()}}{
Obtain id if object exists on the database. Insert object if not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$retrieve_insert(
  table,
  fields_uk = names(values_uk),
  values_uk,
  fields = names(values),
  values,
  field_id = "id"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{The table}

\item{\code{fields_uk}}{The fields unique key}

\item{\code{values_uk}}{The values unique key}

\item{\code{fields}}{The fields}

\item{\code{values}}{The values}

\item{\code{field_id}}{The field of the serial id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-disconnect"></a>}}
\if{latex}{\out{\hypertarget{method-disconnect}{}}}
\subsection{Method \code{disconnect()}}{
Disconnects the instance from the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$disconnect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RSQL.class$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
