/*
 * Decompiled with CFR 0.152.
 */
package org.act.cat;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.act.cat.CatConfig;
import org.act.cat.CatInput;
import org.act.cat.ExposureControlData;
import org.act.cat.ItemScores;
import org.act.cat.PassageOrItemEligibilityOverall;
import org.act.testdef.Item;
import org.act.testdef.TestConfig;
import org.act.util.PrimitiveArraySet;

public class CatInputStandard
implements CatInput {
    private final CatConfig catConfig;
    private final TestConfig testConfig;
    private int completedCount;
    private int adaptiveStage;
    private final String examineeId;
    private List<String> itemsAdmin;
    private ItemScores itemScores;
    private final PrimitiveArraySet itemPoolDataSet;
    private final List<Integer> administeredPassageIndexSequence;
    private final ExposureControlData exposureControlData;
    private final PassageOrItemEligibilityOverall passageOrItemEligibilityOverall;
    private final List<String> itemsToAdminister;
    private final List<String> shadowTest;
    private final double previousTheta;
    private final double previousThetaSe;

    private CatInputStandard(CatConfig catConfig, TestConfig testConfig, int completedCount, int adaptiveStage, String studentId, List<String> itemsAdmin, ItemScores itemScores, List<Integer> passageRowIndexSequence, ExposureControlData exposureControlData, PassageOrItemEligibilityOverall passageOrItemEligibilityOverall, List<String> itemsToAdminister, List<String> shadowTest, double previousTheta, double previousThetaSe) {
        this.catConfig = catConfig;
        this.testConfig = testConfig;
        this.completedCount = completedCount;
        this.adaptiveStage = adaptiveStage;
        this.examineeId = studentId;
        this.itemsAdmin = itemsAdmin;
        this.itemScores = itemScores;
        this.itemPoolDataSet = this.convertItemPoolDataSet();
        this.administeredPassageIndexSequence = passageRowIndexSequence;
        this.exposureControlData = exposureControlData;
        this.passageOrItemEligibilityOverall = passageOrItemEligibilityOverall;
        this.itemsToAdminister = itemsToAdminister;
        this.shadowTest = shadowTest;
        this.previousTheta = previousTheta;
        this.previousThetaSe = previousThetaSe;
    }

    @Override
    public CatConfig getCatConfig() {
        return this.catConfig;
    }

    @Override
    public TestConfig getTestConfig() {
        return this.testConfig;
    }

    @Override
    public int getCompletedCount() {
        return this.completedCount;
    }

    @Override
    public int getAdaptiveStage() {
        return this.adaptiveStage;
    }

    @Override
    public String getExamineeId() {
        return this.examineeId;
    }

    @Override
    public List<String> getItemsAdmin() {
        return this.itemsAdmin;
    }

    @Override
    public ItemScores getItemScores() {
        return this.itemScores;
    }

    @Override
    public ExposureControlData getExposureControlData() {
        return this.exposureControlData;
    }

    @Override
    public PassageOrItemEligibilityOverall getPassageOrItemEligibility() {
        return this.passageOrItemEligibilityOverall;
    }

    @Override
    public List<Integer> getAdministeredPassageIndexSequence() {
        return this.administeredPassageIndexSequence;
    }

    @Override
    public PassageOrItemEligibilityOverall getPassageOrItemEligibilityOverall() {
        return this.getPassageOrItemEligibility();
    }

    @Override
    public List<String> getItemsToAdminister() {
        return this.itemsToAdminister;
    }

    @Override
    public List<String> getShadowTest() {
        return this.shadowTest;
    }

    @Override
    public List<String> getItemIds() {
        return Arrays.asList(this.itemPoolDataSet.getStringArrayCopy(Item.ColumnName.ITEM_ID.getColName()));
    }

    @Override
    public double getPreviousTheta() {
        return this.previousTheta;
    }

    @Override
    public double getPreviousThetaSe() {
        return this.previousThetaSe;
    }

    @Override
    public PrimitiveArraySet getItemPoolDataSet() {
        return this.itemPoolDataSet;
    }

    private PrimitiveArraySet convertItemPoolDataSet() {
        HashMap columnTypes = new HashMap();
        columnTypes.put(Item.ColumnName.ITEM_ID.getColName(), String[].class);
        columnTypes.put(Item.ColumnName.ITEM_PASSAGE_ID.getColName(), String[].class);
        columnTypes.put(Item.ColumnName.A_PARAM.getColName(), double[].class);
        columnTypes.put(Item.ColumnName.A_PARAM_SE.getColName(), double[].class);
        columnTypes.put(Item.ColumnName.B_PARAM.getColName(), double[].class);
        columnTypes.put(Item.ColumnName.B_PARAM_SE.getColName(), double[].class);
        columnTypes.put(Item.ColumnName.C_PARAM.getColName(), double[].class);
        columnTypes.put(Item.ColumnName.C_PARAM_SE.getColName(), double[].class);
        columnTypes.put(Item.ColumnName.D_CONSTANT.getColName(), double[].class);
        return PrimitiveArraySet.fromContentTable(this.testConfig.getItemPoolTable(), columnTypes);
    }

    public static class Builder {
        private CatConfig catConfig;
        private TestConfig testConfig;
        private int completedCount;
        private int adaptiveStage;
        private String studentId;
        private List<String> itemsAdmin;
        private ItemScores itemScores;
        private List<Integer> administeredPassageIndexSequence;
        private ExposureControlData exposureControlData;
        private PassageOrItemEligibilityOverall passageOrItemEligibilityOverall;
        private List<String> itemsToAdminister;
        private List<String> shadowTest;
        private double previousTheta;
        private double previousThetaSe;

        public Builder catConfig(CatConfig aCatConfig) {
            this.catConfig = aCatConfig;
            return this;
        }

        public Builder testConfig(TestConfig aTestConfig) {
            this.testConfig = aTestConfig;
            return this;
        }

        public Builder completedCount(int aCompletedCount) {
            this.completedCount = aCompletedCount;
            return this;
        }

        public Builder adaptiveStage(int anAdaptiveStage) {
            this.adaptiveStage = anAdaptiveStage;
            return this;
        }

        public Builder studentId(String aStudentId) {
            this.studentId = aStudentId;
            return this;
        }

        public Builder itemsAdmin(List<String> newItemsAdmin) {
            this.itemsAdmin = newItemsAdmin;
            return this;
        }

        public Builder itemScores(ItemScores newItemScores) {
            this.itemScores = newItemScores;
            return this;
        }

        public Builder administeredPassageIndexSequence(List<Integer> newAdministeredPassageIndexSequence) {
            this.administeredPassageIndexSequence = newAdministeredPassageIndexSequence;
            return this;
        }

        public Builder exposureControlData(ExposureControlData anExposureControlData) {
            this.exposureControlData = anExposureControlData;
            return this;
        }

        public Builder passageOrItemEligibilityOverall(PassageOrItemEligibilityOverall aPassageOrItemEligibilityOverall) {
            this.passageOrItemEligibilityOverall = aPassageOrItemEligibilityOverall;
            return this;
        }

        public Builder itemsToAdminister(List<String> newItemsToAdminister) {
            this.itemsToAdminister = newItemsToAdminister;
            return this;
        }

        public Builder shadowTest(List<String> aShadowTest) {
            this.shadowTest = aShadowTest;
            return this;
        }

        public Builder previousTheta(double aPreviousTheta) {
            this.previousTheta = aPreviousTheta;
            return this;
        }

        public Builder previousThetaSe(double aPreviousThetaSe) {
            this.previousThetaSe = aPreviousThetaSe;
            return this;
        }

        public CatInputStandard build() {
            CatInputStandard catInputStandard = new CatInputStandard(this.catConfig, this.testConfig, this.completedCount, this.adaptiveStage, this.studentId, this.itemsAdmin, this.itemScores, this.administeredPassageIndexSequence, this.exposureControlData, this.passageOrItemEligibilityOverall, this.itemsToAdminister, this.shadowTest, this.previousTheta, this.previousThetaSe);
            return catInputStandard;
        }
    }
}

