% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Kuk.R
\name{Kuk}
\alias{Kuk}
\title{Kuk model}
\usage{
Kuk(z,p1,p2,k,pi,type=c("total","mean"),cl,N=NULL,pij=NULL)
}
\arguments{
\item{z}{vector of the observed variable; its length is equal to \eqn{n} (the sample size)}

\item{p1}{proportion of red cards in the first box}

\item{p2}{proportion of red cards in the second box}

\item{k}{total number of cards drawn}

\item{pi}{vector of the first-order inclusion probabilities}

\item{type}{the estimator type: total or mean}

\item{cl}{confidence level}

\item{N}{size of the population. By default it is NULL}

\item{pij}{matrix of the second-order inclusion probabilities. By default it is NULL}
}
\value{
Point and confidence estimates of the sensitive characteristics using the Kuk model. The transformed variable is also reported, if required.
}
\description{
Computes the randomized response estimation, its variance estimation and its confidence through the Kuk model.
The function can also return the transformed variable.
The Kuk model was proposed by Kuk in 1990.
}
\details{
In the Kuk randomized response technique, the sampled person \eqn{i} is offered two boxes. Each box contains cards that are identical exception colour, either red
or white, in sufficiently large numbers with proportions \eqn{p_1} and \eqn{1-p_1} in the first and \eqn{p_2} and \eqn{1-p_2}, in the second (\eqn{p_1\neq p_2}).
The person sampled is requested to use the first box, if his/her trait is \eqn{A} and the second box if his/her trait is \eqn{A^c} and to make \eqn{k} independent
draws of cards, with replacement each time. The person is asked to reports \eqn{z_i=f_i}, the number of times a red card is drawn.

The transformed variable is \eqn{r_i=\frac{f_i/k-p_2}{p_1-p_2}} and the estimated variance is \eqn{\widehat{V}_R(r_i)=br_i+c},
where \eqn{b=\frac{1-p_1-p_2}{k(p_1-p_2)}} and \eqn{c=\frac{p_2(1-p_2)}{k(p_1-p_2)^2}}.
}
\examples{
N=802
data(KukData)
dat=with(KukData,data.frame(z,Pi))
p1=0.6
p2=0.2
k=25
cl=0.95
Kuk(dat$z,p1,p2,k,dat$Pi,"mean",cl,N)
}
\references{
Kuk, A.Y.C. (1990).
\emph{Asking sensitive questions indirectly.}
 Biometrika, 77, 436-438.
}
\seealso{
\code{\link{KukData}}

\code{\link{ResamplingVariance}}
}
\keyword{Confidence_interval}
\keyword{Estimation}
\keyword{Kuk}
\keyword{Qualitative}
\keyword{Randomized_response}
\keyword{Transformed_variable}
\keyword{Variance}

